/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ExportManifestRequest.Builder.class
)
public final class ExportManifestRequest {
  private final Optional<List<String>> rules;

  private final Optional<List<String>> flows;

  private final Optional<List<String>> contexts;

  private final Optional<List<String>> values;

  private final Optional<Boolean> includeAll;

  private final Optional<Boolean> preview;

  private final Map<String, Object> additionalProperties;

  private ExportManifestRequest(Optional<List<String>> rules, Optional<List<String>> flows,
      Optional<List<String>> contexts, Optional<List<String>> values, Optional<Boolean> includeAll,
      Optional<Boolean> preview, Map<String, Object> additionalProperties) {
    this.rules = rules;
    this.flows = flows;
    this.contexts = contexts;
    this.values = values;
    this.includeAll = includeAll;
    this.preview = preview;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Rule IDs or slugs to export.
   */
  @JsonProperty("rules")
  public Optional<List<String>> getRules() {
    return rules;
  }

  /**
   * @return Flow IDs or slugs to export.
   */
  @JsonProperty("flows")
  public Optional<List<String>> getFlows() {
    return flows;
  }

  /**
   * @return Context IDs or slugs to export.
   */
  @JsonProperty("contexts")
  public Optional<List<String>> getContexts() {
    return contexts;
  }

  /**
   * @return Value IDs or names to export.
   */
  @JsonProperty("values")
  public Optional<List<String>> getValues() {
    return values;
  }

  /**
   * @return Export all assets of specified types.
   */
  @JsonProperty("includeAll")
  public Optional<Boolean> getIncludeAll() {
    return includeAll;
  }

  /**
   * @return Return a preview of what would be exported without the full data.
   */
  @JsonProperty("preview")
  public Optional<Boolean> getPreview() {
    return preview;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ExportManifestRequest && equalTo((ExportManifestRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ExportManifestRequest other) {
    return rules.equals(other.rules) && flows.equals(other.flows) && contexts.equals(other.contexts) && values.equals(other.values) && includeAll.equals(other.includeAll) && preview.equals(other.preview);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.rules, this.flows, this.contexts, this.values, this.includeAll, this.preview);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<List<String>> rules = Optional.empty();

    private Optional<List<String>> flows = Optional.empty();

    private Optional<List<String>> contexts = Optional.empty();

    private Optional<List<String>> values = Optional.empty();

    private Optional<Boolean> includeAll = Optional.empty();

    private Optional<Boolean> preview = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ExportManifestRequest other) {
      rules(other.getRules());
      flows(other.getFlows());
      contexts(other.getContexts());
      values(other.getValues());
      includeAll(other.getIncludeAll());
      preview(other.getPreview());
      return this;
    }

    /**
     * <p>Rule IDs or slugs to export.</p>
     */
    @JsonSetter(
        value = "rules",
        nulls = Nulls.SKIP
    )
    public Builder rules(Optional<List<String>> rules) {
      this.rules = rules;
      return this;
    }

    public Builder rules(List<String> rules) {
      this.rules = Optional.ofNullable(rules);
      return this;
    }

    /**
     * <p>Flow IDs or slugs to export.</p>
     */
    @JsonSetter(
        value = "flows",
        nulls = Nulls.SKIP
    )
    public Builder flows(Optional<List<String>> flows) {
      this.flows = flows;
      return this;
    }

    public Builder flows(List<String> flows) {
      this.flows = Optional.ofNullable(flows);
      return this;
    }

    /**
     * <p>Context IDs or slugs to export.</p>
     */
    @JsonSetter(
        value = "contexts",
        nulls = Nulls.SKIP
    )
    public Builder contexts(Optional<List<String>> contexts) {
      this.contexts = contexts;
      return this;
    }

    public Builder contexts(List<String> contexts) {
      this.contexts = Optional.ofNullable(contexts);
      return this;
    }

    /**
     * <p>Value IDs or names to export.</p>
     */
    @JsonSetter(
        value = "values",
        nulls = Nulls.SKIP
    )
    public Builder values(Optional<List<String>> values) {
      this.values = values;
      return this;
    }

    public Builder values(List<String> values) {
      this.values = Optional.ofNullable(values);
      return this;
    }

    /**
     * <p>Export all assets of specified types.</p>
     */
    @JsonSetter(
        value = "includeAll",
        nulls = Nulls.SKIP
    )
    public Builder includeAll(Optional<Boolean> includeAll) {
      this.includeAll = includeAll;
      return this;
    }

    public Builder includeAll(Boolean includeAll) {
      this.includeAll = Optional.ofNullable(includeAll);
      return this;
    }

    /**
     * <p>Return a preview of what would be exported without the full data.</p>
     */
    @JsonSetter(
        value = "preview",
        nulls = Nulls.SKIP
    )
    public Builder preview(Optional<Boolean> preview) {
      this.preview = preview;
      return this;
    }

    public Builder preview(Boolean preview) {
      this.preview = Optional.ofNullable(preview);
      return this;
    }

    public ExportManifestRequest build() {
      return new ExportManifestRequest(rules, flows, contexts, values, includeAll, preview, additionalProperties);
    }
  }
}
