/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.resources.assets.types.ImportManifestRequestManifest;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ImportManifestRequest.Builder.class
)
public final class ImportManifestRequest {
  private final ImportManifestRequestManifest manifest;

  private final Optional<Boolean> overwrite;

  private final Map<String, Object> additionalProperties;

  private ImportManifestRequest(ImportManifestRequestManifest manifest, Optional<Boolean> overwrite,
      Map<String, Object> additionalProperties) {
    this.manifest = manifest;
    this.overwrite = overwrite;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The RBM manifest object containing assets to import.
   */
  @JsonProperty("manifest")
  public ImportManifestRequestManifest getManifest() {
    return manifest;
  }

  /**
   * @return Whether to overwrite existing assets with the same ID/slug.
   */
  @JsonProperty("overwrite")
  public Optional<Boolean> getOverwrite() {
    return overwrite;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ImportManifestRequest && equalTo((ImportManifestRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ImportManifestRequest other) {
    return manifest.equals(other.manifest) && overwrite.equals(other.overwrite);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.manifest, this.overwrite);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static ManifestStage builder() {
    return new Builder();
  }

  public interface ManifestStage {
    /**
     * <p>The RBM manifest object containing assets to import.</p>
     */
    _FinalStage manifest(@NotNull ImportManifestRequestManifest manifest);

    Builder from(ImportManifestRequest other);
  }

  public interface _FinalStage {
    ImportManifestRequest build();

    /**
     * <p>Whether to overwrite existing assets with the same ID/slug.</p>
     */
    _FinalStage overwrite(Optional<Boolean> overwrite);

    _FinalStage overwrite(Boolean overwrite);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements ManifestStage, _FinalStage {
    private ImportManifestRequestManifest manifest;

    private Optional<Boolean> overwrite = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(ImportManifestRequest other) {
      manifest(other.getManifest());
      overwrite(other.getOverwrite());
      return this;
    }

    /**
     * <p>The RBM manifest object containing assets to import.</p>
     * <p>The RBM manifest object containing assets to import.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("manifest")
    public _FinalStage manifest(@NotNull ImportManifestRequestManifest manifest) {
      this.manifest = Objects.requireNonNull(manifest, "manifest must not be null");
      return this;
    }

    /**
     * <p>Whether to overwrite existing assets with the same ID/slug.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage overwrite(Boolean overwrite) {
      this.overwrite = Optional.ofNullable(overwrite);
      return this;
    }

    /**
     * <p>Whether to overwrite existing assets with the same ID/slug.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "overwrite",
        nulls = Nulls.SKIP
    )
    public _FinalStage overwrite(Optional<Boolean> overwrite) {
      this.overwrite = overwrite;
      return this;
    }

    @java.lang.Override
    public ImportManifestRequest build() {
      return new ImportManifestRequest(manifest, overwrite, additionalProperties);
    }
  }
}
