/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets.rules;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.MediaTypes;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.QueryStringMapper;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.core.RulebricksApiHttpResponse;
import com.rulebricks.errors.BadRequestError;
import com.rulebricks.errors.ForbiddenError;
import com.rulebricks.errors.InternalServerError;
import com.rulebricks.errors.NotFoundError;
import com.rulebricks.resources.assets.rules.requests.DeleteRuleRequest;
import com.rulebricks.resources.assets.rules.requests.ImportRuleRequest;
import com.rulebricks.resources.assets.rules.requests.ListRulesRequest;
import com.rulebricks.resources.assets.rules.requests.PullRulesRequest;
import com.rulebricks.types.RuleDetail;
import com.rulebricks.types.SuccessMessage;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawRulesClient {
  protected final ClientOptions clientOptions;

  public AsyncRawRulesClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Delete a specific rule by its ID.
   */
  public CompletableFuture<RulebricksApiHttpResponse<SuccessMessage>> delete(
      DeleteRuleRequest request) {
    return delete(request,null);
  }

  /**
   * Delete a specific rule by its ID.
   */
  public CompletableFuture<RulebricksApiHttpResponse<SuccessMessage>> delete(
      DeleteRuleRequest request, RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/rules/delete")
      .build();
    RequestBody body;
    try {
      body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
    }
    catch(JsonProcessingException e) {
      throw new RulebricksApiException("Failed to serialize request", e);
    }
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("DELETE", body)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .addHeader("Accept", "application/json")
      .build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    CompletableFuture<RulebricksApiHttpResponse<SuccessMessage>> future = new CompletableFuture<>();
    client.newCall(okhttpRequest).enqueue(new Callback() {
      @Override
      public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try (ResponseBody responseBody = response.body()) {
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          if (response.isSuccessful()) {
            future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, SuccessMessage.class), response));
            return;
          }
          try {
            switch (response.code()) {
              case 400:future.completeExceptionally(new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
              case 404:future.completeExceptionally(new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
              case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
            }
          }
          catch (JsonProcessingException ignored) {
            // unable to map error response, throwing generic error
          }
          Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
          future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
          return;
        }
        catch (IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      }

      @Override
      public void onFailure(@NotNull Call call, @NotNull IOException e) {
        future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
      }
    });
    return future;
  }

  /**
   * Export a specific rule by its ID.
   */
  public CompletableFuture<RulebricksApiHttpResponse<Map<String, Object>>> pull(
      PullRulesRequest request) {
    return pull(request,null);
  }

  /**
   * Export a specific rule by its ID.
   */
  public CompletableFuture<RulebricksApiHttpResponse<Map<String, Object>>> pull(
      PullRulesRequest request, RequestOptions requestOptions) {
    HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/rules/export");QueryStringMapper.addQueryParameter(httpUrl, "id", request.getId(), false);
      Request.Builder _requestBuilder = new Request.Builder()
        .url(httpUrl.build())
        .method("GET", null)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Accept", "application/json");
      Request okhttpRequest = _requestBuilder.build();
      OkHttpClient client = clientOptions.httpClient();
      if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
        client = clientOptions.httpClientWithTimeout(requestOptions);
      }
      CompletableFuture<RulebricksApiHttpResponse<Map<String, Object>>> future = new CompletableFuture<>();
      client.newCall(okhttpRequest).enqueue(new Callback() {
        @Override
        public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
          try (ResponseBody responseBody = response.body()) {
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
              future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, new TypeReference<Map<String, Object>>() {}), response));
              return;
            }
            try {
              switch (response.code()) {
                case 400:future.completeExceptionally(new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
                case 404:future.completeExceptionally(new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
                case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
              }
            }
            catch (JsonProcessingException ignored) {
              // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
            return;
          }
          catch (IOException e) {
            future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
          }
        }

        @Override
        public void onFailure(@NotNull Call call, @NotNull IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      });
      return future;
    }

    /**
     * Import a rule into the user's account.
     */
    public CompletableFuture<RulebricksApiHttpResponse<Map<String, Object>>> push(
        ImportRuleRequest request) {
      return push(request,null);
    }

    /**
     * Import a rule into the user's account.
     */
    public CompletableFuture<RulebricksApiHttpResponse<Map<String, Object>>> push(
        ImportRuleRequest request, RequestOptions requestOptions) {
      HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("admin/rules/import")
        .build();
      RequestBody body;
      try {
        body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
      }
      catch(JsonProcessingException e) {
        throw new RulebricksApiException("Failed to serialize request", e);
      }
      Request okhttpRequest = new Request.Builder()
        .url(httpUrl)
        .method("POST", body)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Content-Type", "application/json")
        .addHeader("Accept", "application/json")
        .build();
      OkHttpClient client = clientOptions.httpClient();
      if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
        client = clientOptions.httpClientWithTimeout(requestOptions);
      }
      CompletableFuture<RulebricksApiHttpResponse<Map<String, Object>>> future = new CompletableFuture<>();
      client.newCall(okhttpRequest).enqueue(new Callback() {
        @Override
        public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
          try (ResponseBody responseBody = response.body()) {
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
              future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, new TypeReference<Map<String, Object>>() {}), response));
              return;
            }
            try {
              switch (response.code()) {
                case 400:future.completeExceptionally(new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
                case 403:future.completeExceptionally(new ForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
                case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
              }
            }
            catch (JsonProcessingException ignored) {
              // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
            return;
          }
          catch (IOException e) {
            future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
          }
        }

        @Override
        public void onFailure(@NotNull Call call, @NotNull IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      });
      return future;
    }

    /**
     * List all rules in the organization. Optionally filter by folder name or ID.
     */
    public CompletableFuture<RulebricksApiHttpResponse<List<RuleDetail>>> list() {
      return list(ListRulesRequest.builder().build());
    }

    /**
     * List all rules in the organization. Optionally filter by folder name or ID.
     */
    public CompletableFuture<RulebricksApiHttpResponse<List<RuleDetail>>> list(
        ListRulesRequest request) {
      return list(request,null);
    }

    /**
     * List all rules in the organization. Optionally filter by folder name or ID.
     */
    public CompletableFuture<RulebricksApiHttpResponse<List<RuleDetail>>> list(
        ListRulesRequest request, RequestOptions requestOptions) {
      HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("admin/rules/list");if (request.getFolder().isPresent()) {
          QueryStringMapper.addQueryParameter(httpUrl, "folder", request.getFolder().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder()
          .url(httpUrl.build())
          .method("GET", null)
          .headers(Headers.of(clientOptions.headers(requestOptions)))
          .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
          client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<RulebricksApiHttpResponse<List<RuleDetail>>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
          @Override
          public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
            try (ResponseBody responseBody = response.body()) {
              String responseBodyString = responseBody != null ? responseBody.string() : "{}";
              if (response.isSuccessful()) {
                future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, new TypeReference<List<RuleDetail>>() {}), response));
                return;
              }
              try {
                switch (response.code()) {
                  case 400:future.completeExceptionally(new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                  return;
                  case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                  return;
                }
              }
              catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
              }
              Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
              future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
              return;
            }
            catch (IOException e) {
              future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
            }
          }

          @Override
          public void onFailure(@NotNull Call call, @NotNull IOException e) {
            future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
          }
        });
        return future;
      }
    }
