/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets.rules;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.MediaTypes;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.QueryStringMapper;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.core.RulebricksApiHttpResponse;
import com.rulebricks.errors.BadRequestError;
import com.rulebricks.errors.ForbiddenError;
import com.rulebricks.errors.InternalServerError;
import com.rulebricks.errors.NotFoundError;
import com.rulebricks.resources.assets.rules.requests.DeleteRuleRequest;
import com.rulebricks.resources.assets.rules.requests.ImportRuleRequest;
import com.rulebricks.resources.assets.rules.requests.ListRulesRequest;
import com.rulebricks.resources.assets.rules.requests.PullRulesRequest;
import com.rulebricks.types.RuleDetail;
import com.rulebricks.types.SuccessMessage;
import java.io.IOException;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawRulesClient {
  protected final ClientOptions clientOptions;

  public RawRulesClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Delete a specific rule by its ID.
   */
  public RulebricksApiHttpResponse<SuccessMessage> delete(DeleteRuleRequest request) {
    return delete(request,null);
  }

  /**
   * Delete a specific rule by its ID.
   */
  public RulebricksApiHttpResponse<SuccessMessage> delete(DeleteRuleRequest request,
      RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/rules/delete")
      .build();
    RequestBody body;
    try {
      body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
    }
    catch(JsonProcessingException e) {
      throw new RulebricksApiException("Failed to serialize request", e);
    }
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("DELETE", body)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .addHeader("Accept", "application/json")
      .build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    try (Response response = client.newCall(okhttpRequest).execute()) {
      ResponseBody responseBody = response.body();
      String responseBodyString = responseBody != null ? responseBody.string() : "{}";
      if (response.isSuccessful()) {
        return new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, SuccessMessage.class), response);
      }
      try {
        switch (response.code()) {
          case 400:throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
          case 404:throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
          case 500:throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
      }
      catch (JsonProcessingException ignored) {
        // unable to map error response, throwing generic error
      }
      Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
      throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
    }
    catch (IOException e) {
      throw new RulebricksApiException("Network error executing HTTP request", e);
    }
  }

  /**
   * Export a specific rule by its ID.
   */
  public RulebricksApiHttpResponse<Map<String, Object>> pull(PullRulesRequest request) {
    return pull(request,null);
  }

  /**
   * Export a specific rule by its ID.
   */
  public RulebricksApiHttpResponse<Map<String, Object>> pull(PullRulesRequest request,
      RequestOptions requestOptions) {
    HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/rules/export");QueryStringMapper.addQueryParameter(httpUrl, "id", request.getId(), false);
      Request.Builder _requestBuilder = new Request.Builder()
        .url(httpUrl.build())
        .method("GET", null)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Accept", "application/json");
      Request okhttpRequest = _requestBuilder.build();
      OkHttpClient client = clientOptions.httpClient();
      if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
        client = clientOptions.httpClientWithTimeout(requestOptions);
      }
      try (Response response = client.newCall(okhttpRequest).execute()) {
        ResponseBody responseBody = response.body();
        String responseBodyString = responseBody != null ? responseBody.string() : "{}";
        if (response.isSuccessful()) {
          return new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, new TypeReference<Map<String, Object>>() {}), response);
        }
        try {
          switch (response.code()) {
            case 400:throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            case 404:throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            case 500:throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
          }
        }
        catch (JsonProcessingException ignored) {
          // unable to map error response, throwing generic error
        }
        Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
        throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
      }
      catch (IOException e) {
        throw new RulebricksApiException("Network error executing HTTP request", e);
      }
    }

    /**
     * Import a rule into the user's account.
     */
    public RulebricksApiHttpResponse<Map<String, Object>> push(ImportRuleRequest request) {
      return push(request,null);
    }

    /**
     * Import a rule into the user's account.
     */
    public RulebricksApiHttpResponse<Map<String, Object>> push(ImportRuleRequest request,
        RequestOptions requestOptions) {
      HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("admin/rules/import")
        .build();
      RequestBody body;
      try {
        body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
      }
      catch(JsonProcessingException e) {
        throw new RulebricksApiException("Failed to serialize request", e);
      }
      Request okhttpRequest = new Request.Builder()
        .url(httpUrl)
        .method("POST", body)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Content-Type", "application/json")
        .addHeader("Accept", "application/json")
        .build();
      OkHttpClient client = clientOptions.httpClient();
      if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
        client = clientOptions.httpClientWithTimeout(requestOptions);
      }
      try (Response response = client.newCall(okhttpRequest).execute()) {
        ResponseBody responseBody = response.body();
        String responseBodyString = responseBody != null ? responseBody.string() : "{}";
        if (response.isSuccessful()) {
          return new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, new TypeReference<Map<String, Object>>() {}), response);
        }
        try {
          switch (response.code()) {
            case 400:throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            case 403:throw new ForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            case 500:throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
          }
        }
        catch (JsonProcessingException ignored) {
          // unable to map error response, throwing generic error
        }
        Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
        throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
      }
      catch (IOException e) {
        throw new RulebricksApiException("Network error executing HTTP request", e);
      }
    }

    /**
     * List all rules in the organization. Optionally filter by folder name or ID.
     */
    public RulebricksApiHttpResponse<List<RuleDetail>> list() {
      return list(ListRulesRequest.builder().build());
    }

    /**
     * List all rules in the organization. Optionally filter by folder name or ID.
     */
    public RulebricksApiHttpResponse<List<RuleDetail>> list(ListRulesRequest request) {
      return list(request,null);
    }

    /**
     * List all rules in the organization. Optionally filter by folder name or ID.
     */
    public RulebricksApiHttpResponse<List<RuleDetail>> list(ListRulesRequest request,
        RequestOptions requestOptions) {
      HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("admin/rules/list");if (request.getFolder().isPresent()) {
          QueryStringMapper.addQueryParameter(httpUrl, "folder", request.getFolder().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder()
          .url(httpUrl.build())
          .method("GET", null)
          .headers(Headers.of(clientOptions.headers(requestOptions)))
          .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
          client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
          ResponseBody responseBody = response.body();
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          if (response.isSuccessful()) {
            return new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, new TypeReference<List<RuleDetail>>() {}), response);
          }
          try {
            switch (response.code()) {
              case 400:throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
              case 500:throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
          }
          catch (JsonProcessingException ignored) {
            // unable to map error response, throwing generic error
          }
          Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
          throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
          throw new RulebricksApiException("Network error executing HTTP request", e);
        }
      }
    }
