/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.contexts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.MediaTypes;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.QueryStringMapper;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.core.RulebricksApiHttpResponse;
import com.rulebricks.errors.BadRequestError;
import com.rulebricks.errors.InternalServerError;
import com.rulebricks.errors.NotFoundError;
import com.rulebricks.resources.contexts.requests.CascadeContextRequest;
import com.rulebricks.resources.contexts.requests.DeleteInstanceContextsRequest;
import com.rulebricks.resources.contexts.requests.GetHistoryContextsRequest;
import com.rulebricks.resources.contexts.requests.GetInstanceContextsRequest;
import com.rulebricks.resources.contexts.requests.GetPendingContextsRequest;
import com.rulebricks.resources.contexts.requests.SolveContextFlowRequest;
import com.rulebricks.resources.contexts.requests.SolveContextRuleRequest;
import com.rulebricks.resources.contexts.requests.SubmitContextsRequest;
import com.rulebricks.types.CascadeContextResponse;
import com.rulebricks.types.ContextInstanceHistory;
import com.rulebricks.types.ContextInstancePendingResponse;
import com.rulebricks.types.ContextInstanceState;
import com.rulebricks.types.DeleteContextInstanceResponse;
import com.rulebricks.types.SolveContextFlowResponse;
import com.rulebricks.types.SolveContextRuleResponse;
import com.rulebricks.types.SubmitContextDataResponse;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawContextsClient {
  protected final ClientOptions clientOptions;

  public AsyncRawContextsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Retrieve the current state of a context instance.
   */
  public CompletableFuture<RulebricksApiHttpResponse<ContextInstanceState>> getInstance(String slug,
      String instance) {
    return getInstance(slug,instance,GetInstanceContextsRequest.builder().build());
  }

  /**
   * Retrieve the current state of a context instance.
   */
  public CompletableFuture<RulebricksApiHttpResponse<ContextInstanceState>> getInstance(String slug,
      String instance, GetInstanceContextsRequest request) {
    return getInstance(slug,instance,request,null);
  }

  /**
   * Retrieve the current state of a context instance.
   */
  public CompletableFuture<RulebricksApiHttpResponse<ContextInstanceState>> getInstance(String slug,
      String instance, GetInstanceContextsRequest request, RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("contexts")
      .addPathSegment(slug)
      .addPathSegment(instance)
      .build();
    Request.Builder _requestBuilder = new Request.Builder()
      .url(httpUrl)
      .method("GET", null)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Accept", "application/json");
    Request okhttpRequest = _requestBuilder.build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    CompletableFuture<RulebricksApiHttpResponse<ContextInstanceState>> future = new CompletableFuture<>();
    client.newCall(okhttpRequest).enqueue(new Callback() {
      @Override
      public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try (ResponseBody responseBody = response.body()) {
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          if (response.isSuccessful()) {
            future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ContextInstanceState.class), response));
            return;
          }
          try {
            switch (response.code()) {
              case 404:future.completeExceptionally(new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
              case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
            }
          }
          catch (JsonProcessingException ignored) {
            // unable to map error response, throwing generic error
          }
          Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
          future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
          return;
        }
        catch (IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      }

      @Override
      public void onFailure(@NotNull Call call, @NotNull IOException e) {
        future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
      }
    });
    return future;
  }

  /**
   * Submit data to a context instance, creating it if it doesn't exist. May trigger bound rule/flow evaluations.
   */
  public CompletableFuture<RulebricksApiHttpResponse<SubmitContextDataResponse>> submit(String slug,
      String instance, SubmitContextsRequest request) {
    return submit(slug,instance,request,null);
  }

  /**
   * Submit data to a context instance, creating it if it doesn't exist. May trigger bound rule/flow evaluations.
   */
  public CompletableFuture<RulebricksApiHttpResponse<SubmitContextDataResponse>> submit(String slug,
      String instance, SubmitContextsRequest request, RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("contexts")
      .addPathSegment(slug)
      .addPathSegment(instance)
      .build();
    RequestBody body;
    try {
      body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), MediaTypes.APPLICATION_JSON);
    }
    catch(JsonProcessingException e) {
      throw new RulebricksApiException("Failed to serialize request", e);
    }
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("POST", body)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .addHeader("Accept", "application/json")
      .build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    CompletableFuture<RulebricksApiHttpResponse<SubmitContextDataResponse>> future = new CompletableFuture<>();
    client.newCall(okhttpRequest).enqueue(new Callback() {
      @Override
      public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try (ResponseBody responseBody = response.body()) {
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          if (response.isSuccessful()) {
            future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, SubmitContextDataResponse.class), response));
            return;
          }
          try {
            switch (response.code()) {
              case 400:future.completeExceptionally(new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
              case 404:future.completeExceptionally(new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
              case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
            }
          }
          catch (JsonProcessingException ignored) {
            // unable to map error response, throwing generic error
          }
          Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
          future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
          return;
        }
        catch (IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      }

      @Override
      public void onFailure(@NotNull Call call, @NotNull IOException e) {
        future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
      }
    });
    return future;
  }

  /**
   * Delete a specific context instance and its history.
   */
  public CompletableFuture<RulebricksApiHttpResponse<DeleteContextInstanceResponse>> deleteInstance(
      String slug, String instance) {
    return deleteInstance(slug,instance,DeleteInstanceContextsRequest.builder().build());
  }

  /**
   * Delete a specific context instance and its history.
   */
  public CompletableFuture<RulebricksApiHttpResponse<DeleteContextInstanceResponse>> deleteInstance(
      String slug, String instance, DeleteInstanceContextsRequest request) {
    return deleteInstance(slug,instance,request,null);
  }

  /**
   * Delete a specific context instance and its history.
   */
  public CompletableFuture<RulebricksApiHttpResponse<DeleteContextInstanceResponse>> deleteInstance(
      String slug, String instance, DeleteInstanceContextsRequest request,
      RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("contexts")
      .addPathSegment(slug)
      .addPathSegment(instance)
      .build();
    Request.Builder _requestBuilder = new Request.Builder()
      .url(httpUrl)
      .method("DELETE", null)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Accept", "application/json");
    Request okhttpRequest = _requestBuilder.build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    CompletableFuture<RulebricksApiHttpResponse<DeleteContextInstanceResponse>> future = new CompletableFuture<>();
    client.newCall(okhttpRequest).enqueue(new Callback() {
      @Override
      public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try (ResponseBody responseBody = response.body()) {
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          if (response.isSuccessful()) {
            future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, DeleteContextInstanceResponse.class), response));
            return;
          }
          try {
            switch (response.code()) {
              case 404:future.completeExceptionally(new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
              case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
            }
          }
          catch (JsonProcessingException ignored) {
            // unable to map error response, throwing generic error
          }
          Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
          future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
          return;
        }
        catch (IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      }

      @Override
      public void onFailure(@NotNull Call call, @NotNull IOException e) {
        future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
      }
    });
    return future;
  }

  /**
   * Retrieve the change history for a context instance.
   */
  public CompletableFuture<RulebricksApiHttpResponse<ContextInstanceHistory>> getHistory(
      String slug, String instance) {
    return getHistory(slug,instance,GetHistoryContextsRequest.builder().build());
  }

  /**
   * Retrieve the change history for a context instance.
   */
  public CompletableFuture<RulebricksApiHttpResponse<ContextInstanceHistory>> getHistory(
      String slug, String instance, GetHistoryContextsRequest request) {
    return getHistory(slug,instance,request,null);
  }

  /**
   * Retrieve the change history for a context instance.
   */
  public CompletableFuture<RulebricksApiHttpResponse<ContextInstanceHistory>> getHistory(
      String slug, String instance, GetHistoryContextsRequest request,
      RequestOptions requestOptions) {
    HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("contexts")
      .addPathSegment(slug)
      .addPathSegment(instance)
      .addPathSegments("history");if (request.getField().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "field", request.getField().get(), false);
      }
      if (request.getLimit().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
      }
      Request.Builder _requestBuilder = new Request.Builder()
        .url(httpUrl.build())
        .method("GET", null)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Accept", "application/json");
      Request okhttpRequest = _requestBuilder.build();
      OkHttpClient client = clientOptions.httpClient();
      if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
        client = clientOptions.httpClientWithTimeout(requestOptions);
      }
      CompletableFuture<RulebricksApiHttpResponse<ContextInstanceHistory>> future = new CompletableFuture<>();
      client.newCall(okhttpRequest).enqueue(new Callback() {
        @Override
        public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
          try (ResponseBody responseBody = response.body()) {
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
              future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ContextInstanceHistory.class), response));
              return;
            }
            try {
              switch (response.code()) {
                case 404:future.completeExceptionally(new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
                case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
              }
            }
            catch (JsonProcessingException ignored) {
              // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
            return;
          }
          catch (IOException e) {
            future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
          }
        }

        @Override
        public void onFailure(@NotNull Call call, @NotNull IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      });
      return future;
    }

    /**
     * Get list of rules/flows that need to be evaluated for this instance.
     */
    public CompletableFuture<RulebricksApiHttpResponse<ContextInstancePendingResponse>> getPending(
        String slug, String instance) {
      return getPending(slug,instance,GetPendingContextsRequest.builder().build());
    }

    /**
     * Get list of rules/flows that need to be evaluated for this instance.
     */
    public CompletableFuture<RulebricksApiHttpResponse<ContextInstancePendingResponse>> getPending(
        String slug, String instance, GetPendingContextsRequest request) {
      return getPending(slug,instance,request,null);
    }

    /**
     * Get list of rules/flows that need to be evaluated for this instance.
     */
    public CompletableFuture<RulebricksApiHttpResponse<ContextInstancePendingResponse>> getPending(
        String slug, String instance, GetPendingContextsRequest request,
        RequestOptions requestOptions) {
      HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("contexts")
        .addPathSegment(slug)
        .addPathSegment(instance)
        .addPathSegments("pending")
        .build();
      Request.Builder _requestBuilder = new Request.Builder()
        .url(httpUrl)
        .method("GET", null)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Accept", "application/json");
      Request okhttpRequest = _requestBuilder.build();
      OkHttpClient client = clientOptions.httpClient();
      if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
        client = clientOptions.httpClientWithTimeout(requestOptions);
      }
      CompletableFuture<RulebricksApiHttpResponse<ContextInstancePendingResponse>> future = new CompletableFuture<>();
      client.newCall(okhttpRequest).enqueue(new Callback() {
        @Override
        public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
          try (ResponseBody responseBody = response.body()) {
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
              future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ContextInstancePendingResponse.class), response));
              return;
            }
            try {
              switch (response.code()) {
                case 404:future.completeExceptionally(new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
                case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
              }
            }
            catch (JsonProcessingException ignored) {
              // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
            return;
          }
          catch (IOException e) {
            future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
          }
        }

        @Override
        public void onFailure(@NotNull Call call, @NotNull IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      });
      return future;
    }

    /**
     * Execute a specific rule using the context instance's state as input.
     */
    public CompletableFuture<RulebricksApiHttpResponse<SolveContextRuleResponse>> solve(String slug,
        String instance, String ruleSlug) {
      return solve(slug,instance,ruleSlug,SolveContextRuleRequest.builder().build());
    }

    /**
     * Execute a specific rule using the context instance's state as input.
     */
    public CompletableFuture<RulebricksApiHttpResponse<SolveContextRuleResponse>> solve(String slug,
        String instance, String ruleSlug, SolveContextRuleRequest request) {
      return solve(slug,instance,ruleSlug,request,null);
    }

    /**
     * Execute a specific rule using the context instance's state as input.
     */
    public CompletableFuture<RulebricksApiHttpResponse<SolveContextRuleResponse>> solve(String slug,
        String instance, String ruleSlug, SolveContextRuleRequest request,
        RequestOptions requestOptions) {
      HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("contexts")
        .addPathSegment(slug)
        .addPathSegment(instance)
        .addPathSegments("solve")
        .addPathSegment(ruleSlug)
        .build();
      RequestBody body;
      try {
        body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
      }
      catch(JsonProcessingException e) {
        throw new RulebricksApiException("Failed to serialize request", e);
      }
      Request okhttpRequest = new Request.Builder()
        .url(httpUrl)
        .method("POST", body)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Content-Type", "application/json")
        .addHeader("Accept", "application/json")
        .build();
      OkHttpClient client = clientOptions.httpClient();
      if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
        client = clientOptions.httpClientWithTimeout(requestOptions);
      }
      CompletableFuture<RulebricksApiHttpResponse<SolveContextRuleResponse>> future = new CompletableFuture<>();
      client.newCall(okhttpRequest).enqueue(new Callback() {
        @Override
        public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
          try (ResponseBody responseBody = response.body()) {
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
              future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, SolveContextRuleResponse.class), response));
              return;
            }
            try {
              switch (response.code()) {
                case 400:future.completeExceptionally(new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
                case 404:future.completeExceptionally(new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
                case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
              }
            }
            catch (JsonProcessingException ignored) {
              // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
            return;
          }
          catch (IOException e) {
            future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
          }
        }

        @Override
        public void onFailure(@NotNull Call call, @NotNull IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      });
      return future;
    }

    /**
     * Trigger re-evaluation of all bound rules and flows for the instance.
     */
    public CompletableFuture<RulebricksApiHttpResponse<CascadeContextResponse>> cascade(String slug,
        String instance) {
      return cascade(slug,instance,CascadeContextRequest.builder().build());
    }

    /**
     * Trigger re-evaluation of all bound rules and flows for the instance.
     */
    public CompletableFuture<RulebricksApiHttpResponse<CascadeContextResponse>> cascade(String slug,
        String instance, CascadeContextRequest request) {
      return cascade(slug,instance,request,null);
    }

    /**
     * Trigger re-evaluation of all bound rules and flows for the instance.
     */
    public CompletableFuture<RulebricksApiHttpResponse<CascadeContextResponse>> cascade(String slug,
        String instance, CascadeContextRequest request, RequestOptions requestOptions) {
      HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("contexts")
        .addPathSegment(slug)
        .addPathSegment(instance)
        .addPathSegments("cascade")
        .build();
      RequestBody body;
      try {
        body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
      }
      catch(JsonProcessingException e) {
        throw new RulebricksApiException("Failed to serialize request", e);
      }
      Request okhttpRequest = new Request.Builder()
        .url(httpUrl)
        .method("POST", body)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Content-Type", "application/json")
        .addHeader("Accept", "application/json")
        .build();
      OkHttpClient client = clientOptions.httpClient();
      if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
        client = clientOptions.httpClientWithTimeout(requestOptions);
      }
      CompletableFuture<RulebricksApiHttpResponse<CascadeContextResponse>> future = new CompletableFuture<>();
      client.newCall(okhttpRequest).enqueue(new Callback() {
        @Override
        public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
          try (ResponseBody responseBody = response.body()) {
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
              future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, CascadeContextResponse.class), response));
              return;
            }
            try {
              switch (response.code()) {
                case 404:future.completeExceptionally(new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
                case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
              }
            }
            catch (JsonProcessingException ignored) {
              // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
            return;
          }
          catch (IOException e) {
            future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
          }
        }

        @Override
        public void onFailure(@NotNull Call call, @NotNull IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      });
      return future;
    }

    /**
     * Execute a specific flow using the context instance's state as input.
     */
    public CompletableFuture<RulebricksApiHttpResponse<SolveContextFlowResponse>> execute(
        String slug, String instance, String flowSlug) {
      return execute(slug,instance,flowSlug,SolveContextFlowRequest.builder().build());
    }

    /**
     * Execute a specific flow using the context instance's state as input.
     */
    public CompletableFuture<RulebricksApiHttpResponse<SolveContextFlowResponse>> execute(
        String slug, String instance, String flowSlug, SolveContextFlowRequest request) {
      return execute(slug,instance,flowSlug,request,null);
    }

    /**
     * Execute a specific flow using the context instance's state as input.
     */
    public CompletableFuture<RulebricksApiHttpResponse<SolveContextFlowResponse>> execute(
        String slug, String instance, String flowSlug, SolveContextFlowRequest request,
        RequestOptions requestOptions) {
      HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("contexts")
        .addPathSegment(slug)
        .addPathSegment(instance)
        .addPathSegments("flows")
        .addPathSegment(flowSlug)
        .build();
      RequestBody body;
      try {
        body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
      }
      catch(JsonProcessingException e) {
        throw new RulebricksApiException("Failed to serialize request", e);
      }
      Request okhttpRequest = new Request.Builder()
        .url(httpUrl)
        .method("POST", body)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Content-Type", "application/json")
        .addHeader("Accept", "application/json")
        .build();
      OkHttpClient client = clientOptions.httpClient();
      if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
        client = clientOptions.httpClientWithTimeout(requestOptions);
      }
      CompletableFuture<RulebricksApiHttpResponse<SolveContextFlowResponse>> future = new CompletableFuture<>();
      client.newCall(okhttpRequest).enqueue(new Callback() {
        @Override
        public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
          try (ResponseBody responseBody = response.body()) {
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
              future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, SolveContextFlowResponse.class), response));
              return;
            }
            try {
              switch (response.code()) {
                case 400:future.completeExceptionally(new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
                case 404:future.completeExceptionally(new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
                case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
              }
            }
            catch (JsonProcessingException ignored) {
              // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
            return;
          }
          catch (IOException e) {
            future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
          }
        }

        @Override
        public void onFailure(@NotNull Call call, @NotNull IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      });
      return future;
    }
  }
