/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.contexts;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.Suppliers;
import com.rulebricks.resources.contexts.admin.AdminClient;
import com.rulebricks.resources.contexts.relationships.RelationshipsClient;
import com.rulebricks.resources.contexts.requests.CascadeContextRequest;
import com.rulebricks.resources.contexts.requests.DeleteInstanceContextsRequest;
import com.rulebricks.resources.contexts.requests.GetHistoryContextsRequest;
import com.rulebricks.resources.contexts.requests.GetInstanceContextsRequest;
import com.rulebricks.resources.contexts.requests.GetPendingContextsRequest;
import com.rulebricks.resources.contexts.requests.SolveContextFlowRequest;
import com.rulebricks.resources.contexts.requests.SolveContextRuleRequest;
import com.rulebricks.resources.contexts.requests.SubmitContextsRequest;
import com.rulebricks.types.CascadeContextResponse;
import com.rulebricks.types.ContextInstanceHistory;
import com.rulebricks.types.ContextInstancePendingResponse;
import com.rulebricks.types.ContextInstanceState;
import com.rulebricks.types.DeleteContextInstanceResponse;
import com.rulebricks.types.SolveContextFlowResponse;
import com.rulebricks.types.SolveContextRuleResponse;
import com.rulebricks.types.SubmitContextDataResponse;
import java.lang.String;
import java.util.function.Supplier;

public class ContextsClient {
  protected final ClientOptions clientOptions;

  private final RawContextsClient rawClient;

  protected final Supplier<AdminClient> adminClient;

  protected final Supplier<RelationshipsClient> relationshipsClient;

  public ContextsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new RawContextsClient(clientOptions);
    this.adminClient = Suppliers.memoize(() -> new AdminClient(clientOptions));
    this.relationshipsClient = Suppliers.memoize(() -> new RelationshipsClient(clientOptions));
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public RawContextsClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Retrieve the current state of a context instance.
   */
  public ContextInstanceState getInstance(String slug, String instance) {
    return this.rawClient.getInstance(slug, instance).body();
  }

  /**
   * Retrieve the current state of a context instance.
   */
  public ContextInstanceState getInstance(String slug, String instance,
      GetInstanceContextsRequest request) {
    return this.rawClient.getInstance(slug, instance, request).body();
  }

  /**
   * Retrieve the current state of a context instance.
   */
  public ContextInstanceState getInstance(String slug, String instance,
      GetInstanceContextsRequest request, RequestOptions requestOptions) {
    return this.rawClient.getInstance(slug, instance, request, requestOptions).body();
  }

  /**
   * Submit data to a context instance, creating it if it doesn't exist. May trigger bound rule/flow evaluations.
   */
  public SubmitContextDataResponse submit(String slug, String instance,
      SubmitContextsRequest request) {
    return this.rawClient.submit(slug, instance, request).body();
  }

  /**
   * Submit data to a context instance, creating it if it doesn't exist. May trigger bound rule/flow evaluations.
   */
  public SubmitContextDataResponse submit(String slug, String instance,
      SubmitContextsRequest request, RequestOptions requestOptions) {
    return this.rawClient.submit(slug, instance, request, requestOptions).body();
  }

  /**
   * Delete a specific context instance and its history.
   */
  public DeleteContextInstanceResponse deleteInstance(String slug, String instance) {
    return this.rawClient.deleteInstance(slug, instance).body();
  }

  /**
   * Delete a specific context instance and its history.
   */
  public DeleteContextInstanceResponse deleteInstance(String slug, String instance,
      DeleteInstanceContextsRequest request) {
    return this.rawClient.deleteInstance(slug, instance, request).body();
  }

  /**
   * Delete a specific context instance and its history.
   */
  public DeleteContextInstanceResponse deleteInstance(String slug, String instance,
      DeleteInstanceContextsRequest request, RequestOptions requestOptions) {
    return this.rawClient.deleteInstance(slug, instance, request, requestOptions).body();
  }

  /**
   * Retrieve the change history for a context instance.
   */
  public ContextInstanceHistory getHistory(String slug, String instance) {
    return this.rawClient.getHistory(slug, instance).body();
  }

  /**
   * Retrieve the change history for a context instance.
   */
  public ContextInstanceHistory getHistory(String slug, String instance,
      GetHistoryContextsRequest request) {
    return this.rawClient.getHistory(slug, instance, request).body();
  }

  /**
   * Retrieve the change history for a context instance.
   */
  public ContextInstanceHistory getHistory(String slug, String instance,
      GetHistoryContextsRequest request, RequestOptions requestOptions) {
    return this.rawClient.getHistory(slug, instance, request, requestOptions).body();
  }

  /**
   * Get list of rules/flows that need to be evaluated for this instance.
   */
  public ContextInstancePendingResponse getPending(String slug, String instance) {
    return this.rawClient.getPending(slug, instance).body();
  }

  /**
   * Get list of rules/flows that need to be evaluated for this instance.
   */
  public ContextInstancePendingResponse getPending(String slug, String instance,
      GetPendingContextsRequest request) {
    return this.rawClient.getPending(slug, instance, request).body();
  }

  /**
   * Get list of rules/flows that need to be evaluated for this instance.
   */
  public ContextInstancePendingResponse getPending(String slug, String instance,
      GetPendingContextsRequest request, RequestOptions requestOptions) {
    return this.rawClient.getPending(slug, instance, request, requestOptions).body();
  }

  /**
   * Execute a specific rule using the context instance's state as input.
   */
  public SolveContextRuleResponse solve(String slug, String instance, String ruleSlug) {
    return this.rawClient.solve(slug, instance, ruleSlug).body();
  }

  /**
   * Execute a specific rule using the context instance's state as input.
   */
  public SolveContextRuleResponse solve(String slug, String instance, String ruleSlug,
      SolveContextRuleRequest request) {
    return this.rawClient.solve(slug, instance, ruleSlug, request).body();
  }

  /**
   * Execute a specific rule using the context instance's state as input.
   */
  public SolveContextRuleResponse solve(String slug, String instance, String ruleSlug,
      SolveContextRuleRequest request, RequestOptions requestOptions) {
    return this.rawClient.solve(slug, instance, ruleSlug, request, requestOptions).body();
  }

  /**
   * Trigger re-evaluation of all bound rules and flows for the instance.
   */
  public CascadeContextResponse cascade(String slug, String instance) {
    return this.rawClient.cascade(slug, instance).body();
  }

  /**
   * Trigger re-evaluation of all bound rules and flows for the instance.
   */
  public CascadeContextResponse cascade(String slug, String instance,
      CascadeContextRequest request) {
    return this.rawClient.cascade(slug, instance, request).body();
  }

  /**
   * Trigger re-evaluation of all bound rules and flows for the instance.
   */
  public CascadeContextResponse cascade(String slug, String instance, CascadeContextRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.cascade(slug, instance, request, requestOptions).body();
  }

  /**
   * Execute a specific flow using the context instance's state as input.
   */
  public SolveContextFlowResponse execute(String slug, String instance, String flowSlug) {
    return this.rawClient.execute(slug, instance, flowSlug).body();
  }

  /**
   * Execute a specific flow using the context instance's state as input.
   */
  public SolveContextFlowResponse execute(String slug, String instance, String flowSlug,
      SolveContextFlowRequest request) {
    return this.rawClient.execute(slug, instance, flowSlug, request).body();
  }

  /**
   * Execute a specific flow using the context instance's state as input.
   */
  public SolveContextFlowResponse execute(String slug, String instance, String flowSlug,
      SolveContextFlowRequest request, RequestOptions requestOptions) {
    return this.rawClient.execute(slug, instance, flowSlug, request, requestOptions).body();
  }

  public AdminClient admin() {
    return this.adminClient.get();
  }

  public RelationshipsClient relationships() {
    return this.relationshipsClient.get();
  }
}
