/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.contexts.admin;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.contexts.admin.requests.CreateContextRequest;
import com.rulebricks.resources.contexts.admin.requests.DeleteAdminRequest;
import com.rulebricks.resources.contexts.admin.requests.GetAdminRequest;
import com.rulebricks.resources.contexts.admin.requests.UpdateContextRequest;
import com.rulebricks.types.ContextDetail;
import com.rulebricks.types.DeleteContextResponse;
import java.lang.String;
import java.util.List;

public class AdminClient {
  protected final ClientOptions clientOptions;

  private final RawAdminClient rawClient;

  public AdminClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new RawAdminClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public RawAdminClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Retrieve all contexts (entities) for the authenticated user.
   */
  public List<ContextDetail> list() {
    return this.rawClient.list().body();
  }

  /**
   * Retrieve all contexts (entities) for the authenticated user.
   */
  public List<ContextDetail> list(RequestOptions requestOptions) {
    return this.rawClient.list(requestOptions).body();
  }

  /**
   * Create a new context (entity) for the authenticated user.
   */
  public ContextDetail create(CreateContextRequest request) {
    return this.rawClient.create(request).body();
  }

  /**
   * Create a new context (entity) for the authenticated user.
   */
  public ContextDetail create(CreateContextRequest request, RequestOptions requestOptions) {
    return this.rawClient.create(request, requestOptions).body();
  }

  /**
   * Retrieve a specific context by its ID.
   */
  public ContextDetail get(String id) {
    return this.rawClient.get(id).body();
  }

  /**
   * Retrieve a specific context by its ID.
   */
  public ContextDetail get(String id, GetAdminRequest request) {
    return this.rawClient.get(id, request).body();
  }

  /**
   * Retrieve a specific context by its ID.
   */
  public ContextDetail get(String id, GetAdminRequest request, RequestOptions requestOptions) {
    return this.rawClient.get(id, request, requestOptions).body();
  }

  /**
   * Update an existing context's properties and schema.
   */
  public ContextDetail update(String id) {
    return this.rawClient.update(id).body();
  }

  /**
   * Update an existing context's properties and schema.
   */
  public ContextDetail update(String id, UpdateContextRequest request) {
    return this.rawClient.update(id, request).body();
  }

  /**
   * Update an existing context's properties and schema.
   */
  public ContextDetail update(String id, UpdateContextRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.update(id, request, requestOptions).body();
  }

  /**
   * Delete a specific context and all its instances.
   */
  public DeleteContextResponse delete(String id) {
    return this.rawClient.delete(id).body();
  }

  /**
   * Delete a specific context and all its instances.
   */
  public DeleteContextResponse delete(String id, DeleteAdminRequest request) {
    return this.rawClient.delete(id, request).body();
  }

  /**
   * Delete a specific context and all its instances.
   */
  public DeleteContextResponse delete(String id, DeleteAdminRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.delete(id, request, requestOptions).body();
  }
}
