/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.contexts.admin;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.contexts.admin.requests.CreateContextRequest;
import com.rulebricks.resources.contexts.admin.requests.DeleteAdminRequest;
import com.rulebricks.resources.contexts.admin.requests.GetAdminRequest;
import com.rulebricks.resources.contexts.admin.requests.UpdateContextRequest;
import com.rulebricks.types.ContextDetail;
import com.rulebricks.types.DeleteContextResponse;
import java.lang.String;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncAdminClient {
  protected final ClientOptions clientOptions;

  private final AsyncRawAdminClient rawClient;

  public AsyncAdminClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new AsyncRawAdminClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public AsyncRawAdminClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Retrieve all contexts (entities) for the authenticated user.
   */
  public CompletableFuture<List<ContextDetail>> list() {
    return this.rawClient.list().thenApply(response -> response.body());
  }

  /**
   * Retrieve all contexts (entities) for the authenticated user.
   */
  public CompletableFuture<List<ContextDetail>> list(RequestOptions requestOptions) {
    return this.rawClient.list(requestOptions).thenApply(response -> response.body());
  }

  /**
   * Create a new context (entity) for the authenticated user.
   */
  public CompletableFuture<ContextDetail> create(CreateContextRequest request) {
    return this.rawClient.create(request).thenApply(response -> response.body());
  }

  /**
   * Create a new context (entity) for the authenticated user.
   */
  public CompletableFuture<ContextDetail> create(CreateContextRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.create(request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Retrieve a specific context by its ID.
   */
  public CompletableFuture<ContextDetail> get(String id) {
    return this.rawClient.get(id).thenApply(response -> response.body());
  }

  /**
   * Retrieve a specific context by its ID.
   */
  public CompletableFuture<ContextDetail> get(String id, GetAdminRequest request) {
    return this.rawClient.get(id, request).thenApply(response -> response.body());
  }

  /**
   * Retrieve a specific context by its ID.
   */
  public CompletableFuture<ContextDetail> get(String id, GetAdminRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.get(id, request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Update an existing context's properties and schema.
   */
  public CompletableFuture<ContextDetail> update(String id) {
    return this.rawClient.update(id).thenApply(response -> response.body());
  }

  /**
   * Update an existing context's properties and schema.
   */
  public CompletableFuture<ContextDetail> update(String id, UpdateContextRequest request) {
    return this.rawClient.update(id, request).thenApply(response -> response.body());
  }

  /**
   * Update an existing context's properties and schema.
   */
  public CompletableFuture<ContextDetail> update(String id, UpdateContextRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.update(id, request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Delete a specific context and all its instances.
   */
  public CompletableFuture<DeleteContextResponse> delete(String id) {
    return this.rawClient.delete(id).thenApply(response -> response.body());
  }

  /**
   * Delete a specific context and all its instances.
   */
  public CompletableFuture<DeleteContextResponse> delete(String id, DeleteAdminRequest request) {
    return this.rawClient.delete(id, request).thenApply(response -> response.body());
  }

  /**
   * Delete a specific context and all its instances.
   */
  public CompletableFuture<DeleteContextResponse> delete(String id, DeleteAdminRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.delete(id, request, requestOptions).thenApply(response -> response.body());
  }
}
