/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.contexts.admin.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.resources.contexts.admin.types.CreateContextRequestOnSchemaMismatch;
import com.rulebricks.resources.contexts.admin.types.CreateContextRequestSchemaItem;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = CreateContextRequest.Builder.class
)
public final class CreateContextRequest {
  private final String name;

  private final Optional<String> slug;

  private final Optional<String> description;

  private final Optional<List<CreateContextRequestSchemaItem>> schema;

  private final Optional<Boolean> autoExecuteDecisions;

  private final Optional<Integer> ttlSeconds;

  private final Optional<Integer> historyLimit;

  private final Optional<CreateContextRequestOnSchemaMismatch> onSchemaMismatch;

  private final Optional<String> webhookOnSolve;

  private final Optional<String> webhookOnExpire;

  private final Map<String, Object> additionalProperties;

  private CreateContextRequest(String name, Optional<String> slug, Optional<String> description,
      Optional<List<CreateContextRequestSchemaItem>> schema, Optional<Boolean> autoExecuteDecisions,
      Optional<Integer> ttlSeconds, Optional<Integer> historyLimit,
      Optional<CreateContextRequestOnSchemaMismatch> onSchemaMismatch,
      Optional<String> webhookOnSolve, Optional<String> webhookOnExpire,
      Map<String, Object> additionalProperties) {
    this.name = name;
    this.slug = slug;
    this.description = description;
    this.schema = schema;
    this.autoExecuteDecisions = autoExecuteDecisions;
    this.ttlSeconds = ttlSeconds;
    this.historyLimit = historyLimit;
    this.onSchemaMismatch = onSchemaMismatch;
    this.webhookOnSolve = webhookOnSolve;
    this.webhookOnExpire = webhookOnExpire;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The name of the context.
   */
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  /**
   * @return Optional custom slug. Auto-generated if not provided.
   */
  @JsonProperty("slug")
  public Optional<String> getSlug() {
    return slug;
  }

  /**
   * @return The description of the context.
   */
  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  /**
   * @return Initial schema fields for the context.
   */
  @JsonProperty("schema")
  public Optional<List<CreateContextRequestSchemaItem>> getSchema() {
    return schema;
  }

  /**
   * @return When true (default), bound rules and flows automatically execute when their inputs are satisfied.
   */
  @JsonProperty("auto_execute_decisions")
  public Optional<Boolean> getAutoExecuteDecisions() {
    return autoExecuteDecisions;
  }

  /**
   * @return Time-to-live in seconds for live context instances. Instances expire after this duration.
   */
  @JsonIgnore
  public Optional<Integer> getTtlSeconds() {
    if (ttlSeconds == null) {
      return Optional.empty();
    }
    return ttlSeconds;
  }

  /**
   * @return Maximum number of history entries to retain per field.
   */
  @JsonProperty("history_limit")
  public Optional<Integer> getHistoryLimit() {
    return historyLimit;
  }

  /**
   * @return How to handle fields that don't match the schema.
   */
  @JsonProperty("on_schema_mismatch")
  public Optional<CreateContextRequestOnSchemaMismatch> getOnSchemaMismatch() {
    return onSchemaMismatch;
  }

  /**
   * @return Webhook URL called when a rule or flow successfully solves.
   */
  @JsonProperty("webhook_on_solve")
  public Optional<String> getWebhookOnSolve() {
    return webhookOnSolve;
  }

  /**
   * @return Webhook URL called when a live context expires due to TTL.
   */
  @JsonProperty("webhook_on_expire")
  public Optional<String> getWebhookOnExpire() {
    return webhookOnExpire;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("ttl_seconds")
  private Optional<Integer> _getTtlSeconds() {
    return ttlSeconds;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CreateContextRequest && equalTo((CreateContextRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CreateContextRequest other) {
    return name.equals(other.name) && slug.equals(other.slug) && description.equals(other.description) && schema.equals(other.schema) && autoExecuteDecisions.equals(other.autoExecuteDecisions) && ttlSeconds.equals(other.ttlSeconds) && historyLimit.equals(other.historyLimit) && onSchemaMismatch.equals(other.onSchemaMismatch) && webhookOnSolve.equals(other.webhookOnSolve) && webhookOnExpire.equals(other.webhookOnExpire);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.name, this.slug, this.description, this.schema, this.autoExecuteDecisions, this.ttlSeconds, this.historyLimit, this.onSchemaMismatch, this.webhookOnSolve, this.webhookOnExpire);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static NameStage builder() {
    return new Builder();
  }

  public interface NameStage {
    /**
     * <p>The name of the context.</p>
     */
    _FinalStage name(@NotNull String name);

    Builder from(CreateContextRequest other);
  }

  public interface _FinalStage {
    CreateContextRequest build();

    /**
     * <p>Optional custom slug. Auto-generated if not provided.</p>
     */
    _FinalStage slug(Optional<String> slug);

    _FinalStage slug(String slug);

    /**
     * <p>The description of the context.</p>
     */
    _FinalStage description(Optional<String> description);

    _FinalStage description(String description);

    /**
     * <p>Initial schema fields for the context.</p>
     */
    _FinalStage schema(Optional<List<CreateContextRequestSchemaItem>> schema);

    _FinalStage schema(List<CreateContextRequestSchemaItem> schema);

    /**
     * <p>When true (default), bound rules and flows automatically execute when their inputs are satisfied.</p>
     */
    _FinalStage autoExecuteDecisions(Optional<Boolean> autoExecuteDecisions);

    _FinalStage autoExecuteDecisions(Boolean autoExecuteDecisions);

    /**
     * <p>Time-to-live in seconds for live context instances. Instances expire after this duration.</p>
     */
    _FinalStage ttlSeconds(Optional<Integer> ttlSeconds);

    _FinalStage ttlSeconds(Integer ttlSeconds);

    _FinalStage ttlSeconds(Nullable<Integer> ttlSeconds);

    /**
     * <p>Maximum number of history entries to retain per field.</p>
     */
    _FinalStage historyLimit(Optional<Integer> historyLimit);

    _FinalStage historyLimit(Integer historyLimit);

    /**
     * <p>How to handle fields that don't match the schema.</p>
     */
    _FinalStage onSchemaMismatch(Optional<CreateContextRequestOnSchemaMismatch> onSchemaMismatch);

    _FinalStage onSchemaMismatch(CreateContextRequestOnSchemaMismatch onSchemaMismatch);

    /**
     * <p>Webhook URL called when a rule or flow successfully solves.</p>
     */
    _FinalStage webhookOnSolve(Optional<String> webhookOnSolve);

    _FinalStage webhookOnSolve(String webhookOnSolve);

    /**
     * <p>Webhook URL called when a live context expires due to TTL.</p>
     */
    _FinalStage webhookOnExpire(Optional<String> webhookOnExpire);

    _FinalStage webhookOnExpire(String webhookOnExpire);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements NameStage, _FinalStage {
    private String name;

    private Optional<String> webhookOnExpire = Optional.empty();

    private Optional<String> webhookOnSolve = Optional.empty();

    private Optional<CreateContextRequestOnSchemaMismatch> onSchemaMismatch = Optional.empty();

    private Optional<Integer> historyLimit = Optional.empty();

    private Optional<Integer> ttlSeconds = Optional.empty();

    private Optional<Boolean> autoExecuteDecisions = Optional.empty();

    private Optional<List<CreateContextRequestSchemaItem>> schema = Optional.empty();

    private Optional<String> description = Optional.empty();

    private Optional<String> slug = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(CreateContextRequest other) {
      name(other.getName());
      slug(other.getSlug());
      description(other.getDescription());
      schema(other.getSchema());
      autoExecuteDecisions(other.getAutoExecuteDecisions());
      ttlSeconds(other.getTtlSeconds());
      historyLimit(other.getHistoryLimit());
      onSchemaMismatch(other.getOnSchemaMismatch());
      webhookOnSolve(other.getWebhookOnSolve());
      webhookOnExpire(other.getWebhookOnExpire());
      return this;
    }

    /**
     * <p>The name of the context.</p>
     * <p>The name of the context.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("name")
    public _FinalStage name(@NotNull String name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    /**
     * <p>Webhook URL called when a live context expires due to TTL.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage webhookOnExpire(String webhookOnExpire) {
      this.webhookOnExpire = Optional.ofNullable(webhookOnExpire);
      return this;
    }

    /**
     * <p>Webhook URL called when a live context expires due to TTL.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "webhook_on_expire",
        nulls = Nulls.SKIP
    )
    public _FinalStage webhookOnExpire(Optional<String> webhookOnExpire) {
      this.webhookOnExpire = webhookOnExpire;
      return this;
    }

    /**
     * <p>Webhook URL called when a rule or flow successfully solves.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage webhookOnSolve(String webhookOnSolve) {
      this.webhookOnSolve = Optional.ofNullable(webhookOnSolve);
      return this;
    }

    /**
     * <p>Webhook URL called when a rule or flow successfully solves.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "webhook_on_solve",
        nulls = Nulls.SKIP
    )
    public _FinalStage webhookOnSolve(Optional<String> webhookOnSolve) {
      this.webhookOnSolve = webhookOnSolve;
      return this;
    }

    /**
     * <p>How to handle fields that don't match the schema.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage onSchemaMismatch(CreateContextRequestOnSchemaMismatch onSchemaMismatch) {
      this.onSchemaMismatch = Optional.ofNullable(onSchemaMismatch);
      return this;
    }

    /**
     * <p>How to handle fields that don't match the schema.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "on_schema_mismatch",
        nulls = Nulls.SKIP
    )
    public _FinalStage onSchemaMismatch(
        Optional<CreateContextRequestOnSchemaMismatch> onSchemaMismatch) {
      this.onSchemaMismatch = onSchemaMismatch;
      return this;
    }

    /**
     * <p>Maximum number of history entries to retain per field.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage historyLimit(Integer historyLimit) {
      this.historyLimit = Optional.ofNullable(historyLimit);
      return this;
    }

    /**
     * <p>Maximum number of history entries to retain per field.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "history_limit",
        nulls = Nulls.SKIP
    )
    public _FinalStage historyLimit(Optional<Integer> historyLimit) {
      this.historyLimit = historyLimit;
      return this;
    }

    /**
     * <p>Time-to-live in seconds for live context instances. Instances expire after this duration.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage ttlSeconds(Nullable<Integer> ttlSeconds) {
      if (ttlSeconds.isNull()) {
        this.ttlSeconds = null;
      }
      else if (ttlSeconds.isEmpty()) {
        this.ttlSeconds = Optional.empty();
      }
      else {
        this.ttlSeconds = Optional.of(ttlSeconds.get());
      }
      return this;
    }

    /**
     * <p>Time-to-live in seconds for live context instances. Instances expire after this duration.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage ttlSeconds(Integer ttlSeconds) {
      this.ttlSeconds = Optional.ofNullable(ttlSeconds);
      return this;
    }

    /**
     * <p>Time-to-live in seconds for live context instances. Instances expire after this duration.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "ttl_seconds",
        nulls = Nulls.SKIP
    )
    public _FinalStage ttlSeconds(Optional<Integer> ttlSeconds) {
      this.ttlSeconds = ttlSeconds;
      return this;
    }

    /**
     * <p>When true (default), bound rules and flows automatically execute when their inputs are satisfied.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage autoExecuteDecisions(Boolean autoExecuteDecisions) {
      this.autoExecuteDecisions = Optional.ofNullable(autoExecuteDecisions);
      return this;
    }

    /**
     * <p>When true (default), bound rules and flows automatically execute when their inputs are satisfied.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "auto_execute_decisions",
        nulls = Nulls.SKIP
    )
    public _FinalStage autoExecuteDecisions(Optional<Boolean> autoExecuteDecisions) {
      this.autoExecuteDecisions = autoExecuteDecisions;
      return this;
    }

    /**
     * <p>Initial schema fields for the context.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage schema(List<CreateContextRequestSchemaItem> schema) {
      this.schema = Optional.ofNullable(schema);
      return this;
    }

    /**
     * <p>Initial schema fields for the context.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "schema",
        nulls = Nulls.SKIP
    )
    public _FinalStage schema(Optional<List<CreateContextRequestSchemaItem>> schema) {
      this.schema = schema;
      return this;
    }

    /**
     * <p>The description of the context.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    /**
     * <p>The description of the context.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public _FinalStage description(Optional<String> description) {
      this.description = description;
      return this;
    }

    /**
     * <p>Optional custom slug. Auto-generated if not provided.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage slug(String slug) {
      this.slug = Optional.ofNullable(slug);
      return this;
    }

    /**
     * <p>Optional custom slug. Auto-generated if not provided.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "slug",
        nulls = Nulls.SKIP
    )
    public _FinalStage slug(Optional<String> slug) {
      this.slug = slug;
      return this;
    }

    @java.lang.Override
    public CreateContextRequest build() {
      return new CreateContextRequest(name, slug, description, schema, autoExecuteDecisions, ttlSeconds, historyLimit, onSchemaMismatch, webhookOnSolve, webhookOnExpire, additionalProperties);
    }
  }
}
