/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.contexts.admin.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.resources.contexts.admin.types.UpdateContextRequestOnSchemaMismatch;
import com.rulebricks.resources.contexts.admin.types.UpdateContextRequestSchemaItem;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = UpdateContextRequest.Builder.class
)
public final class UpdateContextRequest {
  private final Optional<String> name;

  private final Optional<String> slug;

  private final Optional<String> description;

  private final Optional<List<UpdateContextRequestSchemaItem>> schema;

  private final Optional<Boolean> autoExecuteDecisions;

  private final Optional<Integer> ttlSeconds;

  private final Optional<Integer> historyLimit;

  private final Optional<UpdateContextRequestOnSchemaMismatch> onSchemaMismatch;

  private final Optional<String> webhookOnSolve;

  private final Optional<String> webhookOnExpire;

  private final Map<String, Object> additionalProperties;

  private UpdateContextRequest(Optional<String> name, Optional<String> slug,
      Optional<String> description, Optional<List<UpdateContextRequestSchemaItem>> schema,
      Optional<Boolean> autoExecuteDecisions, Optional<Integer> ttlSeconds,
      Optional<Integer> historyLimit,
      Optional<UpdateContextRequestOnSchemaMismatch> onSchemaMismatch,
      Optional<String> webhookOnSolve, Optional<String> webhookOnExpire,
      Map<String, Object> additionalProperties) {
    this.name = name;
    this.slug = slug;
    this.description = description;
    this.schema = schema;
    this.autoExecuteDecisions = autoExecuteDecisions;
    this.ttlSeconds = ttlSeconds;
    this.historyLimit = historyLimit;
    this.onSchemaMismatch = onSchemaMismatch;
    this.webhookOnSolve = webhookOnSolve;
    this.webhookOnExpire = webhookOnExpire;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The name of the context.
   */
  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return The slug of the context.
   */
  @JsonProperty("slug")
  public Optional<String> getSlug() {
    return slug;
  }

  /**
   * @return The description of the context.
   */
  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  /**
   * @return Updated schema fields for the context.
   */
  @JsonProperty("schema")
  public Optional<List<UpdateContextRequestSchemaItem>> getSchema() {
    return schema;
  }

  /**
   * @return When true, bound rules and flows automatically execute when their inputs are satisfied.
   */
  @JsonProperty("auto_execute_decisions")
  public Optional<Boolean> getAutoExecuteDecisions() {
    return autoExecuteDecisions;
  }

  /**
   * @return Time-to-live in seconds for live context instances. Instances expire after this duration.
   */
  @JsonIgnore
  public Optional<Integer> getTtlSeconds() {
    if (ttlSeconds == null) {
      return Optional.empty();
    }
    return ttlSeconds;
  }

  /**
   * @return Maximum number of history entries to retain per field.
   */
  @JsonProperty("history_limit")
  public Optional<Integer> getHistoryLimit() {
    return historyLimit;
  }

  /**
   * @return How to handle fields that don't match the schema.
   */
  @JsonProperty("on_schema_mismatch")
  public Optional<UpdateContextRequestOnSchemaMismatch> getOnSchemaMismatch() {
    return onSchemaMismatch;
  }

  /**
   * @return Webhook URL called when a rule or flow successfully solves.
   */
  @JsonIgnore
  public Optional<String> getWebhookOnSolve() {
    if (webhookOnSolve == null) {
      return Optional.empty();
    }
    return webhookOnSolve;
  }

  /**
   * @return Webhook URL called when a live context expires due to TTL.
   */
  @JsonIgnore
  public Optional<String> getWebhookOnExpire() {
    if (webhookOnExpire == null) {
      return Optional.empty();
    }
    return webhookOnExpire;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("ttl_seconds")
  private Optional<Integer> _getTtlSeconds() {
    return ttlSeconds;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("webhook_on_solve")
  private Optional<String> _getWebhookOnSolve() {
    return webhookOnSolve;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("webhook_on_expire")
  private Optional<String> _getWebhookOnExpire() {
    return webhookOnExpire;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof UpdateContextRequest && equalTo((UpdateContextRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(UpdateContextRequest other) {
    return name.equals(other.name) && slug.equals(other.slug) && description.equals(other.description) && schema.equals(other.schema) && autoExecuteDecisions.equals(other.autoExecuteDecisions) && ttlSeconds.equals(other.ttlSeconds) && historyLimit.equals(other.historyLimit) && onSchemaMismatch.equals(other.onSchemaMismatch) && webhookOnSolve.equals(other.webhookOnSolve) && webhookOnExpire.equals(other.webhookOnExpire);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.name, this.slug, this.description, this.schema, this.autoExecuteDecisions, this.ttlSeconds, this.historyLimit, this.onSchemaMismatch, this.webhookOnSolve, this.webhookOnExpire);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> name = Optional.empty();

    private Optional<String> slug = Optional.empty();

    private Optional<String> description = Optional.empty();

    private Optional<List<UpdateContextRequestSchemaItem>> schema = Optional.empty();

    private Optional<Boolean> autoExecuteDecisions = Optional.empty();

    private Optional<Integer> ttlSeconds = Optional.empty();

    private Optional<Integer> historyLimit = Optional.empty();

    private Optional<UpdateContextRequestOnSchemaMismatch> onSchemaMismatch = Optional.empty();

    private Optional<String> webhookOnSolve = Optional.empty();

    private Optional<String> webhookOnExpire = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(UpdateContextRequest other) {
      name(other.getName());
      slug(other.getSlug());
      description(other.getDescription());
      schema(other.getSchema());
      autoExecuteDecisions(other.getAutoExecuteDecisions());
      ttlSeconds(other.getTtlSeconds());
      historyLimit(other.getHistoryLimit());
      onSchemaMismatch(other.getOnSchemaMismatch());
      webhookOnSolve(other.getWebhookOnSolve());
      webhookOnExpire(other.getWebhookOnExpire());
      return this;
    }

    /**
     * <p>The name of the context.</p>
     */
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    /**
     * <p>The slug of the context.</p>
     */
    @JsonSetter(
        value = "slug",
        nulls = Nulls.SKIP
    )
    public Builder slug(Optional<String> slug) {
      this.slug = slug;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = Optional.ofNullable(slug);
      return this;
    }

    /**
     * <p>The description of the context.</p>
     */
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public Builder description(Optional<String> description) {
      this.description = description;
      return this;
    }

    public Builder description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    /**
     * <p>Updated schema fields for the context.</p>
     */
    @JsonSetter(
        value = "schema",
        nulls = Nulls.SKIP
    )
    public Builder schema(Optional<List<UpdateContextRequestSchemaItem>> schema) {
      this.schema = schema;
      return this;
    }

    public Builder schema(List<UpdateContextRequestSchemaItem> schema) {
      this.schema = Optional.ofNullable(schema);
      return this;
    }

    /**
     * <p>When true, bound rules and flows automatically execute when their inputs are satisfied.</p>
     */
    @JsonSetter(
        value = "auto_execute_decisions",
        nulls = Nulls.SKIP
    )
    public Builder autoExecuteDecisions(Optional<Boolean> autoExecuteDecisions) {
      this.autoExecuteDecisions = autoExecuteDecisions;
      return this;
    }

    public Builder autoExecuteDecisions(Boolean autoExecuteDecisions) {
      this.autoExecuteDecisions = Optional.ofNullable(autoExecuteDecisions);
      return this;
    }

    /**
     * <p>Time-to-live in seconds for live context instances. Instances expire after this duration.</p>
     */
    @JsonSetter(
        value = "ttl_seconds",
        nulls = Nulls.SKIP
    )
    public Builder ttlSeconds(Optional<Integer> ttlSeconds) {
      this.ttlSeconds = ttlSeconds;
      return this;
    }

    public Builder ttlSeconds(Integer ttlSeconds) {
      this.ttlSeconds = Optional.ofNullable(ttlSeconds);
      return this;
    }

    public Builder ttlSeconds(Nullable<Integer> ttlSeconds) {
      if (ttlSeconds.isNull()) {
        this.ttlSeconds = null;
      }
      else if (ttlSeconds.isEmpty()) {
        this.ttlSeconds = Optional.empty();
      }
      else {
        this.ttlSeconds = Optional.of(ttlSeconds.get());
      }
      return this;
    }

    /**
     * <p>Maximum number of history entries to retain per field.</p>
     */
    @JsonSetter(
        value = "history_limit",
        nulls = Nulls.SKIP
    )
    public Builder historyLimit(Optional<Integer> historyLimit) {
      this.historyLimit = historyLimit;
      return this;
    }

    public Builder historyLimit(Integer historyLimit) {
      this.historyLimit = Optional.ofNullable(historyLimit);
      return this;
    }

    /**
     * <p>How to handle fields that don't match the schema.</p>
     */
    @JsonSetter(
        value = "on_schema_mismatch",
        nulls = Nulls.SKIP
    )
    public Builder onSchemaMismatch(
        Optional<UpdateContextRequestOnSchemaMismatch> onSchemaMismatch) {
      this.onSchemaMismatch = onSchemaMismatch;
      return this;
    }

    public Builder onSchemaMismatch(UpdateContextRequestOnSchemaMismatch onSchemaMismatch) {
      this.onSchemaMismatch = Optional.ofNullable(onSchemaMismatch);
      return this;
    }

    /**
     * <p>Webhook URL called when a rule or flow successfully solves.</p>
     */
    @JsonSetter(
        value = "webhook_on_solve",
        nulls = Nulls.SKIP
    )
    public Builder webhookOnSolve(Optional<String> webhookOnSolve) {
      this.webhookOnSolve = webhookOnSolve;
      return this;
    }

    public Builder webhookOnSolve(String webhookOnSolve) {
      this.webhookOnSolve = Optional.ofNullable(webhookOnSolve);
      return this;
    }

    public Builder webhookOnSolve(Nullable<String> webhookOnSolve) {
      if (webhookOnSolve.isNull()) {
        this.webhookOnSolve = null;
      }
      else if (webhookOnSolve.isEmpty()) {
        this.webhookOnSolve = Optional.empty();
      }
      else {
        this.webhookOnSolve = Optional.of(webhookOnSolve.get());
      }
      return this;
    }

    /**
     * <p>Webhook URL called when a live context expires due to TTL.</p>
     */
    @JsonSetter(
        value = "webhook_on_expire",
        nulls = Nulls.SKIP
    )
    public Builder webhookOnExpire(Optional<String> webhookOnExpire) {
      this.webhookOnExpire = webhookOnExpire;
      return this;
    }

    public Builder webhookOnExpire(String webhookOnExpire) {
      this.webhookOnExpire = Optional.ofNullable(webhookOnExpire);
      return this;
    }

    public Builder webhookOnExpire(Nullable<String> webhookOnExpire) {
      if (webhookOnExpire.isNull()) {
        this.webhookOnExpire = null;
      }
      else if (webhookOnExpire.isEmpty()) {
        this.webhookOnExpire = Optional.empty();
      }
      else {
        this.webhookOnExpire = Optional.of(webhookOnExpire.get());
      }
      return this;
    }

    public UpdateContextRequest build() {
      return new UpdateContextRequest(name, slug, description, schema, autoExecuteDecisions, ttlSeconds, historyLimit, onSchemaMismatch, webhookOnSolve, webhookOnExpire, additionalProperties);
    }
  }
}
