/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.contexts.relationships;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.contexts.relationships.requests.CreateRelationshipRequest;
import com.rulebricks.resources.contexts.relationships.requests.DeleteRelationshipsRequest;
import com.rulebricks.resources.contexts.relationships.requests.ListRelationshipsRequest;
import com.rulebricks.types.ContextRelationshipOutgoing;
import com.rulebricks.types.ContextRelationshipsResponse;
import com.rulebricks.types.DeleteRelationshipResponse;
import java.lang.String;
import java.util.concurrent.CompletableFuture;

public class AsyncRelationshipsClient {
  protected final ClientOptions clientOptions;

  private final AsyncRawRelationshipsClient rawClient;

  public AsyncRelationshipsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new AsyncRawRelationshipsClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public AsyncRawRelationshipsClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * List all relationships for a specific context.
   */
  public CompletableFuture<ContextRelationshipsResponse> list(String id) {
    return this.rawClient.list(id).thenApply(response -> response.body());
  }

  /**
   * List all relationships for a specific context.
   */
  public CompletableFuture<ContextRelationshipsResponse> list(String id,
      ListRelationshipsRequest request) {
    return this.rawClient.list(id, request).thenApply(response -> response.body());
  }

  /**
   * List all relationships for a specific context.
   */
  public CompletableFuture<ContextRelationshipsResponse> list(String id,
      ListRelationshipsRequest request, RequestOptions requestOptions) {
    return this.rawClient.list(id, request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Create a new relationship between two contexts.
   */
  public CompletableFuture<ContextRelationshipOutgoing> create(String id,
      CreateRelationshipRequest request) {
    return this.rawClient.create(id, request).thenApply(response -> response.body());
  }

  /**
   * Create a new relationship between two contexts.
   */
  public CompletableFuture<ContextRelationshipOutgoing> create(String id,
      CreateRelationshipRequest request, RequestOptions requestOptions) {
    return this.rawClient.create(id, request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Delete a specific relationship between contexts.
   */
  public CompletableFuture<DeleteRelationshipResponse> delete(String id, String relationship) {
    return this.rawClient.delete(id, relationship).thenApply(response -> response.body());
  }

  /**
   * Delete a specific relationship between contexts.
   */
  public CompletableFuture<DeleteRelationshipResponse> delete(String id, String relationship,
      DeleteRelationshipsRequest request) {
    return this.rawClient.delete(id, relationship, request).thenApply(response -> response.body());
  }

  /**
   * Delete a specific relationship between contexts.
   */
  public CompletableFuture<DeleteRelationshipResponse> delete(String id, String relationship,
      DeleteRelationshipsRequest request, RequestOptions requestOptions) {
    return this.rawClient.delete(id, relationship, request, requestOptions).thenApply(response -> response.body());
  }
}
