/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.contexts.relationships;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.contexts.relationships.requests.CreateRelationshipRequest;
import com.rulebricks.resources.contexts.relationships.requests.DeleteRelationshipsRequest;
import com.rulebricks.resources.contexts.relationships.requests.ListRelationshipsRequest;
import com.rulebricks.types.ContextRelationshipOutgoing;
import com.rulebricks.types.ContextRelationshipsResponse;
import com.rulebricks.types.DeleteRelationshipResponse;
import java.lang.String;

public class RelationshipsClient {
  protected final ClientOptions clientOptions;

  private final RawRelationshipsClient rawClient;

  public RelationshipsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new RawRelationshipsClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public RawRelationshipsClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * List all relationships for a specific context.
   */
  public ContextRelationshipsResponse list(String id) {
    return this.rawClient.list(id).body();
  }

  /**
   * List all relationships for a specific context.
   */
  public ContextRelationshipsResponse list(String id, ListRelationshipsRequest request) {
    return this.rawClient.list(id, request).body();
  }

  /**
   * List all relationships for a specific context.
   */
  public ContextRelationshipsResponse list(String id, ListRelationshipsRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.list(id, request, requestOptions).body();
  }

  /**
   * Create a new relationship between two contexts.
   */
  public ContextRelationshipOutgoing create(String id, CreateRelationshipRequest request) {
    return this.rawClient.create(id, request).body();
  }

  /**
   * Create a new relationship between two contexts.
   */
  public ContextRelationshipOutgoing create(String id, CreateRelationshipRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.create(id, request, requestOptions).body();
  }

  /**
   * Delete a specific relationship between contexts.
   */
  public DeleteRelationshipResponse delete(String id, String relationship) {
    return this.rawClient.delete(id, relationship).body();
  }

  /**
   * Delete a specific relationship between contexts.
   */
  public DeleteRelationshipResponse delete(String id, String relationship,
      DeleteRelationshipsRequest request) {
    return this.rawClient.delete(id, relationship, request).body();
  }

  /**
   * Delete a specific relationship between contexts.
   */
  public DeleteRelationshipResponse delete(String id, String relationship,
      DeleteRelationshipsRequest request, RequestOptions requestOptions) {
    return this.rawClient.delete(id, relationship, request, requestOptions).body();
  }
}
