/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.contexts.relationships.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.resources.contexts.relationships.types.CreateRelationshipRequestType;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = CreateRelationshipRequest.Builder.class
)
public final class CreateRelationshipRequest {
  private final String targetContextId;

  private final CreateRelationshipRequestType type;

  private final String foreignKey;

  private final Optional<String> name;

  private final Optional<String> description;

  private final Map<String, Object> additionalProperties;

  private CreateRelationshipRequest(String targetContextId, CreateRelationshipRequestType type,
      String foreignKey, Optional<String> name, Optional<String> description,
      Map<String, Object> additionalProperties) {
    this.targetContextId = targetContextId;
    this.type = type;
    this.foreignKey = foreignKey;
    this.name = name;
    this.description = description;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The ID of the target context.
   */
  @JsonProperty("targetContextId")
  public String getTargetContextId() {
    return targetContextId;
  }

  /**
   * @return The type of relationship.
   */
  @JsonProperty("type")
  public CreateRelationshipRequestType getType() {
    return type;
  }

  /**
   * @return The field key to use as the foreign key.
   */
  @JsonProperty("foreignKey")
  public String getForeignKey() {
    return foreignKey;
  }

  /**
   * @return Display name for the relationship.
   */
  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return Description of the relationship.
   */
  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CreateRelationshipRequest && equalTo((CreateRelationshipRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CreateRelationshipRequest other) {
    return targetContextId.equals(other.targetContextId) && type.equals(other.type) && foreignKey.equals(other.foreignKey) && name.equals(other.name) && description.equals(other.description);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.targetContextId, this.type, this.foreignKey, this.name, this.description);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static TargetContextIdStage builder() {
    return new Builder();
  }

  public interface TargetContextIdStage {
    /**
     * <p>The ID of the target context.</p>
     */
    TypeStage targetContextId(@NotNull String targetContextId);

    Builder from(CreateRelationshipRequest other);
  }

  public interface TypeStage {
    /**
     * <p>The type of relationship.</p>
     */
    ForeignKeyStage type(@NotNull CreateRelationshipRequestType type);
  }

  public interface ForeignKeyStage {
    /**
     * <p>The field key to use as the foreign key.</p>
     */
    _FinalStage foreignKey(@NotNull String foreignKey);
  }

  public interface _FinalStage {
    CreateRelationshipRequest build();

    /**
     * <p>Display name for the relationship.</p>
     */
    _FinalStage name(Optional<String> name);

    _FinalStage name(String name);

    /**
     * <p>Description of the relationship.</p>
     */
    _FinalStage description(Optional<String> description);

    _FinalStage description(String description);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements TargetContextIdStage, TypeStage, ForeignKeyStage, _FinalStage {
    private String targetContextId;

    private CreateRelationshipRequestType type;

    private String foreignKey;

    private Optional<String> description = Optional.empty();

    private Optional<String> name = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(CreateRelationshipRequest other) {
      targetContextId(other.getTargetContextId());
      type(other.getType());
      foreignKey(other.getForeignKey());
      name(other.getName());
      description(other.getDescription());
      return this;
    }

    /**
     * <p>The ID of the target context.</p>
     * <p>The ID of the target context.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("targetContextId")
    public TypeStage targetContextId(@NotNull String targetContextId) {
      this.targetContextId = Objects.requireNonNull(targetContextId, "targetContextId must not be null");
      return this;
    }

    /**
     * <p>The type of relationship.</p>
     * <p>The type of relationship.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("type")
    public ForeignKeyStage type(@NotNull CreateRelationshipRequestType type) {
      this.type = Objects.requireNonNull(type, "type must not be null");
      return this;
    }

    /**
     * <p>The field key to use as the foreign key.</p>
     * <p>The field key to use as the foreign key.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("foreignKey")
    public _FinalStage foreignKey(@NotNull String foreignKey) {
      this.foreignKey = Objects.requireNonNull(foreignKey, "foreignKey must not be null");
      return this;
    }

    /**
     * <p>Description of the relationship.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    /**
     * <p>Description of the relationship.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public _FinalStage description(Optional<String> description) {
      this.description = description;
      return this;
    }

    /**
     * <p>Display name for the relationship.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    /**
     * <p>Display name for the relationship.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public _FinalStage name(Optional<String> name) {
      this.name = name;
      return this;
    }

    @java.lang.Override
    public CreateRelationshipRequest build() {
      return new CreateRelationshipRequest(targetContextId, type, foreignKey, name, description, additionalProperties);
    }
  }
}
