/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.contexts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = CascadeContextRequest.Builder.class
)
public final class CascadeContextRequest {
  private final Optional<Integer> maxDepth;

  private final Map<String, Object> additionalProperties;

  private CascadeContextRequest(Optional<Integer> maxDepth,
      Map<String, Object> additionalProperties) {
    this.maxDepth = maxDepth;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Maximum depth for cascading evaluations.
   */
  @JsonProperty("maxDepth")
  public Optional<Integer> getMaxDepth() {
    return maxDepth;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CascadeContextRequest && equalTo((CascadeContextRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CascadeContextRequest other) {
    return maxDepth.equals(other.maxDepth);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.maxDepth);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<Integer> maxDepth = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(CascadeContextRequest other) {
      maxDepth(other.getMaxDepth());
      return this;
    }

    /**
     * <p>Maximum depth for cascading evaluations.</p>
     */
    @JsonSetter(
        value = "maxDepth",
        nulls = Nulls.SKIP
    )
    public Builder maxDepth(Optional<Integer> maxDepth) {
      this.maxDepth = maxDepth;
      return this;
    }

    public Builder maxDepth(Integer maxDepth) {
      this.maxDepth = Optional.ofNullable(maxDepth);
      return this;
    }

    public CascadeContextRequest build() {
      return new CascadeContextRequest(maxDepth, additionalProperties);
    }
  }
}
