/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.contexts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = GetHistoryContextsRequest.Builder.class
)
public final class GetHistoryContextsRequest {
  private final Optional<String> field;

  private final Optional<Integer> limit;

  private final Map<String, Object> additionalProperties;

  private GetHistoryContextsRequest(Optional<String> field, Optional<Integer> limit,
      Map<String, Object> additionalProperties) {
    this.field = field;
    this.limit = limit;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Filter history to a specific field.
   */
  @JsonProperty("field")
  public Optional<String> getField() {
    return field;
  }

  /**
   * @return Maximum number of history entries to return.
   */
  @JsonProperty("limit")
  public Optional<Integer> getLimit() {
    return limit;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof GetHistoryContextsRequest && equalTo((GetHistoryContextsRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(GetHistoryContextsRequest other) {
    return field.equals(other.field) && limit.equals(other.limit);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.field, this.limit);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> field = Optional.empty();

    private Optional<Integer> limit = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(GetHistoryContextsRequest other) {
      field(other.getField());
      limit(other.getLimit());
      return this;
    }

    /**
     * <p>Filter history to a specific field.</p>
     */
    @JsonSetter(
        value = "field",
        nulls = Nulls.SKIP
    )
    public Builder field(Optional<String> field) {
      this.field = field;
      return this;
    }

    public Builder field(String field) {
      this.field = Optional.ofNullable(field);
      return this;
    }

    /**
     * <p>Maximum number of history entries to return.</p>
     */
    @JsonSetter(
        value = "limit",
        nulls = Nulls.SKIP
    )
    public Builder limit(Optional<Integer> limit) {
      this.limit = limit;
      return this;
    }

    public Builder limit(Integer limit) {
      this.limit = Optional.ofNullable(limit);
      return this;
    }

    public GetHistoryContextsRequest build() {
      return new GetHistoryContextsRequest(field, limit, additionalProperties);
    }
  }
}
