/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.contexts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = SolveContextFlowRequest.Builder.class
)
public final class SolveContextFlowRequest {
  private final Optional<Map<String, Object>> additionalData;

  private final Optional<Boolean> persist;

  private final Map<String, Object> additionalProperties;

  private SolveContextFlowRequest(Optional<Map<String, Object>> additionalData,
      Optional<Boolean> persist, Map<String, Object> additionalProperties) {
    this.additionalData = additionalData;
    this.persist = persist;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Additional data to merge with instance state for flow execution.
   */
  @JsonProperty("additionalData")
  public Optional<Map<String, Object>> getAdditionalData() {
    return additionalData;
  }

  /**
   * @return Whether to persist derived outputs to the instance.
   */
  @JsonProperty("persist")
  public Optional<Boolean> getPersist() {
    return persist;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof SolveContextFlowRequest && equalTo((SolveContextFlowRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(SolveContextFlowRequest other) {
    return additionalData.equals(other.additionalData) && persist.equals(other.persist);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.additionalData, this.persist);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<Map<String, Object>> additionalData = Optional.empty();

    private Optional<Boolean> persist = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(SolveContextFlowRequest other) {
      additionalData(other.getAdditionalData());
      persist(other.getPersist());
      return this;
    }

    /**
     * <p>Additional data to merge with instance state for flow execution.</p>
     */
    @JsonSetter(
        value = "additionalData",
        nulls = Nulls.SKIP
    )
    public Builder additionalData(Optional<Map<String, Object>> additionalData) {
      this.additionalData = additionalData;
      return this;
    }

    public Builder additionalData(Map<String, Object> additionalData) {
      this.additionalData = Optional.ofNullable(additionalData);
      return this;
    }

    /**
     * <p>Whether to persist derived outputs to the instance.</p>
     */
    @JsonSetter(
        value = "persist",
        nulls = Nulls.SKIP
    )
    public Builder persist(Optional<Boolean> persist) {
      this.persist = persist;
      return this;
    }

    public Builder persist(Boolean persist) {
      this.persist = Optional.ofNullable(persist);
      return this;
    }

    public SolveContextFlowRequest build() {
      return new SolveContextFlowRequest(additionalData, persist, additionalProperties);
    }
  }
}
