/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.decisions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.QueryStringMapper;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.core.RulebricksApiHttpResponse;
import com.rulebricks.errors.BadRequestError;
import com.rulebricks.errors.InternalServerError;
import com.rulebricks.resources.decisions.requests.QueryDecisionsRequest;
import com.rulebricks.types.DecisionLogResponse;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawDecisionsClient {
  protected final ClientOptions clientOptions;

  public AsyncRawDecisionsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Query decision logs with support for the decision data query language, rule/status filters, date ranges, and pagination. The query language supports field comparisons (e.g., <code>alpha=0</code>, <code>score&gt;10</code>), contains/not-contains (e.g., <code>name:John</code>, <code>status!:error</code>), boolean logic (<code>AND</code>, <code>OR</code>), and parentheses for grouping.
   */
  public CompletableFuture<RulebricksApiHttpResponse<DecisionLogResponse>> query() {
    return query(QueryDecisionsRequest.builder().build());
  }

  /**
   * Query decision logs with support for the decision data query language, rule/status filters, date ranges, and pagination. The query language supports field comparisons (e.g., <code>alpha=0</code>, <code>score&gt;10</code>), contains/not-contains (e.g., <code>name:John</code>, <code>status!:error</code>), boolean logic (<code>AND</code>, <code>OR</code>), and parentheses for grouping.
   */
  public CompletableFuture<RulebricksApiHttpResponse<DecisionLogResponse>> query(
      QueryDecisionsRequest request) {
    return query(request,null);
  }

  /**
   * Query decision logs with support for the decision data query language, rule/status filters, date ranges, and pagination. The query language supports field comparisons (e.g., <code>alpha=0</code>, <code>score&gt;10</code>), contains/not-contains (e.g., <code>name:John</code>, <code>status!:error</code>), boolean logic (<code>AND</code>, <code>OR</code>), and parentheses for grouping.
   */
  public CompletableFuture<RulebricksApiHttpResponse<DecisionLogResponse>> query(
      QueryDecisionsRequest request, RequestOptions requestOptions) {
    HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("decisions/query");if (request.getSearch().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "search", request.getSearch().get(), false);
      }
      if (request.getRules().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "rules", request.getRules().get(), false);
      }
      if (request.getStatuses().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "statuses", request.getStatuses().get(), false);
      }
      if (request.getStart().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "start", request.getStart().get(), false);
      }
      if (request.getEnd().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "end", request.getEnd().get(), false);
      }
      if (request.getCursor().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
      }
      if (request.getLimit().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
      }
      if (request.getCount().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "count", request.getCount().get(), false);
      }
      if (request.getSlug().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "slug", request.getSlug().get(), false);
      }
      Request.Builder _requestBuilder = new Request.Builder()
        .url(httpUrl.build())
        .method("GET", null)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Accept", "application/json");
      Request okhttpRequest = _requestBuilder.build();
      OkHttpClient client = clientOptions.httpClient();
      if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
        client = clientOptions.httpClientWithTimeout(requestOptions);
      }
      CompletableFuture<RulebricksApiHttpResponse<DecisionLogResponse>> future = new CompletableFuture<>();
      client.newCall(okhttpRequest).enqueue(new Callback() {
        @Override
        public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
          try (ResponseBody responseBody = response.body()) {
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
              future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, DecisionLogResponse.class), response));
              return;
            }
            try {
              switch (response.code()) {
                case 400:future.completeExceptionally(new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
                case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                return;
              }
            }
            catch (JsonProcessingException ignored) {
              // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
            return;
          }
          catch (IOException e) {
            future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
          }
        }

        @Override
        public void onFailure(@NotNull Call call, @NotNull IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      });
      return future;
    }
  }
