/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.tests.flows;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.MediaTypes;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.core.RulebricksApiHttpResponse;
import com.rulebricks.errors.BadRequestError;
import com.rulebricks.errors.InternalServerError;
import com.rulebricks.errors.NotFoundError;
import com.rulebricks.resources.tests.flows.requests.CreateFlowsRequest;
import com.rulebricks.resources.tests.flows.requests.DeleteFlowsRequest;
import com.rulebricks.resources.tests.flows.requests.ListFlowsRequest;
import com.rulebricks.types.Test;
import java.io.IOException;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawFlowsClient {
  protected final ClientOptions clientOptions;

  public RawFlowsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Retrieves a list of tests associated with the flow identified by the slug.
   */
  public RulebricksApiHttpResponse<List<Test>> list(String slug) {
    return list(slug,ListFlowsRequest.builder().build());
  }

  /**
   * Retrieves a list of tests associated with the flow identified by the slug.
   */
  public RulebricksApiHttpResponse<List<Test>> list(String slug, ListFlowsRequest request) {
    return list(slug,request,null);
  }

  /**
   * Retrieves a list of tests associated with the flow identified by the slug.
   */
  public RulebricksApiHttpResponse<List<Test>> list(String slug, ListFlowsRequest request,
      RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/flows")
      .addPathSegment(slug)
      .addPathSegments("tests")
      .build();
    Request.Builder _requestBuilder = new Request.Builder()
      .url(httpUrl)
      .method("GET", null)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Accept", "application/json");
    Request okhttpRequest = _requestBuilder.build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    try (Response response = client.newCall(okhttpRequest).execute()) {
      ResponseBody responseBody = response.body();
      String responseBodyString = responseBody != null ? responseBody.string() : "{}";
      if (response.isSuccessful()) {
        return new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, new TypeReference<List<Test>>() {}), response);
      }
      try {
        switch (response.code()) {
          case 404:throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
          case 500:throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
      }
      catch (JsonProcessingException ignored) {
        // unable to map error response, throwing generic error
      }
      Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
      throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
    }
    catch (IOException e) {
      throw new RulebricksApiException("Network error executing HTTP request", e);
    }
  }

  /**
   * Adds a new test to the test suite of a flow identified by the slug.
   */
  public RulebricksApiHttpResponse<Test> create(String slug, CreateFlowsRequest request) {
    return create(slug,request,null);
  }

  /**
   * Adds a new test to the test suite of a flow identified by the slug.
   */
  public RulebricksApiHttpResponse<Test> create(String slug, CreateFlowsRequest request,
      RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/flows")
      .addPathSegment(slug)
      .addPathSegments("tests")
      .build();
    RequestBody body;
    try {
      body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), MediaTypes.APPLICATION_JSON);
    }
    catch(JsonProcessingException e) {
      throw new RulebricksApiException("Failed to serialize request", e);
    }
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("POST", body)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .addHeader("Accept", "application/json")
      .build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    try (Response response = client.newCall(okhttpRequest).execute()) {
      ResponseBody responseBody = response.body();
      String responseBodyString = responseBody != null ? responseBody.string() : "{}";
      if (response.isSuccessful()) {
        return new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Test.class), response);
      }
      try {
        switch (response.code()) {
          case 400:throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
          case 404:throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
          case 500:throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
      }
      catch (JsonProcessingException ignored) {
        // unable to map error response, throwing generic error
      }
      Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
      throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
    }
    catch (IOException e) {
      throw new RulebricksApiException("Network error executing HTTP request", e);
    }
  }

  /**
   * Deletes a test from the test suite of a flow identified by the slug.
   */
  public RulebricksApiHttpResponse<Test> delete(String slug, String testId) {
    return delete(slug,testId,DeleteFlowsRequest.builder().build());
  }

  /**
   * Deletes a test from the test suite of a flow identified by the slug.
   */
  public RulebricksApiHttpResponse<Test> delete(String slug, String testId,
      DeleteFlowsRequest request) {
    return delete(slug,testId,request,null);
  }

  /**
   * Deletes a test from the test suite of a flow identified by the slug.
   */
  public RulebricksApiHttpResponse<Test> delete(String slug, String testId,
      DeleteFlowsRequest request, RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/flows")
      .addPathSegment(slug)
      .addPathSegments("tests")
      .addPathSegment(testId)
      .build();
    Request.Builder _requestBuilder = new Request.Builder()
      .url(httpUrl)
      .method("DELETE", null)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Accept", "application/json");
    Request okhttpRequest = _requestBuilder.build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    try (Response response = client.newCall(okhttpRequest).execute()) {
      ResponseBody responseBody = response.body();
      String responseBodyString = responseBody != null ? responseBody.string() : "{}";
      if (response.isSuccessful()) {
        return new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Test.class), response);
      }
      try {
        switch (response.code()) {
          case 404:throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
          case 500:throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
      }
      catch (JsonProcessingException ignored) {
        // unable to map error response, throwing generic error
      }
      Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
      throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
    }
    catch (IOException e) {
      throw new RulebricksApiException("Network error executing HTTP request", e);
    }
  }
}
