/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ContextDetailBoundFlowsItem.Builder.class
)
public final class ContextDetailBoundFlowsItem {
  private final Optional<String> id;

  private final Optional<String> name;

  private final Optional<String> slug;

  private final Optional<Boolean> published;

  private final Optional<ContextDetailBoundFlowsItemOriginRule> originRule;

  private final Map<String, Object> additionalProperties;

  private ContextDetailBoundFlowsItem(Optional<String> id, Optional<String> name,
      Optional<String> slug, Optional<Boolean> published,
      Optional<ContextDetailBoundFlowsItemOriginRule> originRule,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.slug = slug;
    this.published = published;
    this.originRule = originRule;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("id")
  public Optional<String> getId() {
    return id;
  }

  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  @JsonProperty("slug")
  public Optional<String> getSlug() {
    return slug;
  }

  @JsonProperty("published")
  public Optional<Boolean> getPublished() {
    return published;
  }

  @JsonIgnore
  public Optional<ContextDetailBoundFlowsItemOriginRule> getOriginRule() {
    if (originRule == null) {
      return Optional.empty();
    }
    return originRule;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("origin_rule")
  private Optional<ContextDetailBoundFlowsItemOriginRule> _getOriginRule() {
    return originRule;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ContextDetailBoundFlowsItem && equalTo((ContextDetailBoundFlowsItem) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ContextDetailBoundFlowsItem other) {
    return id.equals(other.id) && name.equals(other.name) && slug.equals(other.slug) && published.equals(other.published) && originRule.equals(other.originRule);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.slug, this.published, this.originRule);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> id = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> slug = Optional.empty();

    private Optional<Boolean> published = Optional.empty();

    private Optional<ContextDetailBoundFlowsItemOriginRule> originRule = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ContextDetailBoundFlowsItem other) {
      id(other.getId());
      name(other.getName());
      slug(other.getSlug());
      published(other.getPublished());
      originRule(other.getOriginRule());
      return this;
    }

    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public Builder id(Optional<String> id) {
      this.id = id;
      return this;
    }

    public Builder id(String id) {
      this.id = Optional.ofNullable(id);
      return this;
    }

    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    @JsonSetter(
        value = "slug",
        nulls = Nulls.SKIP
    )
    public Builder slug(Optional<String> slug) {
      this.slug = slug;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = Optional.ofNullable(slug);
      return this;
    }

    @JsonSetter(
        value = "published",
        nulls = Nulls.SKIP
    )
    public Builder published(Optional<Boolean> published) {
      this.published = published;
      return this;
    }

    public Builder published(Boolean published) {
      this.published = Optional.ofNullable(published);
      return this;
    }

    @JsonSetter(
        value = "origin_rule",
        nulls = Nulls.SKIP
    )
    public Builder originRule(Optional<ContextDetailBoundFlowsItemOriginRule> originRule) {
      this.originRule = originRule;
      return this;
    }

    public Builder originRule(ContextDetailBoundFlowsItemOriginRule originRule) {
      this.originRule = Optional.ofNullable(originRule);
      return this;
    }

    public Builder originRule(Nullable<ContextDetailBoundFlowsItemOriginRule> originRule) {
      if (originRule.isNull()) {
        this.originRule = null;
      }
      else if (originRule.isEmpty()) {
        this.originRule = Optional.empty();
      }
      else {
        this.originRule = Optional.of(originRule.get());
      }
      return this;
    }

    public ContextDetailBoundFlowsItem build() {
      return new ContextDetailBoundFlowsItem(id, name, slug, published, originRule, additionalProperties);
    }
  }
}
