/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ContextInstanceHistory.Builder.class
)
public final class ContextInstanceHistory {
  private final Optional<String> context;

  private final Optional<Map<String, List<ContextInstanceHistoryEntry>>> history;

  private final Map<String, Object> additionalProperties;

  private ContextInstanceHistory(Optional<String> context,
      Optional<Map<String, List<ContextInstanceHistoryEntry>>> history,
      Map<String, Object> additionalProperties) {
    this.context = context;
    this.history = history;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Combined identifier in format 'contextSlug:instanceId'.
   */
  @JsonProperty("context")
  public Optional<String> getContext() {
    return context;
  }

  /**
   * @return Map of field keys to arrays of historical values, newest first.
   */
  @JsonProperty("history")
  public Optional<Map<String, List<ContextInstanceHistoryEntry>>> getHistory() {
    return history;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ContextInstanceHistory && equalTo((ContextInstanceHistory) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ContextInstanceHistory other) {
    return context.equals(other.context) && history.equals(other.history);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.context, this.history);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> context = Optional.empty();

    private Optional<Map<String, List<ContextInstanceHistoryEntry>>> history = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ContextInstanceHistory other) {
      context(other.getContext());
      history(other.getHistory());
      return this;
    }

    /**
     * <p>Combined identifier in format 'contextSlug:instanceId'.</p>
     */
    @JsonSetter(
        value = "context",
        nulls = Nulls.SKIP
    )
    public Builder context(Optional<String> context) {
      this.context = context;
      return this;
    }

    public Builder context(String context) {
      this.context = Optional.ofNullable(context);
      return this;
    }

    /**
     * <p>Map of field keys to arrays of historical values, newest first.</p>
     */
    @JsonSetter(
        value = "history",
        nulls = Nulls.SKIP
    )
    public Builder history(Optional<Map<String, List<ContextInstanceHistoryEntry>>> history) {
      this.history = history;
      return this;
    }

    public Builder history(Map<String, List<ContextInstanceHistoryEntry>> history) {
      this.history = Optional.ofNullable(history);
      return this;
    }

    public ContextInstanceHistory build() {
      return new ContextInstanceHistory(context, history, additionalProperties);
    }
  }
}
