/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ContextSchemaField.Builder.class
)
public final class ContextSchemaField {
  private final Optional<String> key;

  private final Optional<String> name;

  private final Optional<String> description;

  private final Optional<ContextSchemaFieldType> type;

  private final Optional<Object> defaultValue;

  private final Optional<Boolean> derived;

  private final Optional<String> sourceRule;

  private final Optional<String> sourceFlow;

  private final Optional<String> sourceField;

  private final Map<String, Object> additionalProperties;

  private ContextSchemaField(Optional<String> key, Optional<String> name,
      Optional<String> description, Optional<ContextSchemaFieldType> type,
      Optional<Object> defaultValue, Optional<Boolean> derived, Optional<String> sourceRule,
      Optional<String> sourceFlow, Optional<String> sourceField,
      Map<String, Object> additionalProperties) {
    this.key = key;
    this.name = name;
    this.description = description;
    this.type = type;
    this.defaultValue = defaultValue;
    this.derived = derived;
    this.sourceRule = sourceRule;
    this.sourceFlow = sourceFlow;
    this.sourceField = sourceField;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The unique key for this field.
   */
  @JsonProperty("key")
  public Optional<String> getKey() {
    return key;
  }

  /**
   * @return Display name for this field.
   */
  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return Description of this field.
   */
  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  /**
   * @return Data type of this field. 'function' type fields compute values dynamically.
   */
  @JsonProperty("type")
  public Optional<ContextSchemaFieldType> getType() {
    return type;
  }

  /**
   * @return Default value for this field.
   */
  @JsonIgnore
  public Optional<Object> getDefaultValue() {
    if (defaultValue == null) {
      return Optional.empty();
    }
    return defaultValue;
  }

  /**
   * @return Whether this field is derived from rule/flow outputs.
   */
  @JsonProperty("derived")
  public Optional<Boolean> getDerived() {
    return derived;
  }

  /**
   * @return The rule ID that derives this field (if derived).
   */
  @JsonIgnore
  public Optional<String> getSourceRule() {
    if (sourceRule == null) {
      return Optional.empty();
    }
    return sourceRule;
  }

  /**
   * @return The flow ID that derives this field (if derived).
   */
  @JsonIgnore
  public Optional<String> getSourceFlow() {
    if (sourceFlow == null) {
      return Optional.empty();
    }
    return sourceFlow;
  }

  /**
   * @return The source field key in the rule/flow output.
   */
  @JsonIgnore
  public Optional<String> getSourceField() {
    if (sourceField == null) {
      return Optional.empty();
    }
    return sourceField;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("defaultValue")
  private Optional<Object> _getDefaultValue() {
    return defaultValue;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("sourceRule")
  private Optional<String> _getSourceRule() {
    return sourceRule;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("sourceFlow")
  private Optional<String> _getSourceFlow() {
    return sourceFlow;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("sourceField")
  private Optional<String> _getSourceField() {
    return sourceField;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ContextSchemaField && equalTo((ContextSchemaField) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ContextSchemaField other) {
    return key.equals(other.key) && name.equals(other.name) && description.equals(other.description) && type.equals(other.type) && defaultValue.equals(other.defaultValue) && derived.equals(other.derived) && sourceRule.equals(other.sourceRule) && sourceFlow.equals(other.sourceFlow) && sourceField.equals(other.sourceField);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.key, this.name, this.description, this.type, this.defaultValue, this.derived, this.sourceRule, this.sourceFlow, this.sourceField);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> key = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> description = Optional.empty();

    private Optional<ContextSchemaFieldType> type = Optional.empty();

    private Optional<Object> defaultValue = Optional.empty();

    private Optional<Boolean> derived = Optional.empty();

    private Optional<String> sourceRule = Optional.empty();

    private Optional<String> sourceFlow = Optional.empty();

    private Optional<String> sourceField = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ContextSchemaField other) {
      key(other.getKey());
      name(other.getName());
      description(other.getDescription());
      type(other.getType());
      defaultValue(other.getDefaultValue());
      derived(other.getDerived());
      sourceRule(other.getSourceRule());
      sourceFlow(other.getSourceFlow());
      sourceField(other.getSourceField());
      return this;
    }

    /**
     * <p>The unique key for this field.</p>
     */
    @JsonSetter(
        value = "key",
        nulls = Nulls.SKIP
    )
    public Builder key(Optional<String> key) {
      this.key = key;
      return this;
    }

    public Builder key(String key) {
      this.key = Optional.ofNullable(key);
      return this;
    }

    /**
     * <p>Display name for this field.</p>
     */
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    /**
     * <p>Description of this field.</p>
     */
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public Builder description(Optional<String> description) {
      this.description = description;
      return this;
    }

    public Builder description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    /**
     * <p>Data type of this field. 'function' type fields compute values dynamically.</p>
     */
    @JsonSetter(
        value = "type",
        nulls = Nulls.SKIP
    )
    public Builder type(Optional<ContextSchemaFieldType> type) {
      this.type = type;
      return this;
    }

    public Builder type(ContextSchemaFieldType type) {
      this.type = Optional.ofNullable(type);
      return this;
    }

    /**
     * <p>Default value for this field.</p>
     */
    @JsonSetter(
        value = "defaultValue",
        nulls = Nulls.SKIP
    )
    public Builder defaultValue(Optional<Object> defaultValue) {
      this.defaultValue = defaultValue;
      return this;
    }

    public Builder defaultValue(Object defaultValue) {
      this.defaultValue = Optional.ofNullable(defaultValue);
      return this;
    }

    public Builder defaultValue(Nullable<Object> defaultValue) {
      if (defaultValue.isNull()) {
        this.defaultValue = null;
      }
      else if (defaultValue.isEmpty()) {
        this.defaultValue = Optional.empty();
      }
      else {
        this.defaultValue = Optional.of(defaultValue.get());
      }
      return this;
    }

    /**
     * <p>Whether this field is derived from rule/flow outputs.</p>
     */
    @JsonSetter(
        value = "derived",
        nulls = Nulls.SKIP
    )
    public Builder derived(Optional<Boolean> derived) {
      this.derived = derived;
      return this;
    }

    public Builder derived(Boolean derived) {
      this.derived = Optional.ofNullable(derived);
      return this;
    }

    /**
     * <p>The rule ID that derives this field (if derived).</p>
     */
    @JsonSetter(
        value = "sourceRule",
        nulls = Nulls.SKIP
    )
    public Builder sourceRule(Optional<String> sourceRule) {
      this.sourceRule = sourceRule;
      return this;
    }

    public Builder sourceRule(String sourceRule) {
      this.sourceRule = Optional.ofNullable(sourceRule);
      return this;
    }

    public Builder sourceRule(Nullable<String> sourceRule) {
      if (sourceRule.isNull()) {
        this.sourceRule = null;
      }
      else if (sourceRule.isEmpty()) {
        this.sourceRule = Optional.empty();
      }
      else {
        this.sourceRule = Optional.of(sourceRule.get());
      }
      return this;
    }

    /**
     * <p>The flow ID that derives this field (if derived).</p>
     */
    @JsonSetter(
        value = "sourceFlow",
        nulls = Nulls.SKIP
    )
    public Builder sourceFlow(Optional<String> sourceFlow) {
      this.sourceFlow = sourceFlow;
      return this;
    }

    public Builder sourceFlow(String sourceFlow) {
      this.sourceFlow = Optional.ofNullable(sourceFlow);
      return this;
    }

    public Builder sourceFlow(Nullable<String> sourceFlow) {
      if (sourceFlow.isNull()) {
        this.sourceFlow = null;
      }
      else if (sourceFlow.isEmpty()) {
        this.sourceFlow = Optional.empty();
      }
      else {
        this.sourceFlow = Optional.of(sourceFlow.get());
      }
      return this;
    }

    /**
     * <p>The source field key in the rule/flow output.</p>
     */
    @JsonSetter(
        value = "sourceField",
        nulls = Nulls.SKIP
    )
    public Builder sourceField(Optional<String> sourceField) {
      this.sourceField = sourceField;
      return this;
    }

    public Builder sourceField(String sourceField) {
      this.sourceField = Optional.ofNullable(sourceField);
      return this;
    }

    public Builder sourceField(Nullable<String> sourceField) {
      if (sourceField.isNull()) {
        this.sourceField = null;
      }
      else if (sourceField.isEmpty()) {
        this.sourceField = Optional.empty();
      }
      else {
        this.sourceField = Optional.of(sourceField.get());
      }
      return this;
    }

    public ContextSchemaField build() {
      return new ContextSchemaField(key, name, description, type, defaultValue, derived, sourceRule, sourceFlow, sourceField, additionalProperties);
    }
  }
}
