/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = DecisionLog.Builder.class
)
public final class DecisionLog {
  private final Optional<OffsetDateTime> timestamp;

  private final Optional<String> name;

  private final Optional<String> endpoint;

  private final Optional<Integer> status;

  private final Optional<Map<String, Object>> request;

  private final Optional<Map<String, Object>> response;

  private final Optional<Map<String, Object>> decision;

  private final Optional<String> error;

  private final Optional<Boolean> abbreviated;

  private final Map<String, Object> additionalProperties;

  private DecisionLog(Optional<OffsetDateTime> timestamp, Optional<String> name,
      Optional<String> endpoint, Optional<Integer> status, Optional<Map<String, Object>> request,
      Optional<Map<String, Object>> response, Optional<Map<String, Object>> decision,
      Optional<String> error, Optional<Boolean> abbreviated,
      Map<String, Object> additionalProperties) {
    this.timestamp = timestamp;
    this.name = name;
    this.endpoint = endpoint;
    this.status = status;
    this.request = request;
    this.response = response;
    this.decision = decision;
    this.error = error;
    this.abbreviated = abbreviated;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return When the rule/flow was executed.
   */
  @JsonIgnore
  public Optional<OffsetDateTime> getTimestamp() {
    if (timestamp == null) {
      return Optional.empty();
    }
    return timestamp;
  }

  /**
   * @return Name of the rule or flow that was executed.
   */
  @JsonIgnore
  public Optional<String> getName() {
    if (name == null) {
      return Optional.empty();
    }
    return name;
  }

  /**
   * @return API endpoint that was called.
   */
  @JsonIgnore
  public Optional<String> getEndpoint() {
    if (endpoint == null) {
      return Optional.empty();
    }
    return endpoint;
  }

  /**
   * @return HTTP status code of the response.
   */
  @JsonIgnore
  public Optional<Integer> getStatus() {
    if (status == null) {
      return Optional.empty();
    }
    return status;
  }

  /**
   * @return The request payload sent to the rule/flow.
   */
  @JsonIgnore
  public Optional<Map<String, Object>> getRequest() {
    if (request == null) {
      return Optional.empty();
    }
    return request;
  }

  /**
   * @return The response payload returned by the rule/flow.
   */
  @JsonIgnore
  public Optional<Map<String, Object>> getResponse() {
    if (response == null) {
      return Optional.empty();
    }
    return response;
  }

  /**
   * @return Decision details including matched conditions, rows, and evaluation metadata.
   */
  @JsonIgnore
  public Optional<Map<String, Object>> getDecision() {
    if (decision == null) {
      return Optional.empty();
    }
    return decision;
  }

  /**
   * @return Error message if the execution failed.
   */
  @JsonIgnore
  public Optional<String> getError() {
    if (error == null) {
      return Optional.empty();
    }
    return error;
  }

  /**
   * @return Whether the request/response data was truncated due to size limits.
   */
  @JsonProperty("abbreviated")
  public Optional<Boolean> getAbbreviated() {
    return abbreviated;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("timestamp")
  private Optional<OffsetDateTime> _getTimestamp() {
    return timestamp;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("name")
  private Optional<String> _getName() {
    return name;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("endpoint")
  private Optional<String> _getEndpoint() {
    return endpoint;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("status")
  private Optional<Integer> _getStatus() {
    return status;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("request")
  private Optional<Map<String, Object>> _getRequest() {
    return request;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("response")
  private Optional<Map<String, Object>> _getResponse() {
    return response;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("decision")
  private Optional<Map<String, Object>> _getDecision() {
    return decision;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("error")
  private Optional<String> _getError() {
    return error;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof DecisionLog && equalTo((DecisionLog) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(DecisionLog other) {
    return timestamp.equals(other.timestamp) && name.equals(other.name) && endpoint.equals(other.endpoint) && status.equals(other.status) && request.equals(other.request) && response.equals(other.response) && decision.equals(other.decision) && error.equals(other.error) && abbreviated.equals(other.abbreviated);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.timestamp, this.name, this.endpoint, this.status, this.request, this.response, this.decision, this.error, this.abbreviated);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<OffsetDateTime> timestamp = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> endpoint = Optional.empty();

    private Optional<Integer> status = Optional.empty();

    private Optional<Map<String, Object>> request = Optional.empty();

    private Optional<Map<String, Object>> response = Optional.empty();

    private Optional<Map<String, Object>> decision = Optional.empty();

    private Optional<String> error = Optional.empty();

    private Optional<Boolean> abbreviated = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(DecisionLog other) {
      timestamp(other.getTimestamp());
      name(other.getName());
      endpoint(other.getEndpoint());
      status(other.getStatus());
      request(other.getRequest());
      response(other.getResponse());
      decision(other.getDecision());
      error(other.getError());
      abbreviated(other.getAbbreviated());
      return this;
    }

    /**
     * <p>When the rule/flow was executed.</p>
     */
    @JsonSetter(
        value = "timestamp",
        nulls = Nulls.SKIP
    )
    public Builder timestamp(Optional<OffsetDateTime> timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    public Builder timestamp(OffsetDateTime timestamp) {
      this.timestamp = Optional.ofNullable(timestamp);
      return this;
    }

    public Builder timestamp(Nullable<OffsetDateTime> timestamp) {
      if (timestamp.isNull()) {
        this.timestamp = null;
      }
      else if (timestamp.isEmpty()) {
        this.timestamp = Optional.empty();
      }
      else {
        this.timestamp = Optional.of(timestamp.get());
      }
      return this;
    }

    /**
     * <p>Name of the rule or flow that was executed.</p>
     */
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    public Builder name(Nullable<String> name) {
      if (name.isNull()) {
        this.name = null;
      }
      else if (name.isEmpty()) {
        this.name = Optional.empty();
      }
      else {
        this.name = Optional.of(name.get());
      }
      return this;
    }

    /**
     * <p>API endpoint that was called.</p>
     */
    @JsonSetter(
        value = "endpoint",
        nulls = Nulls.SKIP
    )
    public Builder endpoint(Optional<String> endpoint) {
      this.endpoint = endpoint;
      return this;
    }

    public Builder endpoint(String endpoint) {
      this.endpoint = Optional.ofNullable(endpoint);
      return this;
    }

    public Builder endpoint(Nullable<String> endpoint) {
      if (endpoint.isNull()) {
        this.endpoint = null;
      }
      else if (endpoint.isEmpty()) {
        this.endpoint = Optional.empty();
      }
      else {
        this.endpoint = Optional.of(endpoint.get());
      }
      return this;
    }

    /**
     * <p>HTTP status code of the response.</p>
     */
    @JsonSetter(
        value = "status",
        nulls = Nulls.SKIP
    )
    public Builder status(Optional<Integer> status) {
      this.status = status;
      return this;
    }

    public Builder status(Integer status) {
      this.status = Optional.ofNullable(status);
      return this;
    }

    public Builder status(Nullable<Integer> status) {
      if (status.isNull()) {
        this.status = null;
      }
      else if (status.isEmpty()) {
        this.status = Optional.empty();
      }
      else {
        this.status = Optional.of(status.get());
      }
      return this;
    }

    /**
     * <p>The request payload sent to the rule/flow.</p>
     */
    @JsonSetter(
        value = "request",
        nulls = Nulls.SKIP
    )
    public Builder request(Optional<Map<String, Object>> request) {
      this.request = request;
      return this;
    }

    public Builder request(Map<String, Object> request) {
      this.request = Optional.ofNullable(request);
      return this;
    }

    public Builder request(Nullable<Map<String, Object>> request) {
      if (request.isNull()) {
        this.request = null;
      }
      else if (request.isEmpty()) {
        this.request = Optional.empty();
      }
      else {
        this.request = Optional.of(request.get());
      }
      return this;
    }

    /**
     * <p>The response payload returned by the rule/flow.</p>
     */
    @JsonSetter(
        value = "response",
        nulls = Nulls.SKIP
    )
    public Builder response(Optional<Map<String, Object>> response) {
      this.response = response;
      return this;
    }

    public Builder response(Map<String, Object> response) {
      this.response = Optional.ofNullable(response);
      return this;
    }

    public Builder response(Nullable<Map<String, Object>> response) {
      if (response.isNull()) {
        this.response = null;
      }
      else if (response.isEmpty()) {
        this.response = Optional.empty();
      }
      else {
        this.response = Optional.of(response.get());
      }
      return this;
    }

    /**
     * <p>Decision details including matched conditions, rows, and evaluation metadata.</p>
     */
    @JsonSetter(
        value = "decision",
        nulls = Nulls.SKIP
    )
    public Builder decision(Optional<Map<String, Object>> decision) {
      this.decision = decision;
      return this;
    }

    public Builder decision(Map<String, Object> decision) {
      this.decision = Optional.ofNullable(decision);
      return this;
    }

    public Builder decision(Nullable<Map<String, Object>> decision) {
      if (decision.isNull()) {
        this.decision = null;
      }
      else if (decision.isEmpty()) {
        this.decision = Optional.empty();
      }
      else {
        this.decision = Optional.of(decision.get());
      }
      return this;
    }

    /**
     * <p>Error message if the execution failed.</p>
     */
    @JsonSetter(
        value = "error",
        nulls = Nulls.SKIP
    )
    public Builder error(Optional<String> error) {
      this.error = error;
      return this;
    }

    public Builder error(String error) {
      this.error = Optional.ofNullable(error);
      return this;
    }

    public Builder error(Nullable<String> error) {
      if (error.isNull()) {
        this.error = null;
      }
      else if (error.isEmpty()) {
        this.error = Optional.empty();
      }
      else {
        this.error = Optional.of(error.get());
      }
      return this;
    }

    /**
     * <p>Whether the request/response data was truncated due to size limits.</p>
     */
    @JsonSetter(
        value = "abbreviated",
        nulls = Nulls.SKIP
    )
    public Builder abbreviated(Optional<Boolean> abbreviated) {
      this.abbreviated = abbreviated;
      return this;
    }

    public Builder abbreviated(Boolean abbreviated) {
      this.abbreviated = Optional.ofNullable(abbreviated);
      return this;
    }

    public DecisionLog build() {
      return new DecisionLog(timestamp, name, endpoint, status, request, response, decision, error, abbreviated, additionalProperties);
    }
  }
}
