/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ExportManifestResponse.Builder.class
)
public final class ExportManifestResponse {
  private final Optional<String> version;

  private final Optional<OffsetDateTime> exportedAt;

  private final Optional<List<Map<String, Object>>> rules;

  private final Optional<List<Map<String, Object>>> flows;

  private final Optional<List<Map<String, Object>>> contexts;

  private final Optional<List<Map<String, Object>>> values;

  private final Map<String, Object> additionalProperties;

  private ExportManifestResponse(Optional<String> version, Optional<OffsetDateTime> exportedAt,
      Optional<List<Map<String, Object>>> rules, Optional<List<Map<String, Object>>> flows,
      Optional<List<Map<String, Object>>> contexts, Optional<List<Map<String, Object>>> values,
      Map<String, Object> additionalProperties) {
    this.version = version;
    this.exportedAt = exportedAt;
    this.rules = rules;
    this.flows = flows;
    this.contexts = contexts;
    this.values = values;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Manifest format version.
   */
  @JsonProperty("version")
  public Optional<String> getVersion() {
    return version;
  }

  @JsonProperty("exported_at")
  public Optional<OffsetDateTime> getExportedAt() {
    return exportedAt;
  }

  @JsonProperty("rules")
  public Optional<List<Map<String, Object>>> getRules() {
    return rules;
  }

  @JsonProperty("flows")
  public Optional<List<Map<String, Object>>> getFlows() {
    return flows;
  }

  @JsonProperty("contexts")
  public Optional<List<Map<String, Object>>> getContexts() {
    return contexts;
  }

  @JsonProperty("values")
  public Optional<List<Map<String, Object>>> getValues() {
    return values;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ExportManifestResponse && equalTo((ExportManifestResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ExportManifestResponse other) {
    return version.equals(other.version) && exportedAt.equals(other.exportedAt) && rules.equals(other.rules) && flows.equals(other.flows) && contexts.equals(other.contexts) && values.equals(other.values);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.version, this.exportedAt, this.rules, this.flows, this.contexts, this.values);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> version = Optional.empty();

    private Optional<OffsetDateTime> exportedAt = Optional.empty();

    private Optional<List<Map<String, Object>>> rules = Optional.empty();

    private Optional<List<Map<String, Object>>> flows = Optional.empty();

    private Optional<List<Map<String, Object>>> contexts = Optional.empty();

    private Optional<List<Map<String, Object>>> values = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ExportManifestResponse other) {
      version(other.getVersion());
      exportedAt(other.getExportedAt());
      rules(other.getRules());
      flows(other.getFlows());
      contexts(other.getContexts());
      values(other.getValues());
      return this;
    }

    /**
     * <p>Manifest format version.</p>
     */
    @JsonSetter(
        value = "version",
        nulls = Nulls.SKIP
    )
    public Builder version(Optional<String> version) {
      this.version = version;
      return this;
    }

    public Builder version(String version) {
      this.version = Optional.ofNullable(version);
      return this;
    }

    @JsonSetter(
        value = "exported_at",
        nulls = Nulls.SKIP
    )
    public Builder exportedAt(Optional<OffsetDateTime> exportedAt) {
      this.exportedAt = exportedAt;
      return this;
    }

    public Builder exportedAt(OffsetDateTime exportedAt) {
      this.exportedAt = Optional.ofNullable(exportedAt);
      return this;
    }

    @JsonSetter(
        value = "rules",
        nulls = Nulls.SKIP
    )
    public Builder rules(Optional<List<Map<String, Object>>> rules) {
      this.rules = rules;
      return this;
    }

    public Builder rules(List<Map<String, Object>> rules) {
      this.rules = Optional.ofNullable(rules);
      return this;
    }

    @JsonSetter(
        value = "flows",
        nulls = Nulls.SKIP
    )
    public Builder flows(Optional<List<Map<String, Object>>> flows) {
      this.flows = flows;
      return this;
    }

    public Builder flows(List<Map<String, Object>> flows) {
      this.flows = Optional.ofNullable(flows);
      return this;
    }

    @JsonSetter(
        value = "contexts",
        nulls = Nulls.SKIP
    )
    public Builder contexts(Optional<List<Map<String, Object>>> contexts) {
      this.contexts = contexts;
      return this;
    }

    public Builder contexts(List<Map<String, Object>> contexts) {
      this.contexts = Optional.ofNullable(contexts);
      return this;
    }

    @JsonSetter(
        value = "values",
        nulls = Nulls.SKIP
    )
    public Builder values(Optional<List<Map<String, Object>>> values) {
      this.values = values;
      return this;
    }

    public Builder values(List<Map<String, Object>> values) {
      this.values = Optional.ofNullable(values);
      return this;
    }

    public ExportManifestResponse build() {
      return new ExportManifestResponse(version, exportedAt, rules, flows, contexts, values, additionalProperties);
    }
  }
}
