/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ImportManifestResponseSkipped.Builder.class
)
public final class ImportManifestResponseSkipped {
  private final Optional<Integer> rules;

  private final Optional<Integer> flows;

  private final Optional<Integer> contexts;

  private final Optional<Integer> values;

  private final Map<String, Object> additionalProperties;

  private ImportManifestResponseSkipped(Optional<Integer> rules, Optional<Integer> flows,
      Optional<Integer> contexts, Optional<Integer> values,
      Map<String, Object> additionalProperties) {
    this.rules = rules;
    this.flows = flows;
    this.contexts = contexts;
    this.values = values;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("rules")
  public Optional<Integer> getRules() {
    return rules;
  }

  @JsonProperty("flows")
  public Optional<Integer> getFlows() {
    return flows;
  }

  @JsonProperty("contexts")
  public Optional<Integer> getContexts() {
    return contexts;
  }

  @JsonProperty("values")
  public Optional<Integer> getValues() {
    return values;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ImportManifestResponseSkipped && equalTo((ImportManifestResponseSkipped) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ImportManifestResponseSkipped other) {
    return rules.equals(other.rules) && flows.equals(other.flows) && contexts.equals(other.contexts) && values.equals(other.values);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.rules, this.flows, this.contexts, this.values);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<Integer> rules = Optional.empty();

    private Optional<Integer> flows = Optional.empty();

    private Optional<Integer> contexts = Optional.empty();

    private Optional<Integer> values = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ImportManifestResponseSkipped other) {
      rules(other.getRules());
      flows(other.getFlows());
      contexts(other.getContexts());
      values(other.getValues());
      return this;
    }

    @JsonSetter(
        value = "rules",
        nulls = Nulls.SKIP
    )
    public Builder rules(Optional<Integer> rules) {
      this.rules = rules;
      return this;
    }

    public Builder rules(Integer rules) {
      this.rules = Optional.ofNullable(rules);
      return this;
    }

    @JsonSetter(
        value = "flows",
        nulls = Nulls.SKIP
    )
    public Builder flows(Optional<Integer> flows) {
      this.flows = flows;
      return this;
    }

    public Builder flows(Integer flows) {
      this.flows = Optional.ofNullable(flows);
      return this;
    }

    @JsonSetter(
        value = "contexts",
        nulls = Nulls.SKIP
    )
    public Builder contexts(Optional<Integer> contexts) {
      this.contexts = contexts;
      return this;
    }

    public Builder contexts(Integer contexts) {
      this.contexts = Optional.ofNullable(contexts);
      return this;
    }

    @JsonSetter(
        value = "values",
        nulls = Nulls.SKIP
    )
    public Builder values(Optional<Integer> values) {
      this.values = values;
      return this;
    }

    public Builder values(Integer values) {
      this.values = Optional.ofNullable(values);
      return this;
    }

    public ImportManifestResponseSkipped build() {
      return new ImportManifestResponseSkipped(rules, flows, contexts, values, additionalProperties);
    }
  }
}
