/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = RuleDetail.Builder.class
)
public final class RuleDetail implements IRuleBase {
  private final Optional<String> id;

  private final Optional<String> name;

  private final Optional<String> description;

  private final Optional<String> slug;

  private final Optional<OffsetDateTime> createdAt;

  private final Optional<OffsetDateTime> updatedAt;

  private final Optional<Folder> folder;

  private final Optional<RuleDetailContext> context;

  private final Optional<List<SchemaField>> requestSchema;

  private final Optional<List<SchemaField>> responseSchema;

  private final Map<String, Object> additionalProperties;

  private RuleDetail(Optional<String> id, Optional<String> name, Optional<String> description,
      Optional<String> slug, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> updatedAt,
      Optional<Folder> folder, Optional<RuleDetailContext> context,
      Optional<List<SchemaField>> requestSchema, Optional<List<SchemaField>> responseSchema,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.slug = slug;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.folder = folder;
    this.context = context;
    this.requestSchema = requestSchema;
    this.responseSchema = responseSchema;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The unique identifier for the rule.
   */
  @JsonProperty("id")
  @java.lang.Override
  public Optional<String> getId() {
    return id;
  }

  /**
   * @return The name of the rule.
   */
  @JsonProperty("name")
  @java.lang.Override
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return The description of the rule.
   */
  @JsonProperty("description")
  @java.lang.Override
  public Optional<String> getDescription() {
    return description;
  }

  /**
   * @return The unique slug for the rule used in API requests.
   */
  @JsonProperty("slug")
  @java.lang.Override
  public Optional<String> getSlug() {
    return slug;
  }

  /**
   * @return The date this rule was created.
   */
  @JsonProperty("created_at")
  public Optional<OffsetDateTime> getCreatedAt() {
    return createdAt;
  }

  /**
   * @return The date this rule was last updated.
   */
  @JsonProperty("updated_at")
  public Optional<OffsetDateTime> getUpdatedAt() {
    return updatedAt;
  }

  @JsonProperty("folder")
  public Optional<Folder> getFolder() {
    return folder;
  }

  /**
   * @return The context this rule is bound to (if any). Rules bound to a context have their inputs/outputs mapped to context fields.
   */
  @JsonIgnore
  public Optional<RuleDetailContext> getContext() {
    if (context == null) {
      return Optional.empty();
    }
    return context;
  }

  /**
   * @return The published request schema for the rule.
   */
  @JsonProperty("request_schema")
  public Optional<List<SchemaField>> getRequestSchema() {
    return requestSchema;
  }

  /**
   * @return The published response schema for the rule.
   */
  @JsonProperty("response_schema")
  public Optional<List<SchemaField>> getResponseSchema() {
    return responseSchema;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("context")
  private Optional<RuleDetailContext> _getContext() {
    return context;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof RuleDetail && equalTo((RuleDetail) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(RuleDetail other) {
    return id.equals(other.id) && name.equals(other.name) && description.equals(other.description) && slug.equals(other.slug) && createdAt.equals(other.createdAt) && updatedAt.equals(other.updatedAt) && folder.equals(other.folder) && context.equals(other.context) && requestSchema.equals(other.requestSchema) && responseSchema.equals(other.responseSchema);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.description, this.slug, this.createdAt, this.updatedAt, this.folder, this.context, this.requestSchema, this.responseSchema);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> id = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> description = Optional.empty();

    private Optional<String> slug = Optional.empty();

    private Optional<OffsetDateTime> createdAt = Optional.empty();

    private Optional<OffsetDateTime> updatedAt = Optional.empty();

    private Optional<Folder> folder = Optional.empty();

    private Optional<RuleDetailContext> context = Optional.empty();

    private Optional<List<SchemaField>> requestSchema = Optional.empty();

    private Optional<List<SchemaField>> responseSchema = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(RuleDetail other) {
      id(other.getId());
      name(other.getName());
      description(other.getDescription());
      slug(other.getSlug());
      createdAt(other.getCreatedAt());
      updatedAt(other.getUpdatedAt());
      folder(other.getFolder());
      context(other.getContext());
      requestSchema(other.getRequestSchema());
      responseSchema(other.getResponseSchema());
      return this;
    }

    /**
     * <p>The unique identifier for the rule.</p>
     */
    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public Builder id(Optional<String> id) {
      this.id = id;
      return this;
    }

    public Builder id(String id) {
      this.id = Optional.ofNullable(id);
      return this;
    }

    /**
     * <p>The name of the rule.</p>
     */
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    /**
     * <p>The description of the rule.</p>
     */
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public Builder description(Optional<String> description) {
      this.description = description;
      return this;
    }

    public Builder description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    /**
     * <p>The unique slug for the rule used in API requests.</p>
     */
    @JsonSetter(
        value = "slug",
        nulls = Nulls.SKIP
    )
    public Builder slug(Optional<String> slug) {
      this.slug = slug;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = Optional.ofNullable(slug);
      return this;
    }

    /**
     * <p>The date this rule was created.</p>
     */
    @JsonSetter(
        value = "created_at",
        nulls = Nulls.SKIP
    )
    public Builder createdAt(Optional<OffsetDateTime> createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = Optional.ofNullable(createdAt);
      return this;
    }

    /**
     * <p>The date this rule was last updated.</p>
     */
    @JsonSetter(
        value = "updated_at",
        nulls = Nulls.SKIP
    )
    public Builder updatedAt(Optional<OffsetDateTime> updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    public Builder updatedAt(OffsetDateTime updatedAt) {
      this.updatedAt = Optional.ofNullable(updatedAt);
      return this;
    }

    @JsonSetter(
        value = "folder",
        nulls = Nulls.SKIP
    )
    public Builder folder(Optional<Folder> folder) {
      this.folder = folder;
      return this;
    }

    public Builder folder(Folder folder) {
      this.folder = Optional.ofNullable(folder);
      return this;
    }

    /**
     * <p>The context this rule is bound to (if any). Rules bound to a context have their inputs/outputs mapped to context fields.</p>
     */
    @JsonSetter(
        value = "context",
        nulls = Nulls.SKIP
    )
    public Builder context(Optional<RuleDetailContext> context) {
      this.context = context;
      return this;
    }

    public Builder context(RuleDetailContext context) {
      this.context = Optional.ofNullable(context);
      return this;
    }

    public Builder context(Nullable<RuleDetailContext> context) {
      if (context.isNull()) {
        this.context = null;
      }
      else if (context.isEmpty()) {
        this.context = Optional.empty();
      }
      else {
        this.context = Optional.of(context.get());
      }
      return this;
    }

    /**
     * <p>The published request schema for the rule.</p>
     */
    @JsonSetter(
        value = "request_schema",
        nulls = Nulls.SKIP
    )
    public Builder requestSchema(Optional<List<SchemaField>> requestSchema) {
      this.requestSchema = requestSchema;
      return this;
    }

    public Builder requestSchema(List<SchemaField> requestSchema) {
      this.requestSchema = Optional.ofNullable(requestSchema);
      return this;
    }

    /**
     * <p>The published response schema for the rule.</p>
     */
    @JsonSetter(
        value = "response_schema",
        nulls = Nulls.SKIP
    )
    public Builder responseSchema(Optional<List<SchemaField>> responseSchema) {
      this.responseSchema = responseSchema;
      return this;
    }

    public Builder responseSchema(List<SchemaField> responseSchema) {
      this.responseSchema = Optional.ofNullable(responseSchema);
      return this;
    }

    public RuleDetail build() {
      return new RuleDetail(id, name, description, slug, createdAt, updatedAt, folder, context, requestSchema, responseSchema, additionalProperties);
    }
  }
}
