/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Object;
import java.lang.String;

public final class SchemaFieldType {
  public static final SchemaFieldType NUMBER = new SchemaFieldType(Value.NUMBER, "number");

  public static final SchemaFieldType STRING = new SchemaFieldType(Value.STRING, "string");

  public static final SchemaFieldType BOOLEAN = new SchemaFieldType(Value.BOOLEAN, "boolean");

  public static final SchemaFieldType OBJECT = new SchemaFieldType(Value.OBJECT, "object");

  public static final SchemaFieldType ARRAY = new SchemaFieldType(Value.ARRAY, "array");

  private final Value value;

  private final String string;

  SchemaFieldType(Value value, String string) {
    this.value = value;
    this.string = string;
  }

  public Value getEnumValue() {
    return value;
  }

  @java.lang.Override
  @JsonValue
  public String toString() {
    return this.string;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    return (this == other) 
      || (other instanceof SchemaFieldType && this.string.equals(((SchemaFieldType) other).string));
  }

  @java.lang.Override
  public int hashCode() {
    return this.string.hashCode();
  }

  public <T> T visit(Visitor<T> visitor) {
    switch (value) {
      case NUMBER:
        return visitor.visitNumber();
      case STRING:
        return visitor.visitString();
      case BOOLEAN:
        return visitor.visitBoolean();
      case OBJECT:
        return visitor.visitObject();
      case ARRAY:
        return visitor.visitArray();
      case UNKNOWN:
      default:
        return visitor.visitUnknown(string);
    }
  }

  @JsonCreator(
      mode = JsonCreator.Mode.DELEGATING
  )
  public static SchemaFieldType valueOf(String value) {
    switch (value) {
      case "number":
        return NUMBER;
      case "string":
        return STRING;
      case "boolean":
        return BOOLEAN;
      case "object":
        return OBJECT;
      case "array":
        return ARRAY;
      default:
        return new SchemaFieldType(Value.UNKNOWN, value);
    }
  }

  public enum Value {
    STRING,

    NUMBER,

    BOOLEAN,

    OBJECT,

    ARRAY,

    UNKNOWN
  }

  public interface Visitor<T> {
    T visitString();

    T visitNumber();

    T visitBoolean();

    T visitObject();

    T visitArray();

    T visitUnknown(String unknownType);
  }
}
