/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = SolveContextFlowResponse.Builder.class
)
public final class SolveContextFlowResponse {
  private final Optional<SolveContextFlowResponseStatus> status;

  private final Optional<String> context;

  private final Optional<String> flow;

  private final Optional<Map<String, Object>> result;

  private final Optional<Map<String, Object>> usage;

  private final Map<String, Object> additionalProperties;

  private SolveContextFlowResponse(Optional<SolveContextFlowResponseStatus> status,
      Optional<String> context, Optional<String> flow, Optional<Map<String, Object>> result,
      Optional<Map<String, Object>> usage, Map<String, Object> additionalProperties) {
    this.status = status;
    this.context = context;
    this.flow = flow;
    this.result = result;
    this.usage = usage;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Whether the flow executed successfully.
   */
  @JsonProperty("status")
  public Optional<SolveContextFlowResponseStatus> getStatus() {
    return status;
  }

  /**
   * @return Combined identifier in format 'contextSlug:instanceId'.
   */
  @JsonProperty("context")
  public Optional<String> getContext() {
    return context;
  }

  /**
   * @return The slug of the flow that was executed.
   */
  @JsonProperty("flow")
  public Optional<String> getFlow() {
    return flow;
  }

  /**
   * @return The flow execution output.
   */
  @JsonProperty("result")
  public Optional<Map<String, Object>> getResult() {
    return result;
  }

  /**
   * @return Resource usage information for the flow execution.
   */
  @JsonProperty("usage")
  public Optional<Map<String, Object>> getUsage() {
    return usage;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof SolveContextFlowResponse && equalTo((SolveContextFlowResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(SolveContextFlowResponse other) {
    return status.equals(other.status) && context.equals(other.context) && flow.equals(other.flow) && result.equals(other.result) && usage.equals(other.usage);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.status, this.context, this.flow, this.result, this.usage);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<SolveContextFlowResponseStatus> status = Optional.empty();

    private Optional<String> context = Optional.empty();

    private Optional<String> flow = Optional.empty();

    private Optional<Map<String, Object>> result = Optional.empty();

    private Optional<Map<String, Object>> usage = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(SolveContextFlowResponse other) {
      status(other.getStatus());
      context(other.getContext());
      flow(other.getFlow());
      result(other.getResult());
      usage(other.getUsage());
      return this;
    }

    /**
     * <p>Whether the flow executed successfully.</p>
     */
    @JsonSetter(
        value = "status",
        nulls = Nulls.SKIP
    )
    public Builder status(Optional<SolveContextFlowResponseStatus> status) {
      this.status = status;
      return this;
    }

    public Builder status(SolveContextFlowResponseStatus status) {
      this.status = Optional.ofNullable(status);
      return this;
    }

    /**
     * <p>Combined identifier in format 'contextSlug:instanceId'.</p>
     */
    @JsonSetter(
        value = "context",
        nulls = Nulls.SKIP
    )
    public Builder context(Optional<String> context) {
      this.context = context;
      return this;
    }

    public Builder context(String context) {
      this.context = Optional.ofNullable(context);
      return this;
    }

    /**
     * <p>The slug of the flow that was executed.</p>
     */
    @JsonSetter(
        value = "flow",
        nulls = Nulls.SKIP
    )
    public Builder flow(Optional<String> flow) {
      this.flow = flow;
      return this;
    }

    public Builder flow(String flow) {
      this.flow = Optional.ofNullable(flow);
      return this;
    }

    /**
     * <p>The flow execution output.</p>
     */
    @JsonSetter(
        value = "result",
        nulls = Nulls.SKIP
    )
    public Builder result(Optional<Map<String, Object>> result) {
      this.result = result;
      return this;
    }

    public Builder result(Map<String, Object> result) {
      this.result = Optional.ofNullable(result);
      return this;
    }

    /**
     * <p>Resource usage information for the flow execution.</p>
     */
    @JsonSetter(
        value = "usage",
        nulls = Nulls.SKIP
    )
    public Builder usage(Optional<Map<String, Object>> usage) {
      this.usage = usage;
      return this;
    }

    public Builder usage(Map<String, Object> usage) {
      this.usage = Optional.ofNullable(usage);
      return this;
    }

    public SolveContextFlowResponse build() {
      return new SolveContextFlowResponse(status, context, flow, result, usage, additionalProperties);
    }
  }
}
