/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = SolveContextRuleResponse.Builder.class
)
public final class SolveContextRuleResponse {
  private final Optional<SolveContextRuleResponseStatus> status;

  private final Optional<String> context;

  private final Optional<String> rule;

  private final Optional<Map<String, Object>> result;

  private final Optional<List<String>> writtenToContext;

  private final Optional<List<CascadeResult>> cascaded;

  private final Map<String, Object> additionalProperties;

  private SolveContextRuleResponse(Optional<SolveContextRuleResponseStatus> status,
      Optional<String> context, Optional<String> rule, Optional<Map<String, Object>> result,
      Optional<List<String>> writtenToContext, Optional<List<CascadeResult>> cascaded,
      Map<String, Object> additionalProperties) {
    this.status = status;
    this.context = context;
    this.rule = rule;
    this.result = result;
    this.writtenToContext = writtenToContext;
    this.cascaded = cascaded;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Whether the rule executed successfully.
   */
  @JsonProperty("status")
  public Optional<SolveContextRuleResponseStatus> getStatus() {
    return status;
  }

  /**
   * @return Combined identifier in format 'contextSlug:instanceId'.
   */
  @JsonProperty("context")
  public Optional<String> getContext() {
    return context;
  }

  /**
   * @return The slug of the rule that was executed.
   */
  @JsonProperty("rule")
  public Optional<String> getRule() {
    return rule;
  }

  /**
   * @return The rule evaluation result (output values).
   */
  @JsonProperty("result")
  public Optional<Map<String, Object>> getResult() {
    return result;
  }

  /**
   * @return List of field keys that were written back to the context instance.
   */
  @JsonProperty("written_to_context")
  public Optional<List<String>> getWrittenToContext() {
    return writtenToContext;
  }

  /**
   * @return Results from any cascaded evaluations triggered by the rule outputs.
   */
  @JsonProperty("cascaded")
  public Optional<List<CascadeResult>> getCascaded() {
    return cascaded;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof SolveContextRuleResponse && equalTo((SolveContextRuleResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(SolveContextRuleResponse other) {
    return status.equals(other.status) && context.equals(other.context) && rule.equals(other.rule) && result.equals(other.result) && writtenToContext.equals(other.writtenToContext) && cascaded.equals(other.cascaded);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.status, this.context, this.rule, this.result, this.writtenToContext, this.cascaded);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<SolveContextRuleResponseStatus> status = Optional.empty();

    private Optional<String> context = Optional.empty();

    private Optional<String> rule = Optional.empty();

    private Optional<Map<String, Object>> result = Optional.empty();

    private Optional<List<String>> writtenToContext = Optional.empty();

    private Optional<List<CascadeResult>> cascaded = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(SolveContextRuleResponse other) {
      status(other.getStatus());
      context(other.getContext());
      rule(other.getRule());
      result(other.getResult());
      writtenToContext(other.getWrittenToContext());
      cascaded(other.getCascaded());
      return this;
    }

    /**
     * <p>Whether the rule executed successfully.</p>
     */
    @JsonSetter(
        value = "status",
        nulls = Nulls.SKIP
    )
    public Builder status(Optional<SolveContextRuleResponseStatus> status) {
      this.status = status;
      return this;
    }

    public Builder status(SolveContextRuleResponseStatus status) {
      this.status = Optional.ofNullable(status);
      return this;
    }

    /**
     * <p>Combined identifier in format 'contextSlug:instanceId'.</p>
     */
    @JsonSetter(
        value = "context",
        nulls = Nulls.SKIP
    )
    public Builder context(Optional<String> context) {
      this.context = context;
      return this;
    }

    public Builder context(String context) {
      this.context = Optional.ofNullable(context);
      return this;
    }

    /**
     * <p>The slug of the rule that was executed.</p>
     */
    @JsonSetter(
        value = "rule",
        nulls = Nulls.SKIP
    )
    public Builder rule(Optional<String> rule) {
      this.rule = rule;
      return this;
    }

    public Builder rule(String rule) {
      this.rule = Optional.ofNullable(rule);
      return this;
    }

    /**
     * <p>The rule evaluation result (output values).</p>
     */
    @JsonSetter(
        value = "result",
        nulls = Nulls.SKIP
    )
    public Builder result(Optional<Map<String, Object>> result) {
      this.result = result;
      return this;
    }

    public Builder result(Map<String, Object> result) {
      this.result = Optional.ofNullable(result);
      return this;
    }

    /**
     * <p>List of field keys that were written back to the context instance.</p>
     */
    @JsonSetter(
        value = "written_to_context",
        nulls = Nulls.SKIP
    )
    public Builder writtenToContext(Optional<List<String>> writtenToContext) {
      this.writtenToContext = writtenToContext;
      return this;
    }

    public Builder writtenToContext(List<String> writtenToContext) {
      this.writtenToContext = Optional.ofNullable(writtenToContext);
      return this;
    }

    /**
     * <p>Results from any cascaded evaluations triggered by the rule outputs.</p>
     */
    @JsonSetter(
        value = "cascaded",
        nulls = Nulls.SKIP
    )
    public Builder cascaded(Optional<List<CascadeResult>> cascaded) {
      this.cascaded = cascaded;
      return this;
    }

    public Builder cascaded(List<CascadeResult> cascaded) {
      this.cascaded = Optional.ofNullable(cascaded);
      return this;
    }

    public SolveContextRuleResponse build() {
      return new SolveContextRuleResponse(status, context, rule, result, writtenToContext, cascaded, additionalProperties);
    }
  }
}
