/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = SubmitContextDataResponse.Builder.class
)
public final class SubmitContextDataResponse {
  private final Optional<String> context;

  private final Optional<Map<String, Object>> state;

  private final Optional<SubmitContextDataResponseStatus> status;

  private final Optional<List<String>> have;

  private final Optional<List<String>> need;

  private final Optional<Boolean> isNew;

  private final Optional<OffsetDateTime> expiresAt;

  private final Optional<List<CascadeResult>> cascaded;

  private final Map<String, Object> additionalProperties;

  private SubmitContextDataResponse(Optional<String> context, Optional<Map<String, Object>> state,
      Optional<SubmitContextDataResponseStatus> status, Optional<List<String>> have,
      Optional<List<String>> need, Optional<Boolean> isNew, Optional<OffsetDateTime> expiresAt,
      Optional<List<CascadeResult>> cascaded, Map<String, Object> additionalProperties) {
    this.context = context;
    this.state = state;
    this.status = status;
    this.have = have;
    this.need = need;
    this.isNew = isNew;
    this.expiresAt = expiresAt;
    this.cascaded = cascaded;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Combined identifier in format 'contextSlug:instanceId'.
   */
  @JsonProperty("context")
  public Optional<String> getContext() {
    return context;
  }

  /**
   * @return The merged state after submitting data and any auto-executed rules/flows.
   */
  @JsonProperty("state")
  public Optional<Map<String, Object>> getState() {
    return state;
  }

  /**
   * @return Whether all required fields are present ('complete') or some are missing ('pending').
   */
  @JsonProperty("status")
  public Optional<SubmitContextDataResponseStatus> getStatus() {
    return status;
  }

  /**
   * @return List of field keys that are currently populated.
   */
  @JsonProperty("have")
  public Optional<List<String>> getHave() {
    return have;
  }

  /**
   * @return List of required field keys that are still missing.
   */
  @JsonProperty("need")
  public Optional<List<String>> getNeed() {
    return need;
  }

  /**
   * @return Whether this submission created a new instance (true) or updated an existing one (false).
   */
  @JsonProperty("is_new")
  public Optional<Boolean> getIsNew() {
    return isNew;
  }

  /**
   * @return When the instance will expire based on context TTL.
   */
  @JsonIgnore
  public Optional<OffsetDateTime> getExpiresAt() {
    if (expiresAt == null) {
      return Optional.empty();
    }
    return expiresAt;
  }

  /**
   * @return Results from auto-executed rules/flows and pending evaluation cascades.
   */
  @JsonProperty("cascaded")
  public Optional<List<CascadeResult>> getCascaded() {
    return cascaded;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("expires_at")
  private Optional<OffsetDateTime> _getExpiresAt() {
    return expiresAt;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof SubmitContextDataResponse && equalTo((SubmitContextDataResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(SubmitContextDataResponse other) {
    return context.equals(other.context) && state.equals(other.state) && status.equals(other.status) && have.equals(other.have) && need.equals(other.need) && isNew.equals(other.isNew) && expiresAt.equals(other.expiresAt) && cascaded.equals(other.cascaded);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.context, this.state, this.status, this.have, this.need, this.isNew, this.expiresAt, this.cascaded);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> context = Optional.empty();

    private Optional<Map<String, Object>> state = Optional.empty();

    private Optional<SubmitContextDataResponseStatus> status = Optional.empty();

    private Optional<List<String>> have = Optional.empty();

    private Optional<List<String>> need = Optional.empty();

    private Optional<Boolean> isNew = Optional.empty();

    private Optional<OffsetDateTime> expiresAt = Optional.empty();

    private Optional<List<CascadeResult>> cascaded = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(SubmitContextDataResponse other) {
      context(other.getContext());
      state(other.getState());
      status(other.getStatus());
      have(other.getHave());
      need(other.getNeed());
      isNew(other.getIsNew());
      expiresAt(other.getExpiresAt());
      cascaded(other.getCascaded());
      return this;
    }

    /**
     * <p>Combined identifier in format 'contextSlug:instanceId'.</p>
     */
    @JsonSetter(
        value = "context",
        nulls = Nulls.SKIP
    )
    public Builder context(Optional<String> context) {
      this.context = context;
      return this;
    }

    public Builder context(String context) {
      this.context = Optional.ofNullable(context);
      return this;
    }

    /**
     * <p>The merged state after submitting data and any auto-executed rules/flows.</p>
     */
    @JsonSetter(
        value = "state",
        nulls = Nulls.SKIP
    )
    public Builder state(Optional<Map<String, Object>> state) {
      this.state = state;
      return this;
    }

    public Builder state(Map<String, Object> state) {
      this.state = Optional.ofNullable(state);
      return this;
    }

    /**
     * <p>Whether all required fields are present ('complete') or some are missing ('pending').</p>
     */
    @JsonSetter(
        value = "status",
        nulls = Nulls.SKIP
    )
    public Builder status(Optional<SubmitContextDataResponseStatus> status) {
      this.status = status;
      return this;
    }

    public Builder status(SubmitContextDataResponseStatus status) {
      this.status = Optional.ofNullable(status);
      return this;
    }

    /**
     * <p>List of field keys that are currently populated.</p>
     */
    @JsonSetter(
        value = "have",
        nulls = Nulls.SKIP
    )
    public Builder have(Optional<List<String>> have) {
      this.have = have;
      return this;
    }

    public Builder have(List<String> have) {
      this.have = Optional.ofNullable(have);
      return this;
    }

    /**
     * <p>List of required field keys that are still missing.</p>
     */
    @JsonSetter(
        value = "need",
        nulls = Nulls.SKIP
    )
    public Builder need(Optional<List<String>> need) {
      this.need = need;
      return this;
    }

    public Builder need(List<String> need) {
      this.need = Optional.ofNullable(need);
      return this;
    }

    /**
     * <p>Whether this submission created a new instance (true) or updated an existing one (false).</p>
     */
    @JsonSetter(
        value = "is_new",
        nulls = Nulls.SKIP
    )
    public Builder isNew(Optional<Boolean> isNew) {
      this.isNew = isNew;
      return this;
    }

    public Builder isNew(Boolean isNew) {
      this.isNew = Optional.ofNullable(isNew);
      return this;
    }

    /**
     * <p>When the instance will expire based on context TTL.</p>
     */
    @JsonSetter(
        value = "expires_at",
        nulls = Nulls.SKIP
    )
    public Builder expiresAt(Optional<OffsetDateTime> expiresAt) {
      this.expiresAt = expiresAt;
      return this;
    }

    public Builder expiresAt(OffsetDateTime expiresAt) {
      this.expiresAt = Optional.ofNullable(expiresAt);
      return this;
    }

    public Builder expiresAt(Nullable<OffsetDateTime> expiresAt) {
      if (expiresAt.isNull()) {
        this.expiresAt = null;
      }
      else if (expiresAt.isEmpty()) {
        this.expiresAt = Optional.empty();
      }
      else {
        this.expiresAt = Optional.of(expiresAt.get());
      }
      return this;
    }

    /**
     * <p>Results from auto-executed rules/flows and pending evaluation cascades.</p>
     */
    @JsonSetter(
        value = "cascaded",
        nulls = Nulls.SKIP
    )
    public Builder cascaded(Optional<List<CascadeResult>> cascaded) {
      this.cascaded = cascaded;
      return this;
    }

    public Builder cascaded(List<CascadeResult> cascaded) {
      this.cascaded = Optional.ofNullable(cascaded);
      return this;
    }

    public SubmitContextDataResponse build() {
      return new SubmitContextDataResponse(context, state, status, have, need, isNew, expiresAt, cascaded, additionalProperties);
    }
  }
}
