/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.resources.assets.types.ExportManifestRequestRootType;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ExportManifestRequest.Builder.class
)
public final class ExportManifestRequest {
  private final ExportManifestRequestRootType rootType;

  private final List<String> rootIds;

  private final Optional<Boolean> includeDownstream;

  private final Optional<String> manifestName;

  private final Optional<String> manifestDescription;

  private final Optional<Boolean> previewOnly;

  private final Map<String, Object> additionalProperties;

  private ExportManifestRequest(ExportManifestRequestRootType rootType, List<String> rootIds,
      Optional<Boolean> includeDownstream, Optional<String> manifestName,
      Optional<String> manifestDescription, Optional<Boolean> previewOnly,
      Map<String, Object> additionalProperties) {
    this.rootType = rootType;
    this.rootIds = rootIds;
    this.includeDownstream = includeDownstream;
    this.manifestName = manifestName;
    this.manifestDescription = manifestDescription;
    this.previewOnly = previewOnly;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The type of root asset to export. All dependencies will be included.
   */
  @JsonProperty("root_type")
  public ExportManifestRequestRootType getRootType() {
    return rootType;
  }

  /**
   * @return Array of IDs for the root assets to export. Dependencies are automatically resolved.
   */
  @JsonProperty("root_ids")
  public List<String> getRootIds() {
    return rootIds;
  }

  /**
   * @return For context exports, whether to include rules and flows bound to the context.
   */
  @JsonProperty("include_downstream")
  public Optional<Boolean> getIncludeDownstream() {
    return includeDownstream;
  }

  /**
   * @return Optional name for the exported manifest.
   */
  @JsonProperty("manifest_name")
  public Optional<String> getManifestName() {
    return manifestName;
  }

  /**
   * @return Optional description for the exported manifest.
   */
  @JsonProperty("manifest_description")
  public Optional<String> getManifestDescription() {
    return manifestDescription;
  }

  /**
   * @return If true, returns a preview of what would be exported without the full data.
   */
  @JsonProperty("preview_only")
  public Optional<Boolean> getPreviewOnly() {
    return previewOnly;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ExportManifestRequest && equalTo((ExportManifestRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ExportManifestRequest other) {
    return rootType.equals(other.rootType) && rootIds.equals(other.rootIds) && includeDownstream.equals(other.includeDownstream) && manifestName.equals(other.manifestName) && manifestDescription.equals(other.manifestDescription) && previewOnly.equals(other.previewOnly);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.rootType, this.rootIds, this.includeDownstream, this.manifestName, this.manifestDescription, this.previewOnly);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static RootTypeStage builder() {
    return new Builder();
  }

  public interface RootTypeStage {
    /**
     * <p>The type of root asset to export. All dependencies will be included.</p>
     */
    _FinalStage rootType(@NotNull ExportManifestRequestRootType rootType);

    Builder from(ExportManifestRequest other);
  }

  public interface _FinalStage {
    ExportManifestRequest build();

    /**
     * <p>Array of IDs for the root assets to export. Dependencies are automatically resolved.</p>
     */
    _FinalStage rootIds(List<String> rootIds);

    _FinalStage addRootIds(String rootIds);

    _FinalStage addAllRootIds(List<String> rootIds);

    /**
     * <p>For context exports, whether to include rules and flows bound to the context.</p>
     */
    _FinalStage includeDownstream(Optional<Boolean> includeDownstream);

    _FinalStage includeDownstream(Boolean includeDownstream);

    /**
     * <p>Optional name for the exported manifest.</p>
     */
    _FinalStage manifestName(Optional<String> manifestName);

    _FinalStage manifestName(String manifestName);

    /**
     * <p>Optional description for the exported manifest.</p>
     */
    _FinalStage manifestDescription(Optional<String> manifestDescription);

    _FinalStage manifestDescription(String manifestDescription);

    /**
     * <p>If true, returns a preview of what would be exported without the full data.</p>
     */
    _FinalStage previewOnly(Optional<Boolean> previewOnly);

    _FinalStage previewOnly(Boolean previewOnly);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements RootTypeStage, _FinalStage {
    private ExportManifestRequestRootType rootType;

    private Optional<Boolean> previewOnly = Optional.empty();

    private Optional<String> manifestDescription = Optional.empty();

    private Optional<String> manifestName = Optional.empty();

    private Optional<Boolean> includeDownstream = Optional.empty();

    private List<String> rootIds = new ArrayList<>();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(ExportManifestRequest other) {
      rootType(other.getRootType());
      rootIds(other.getRootIds());
      includeDownstream(other.getIncludeDownstream());
      manifestName(other.getManifestName());
      manifestDescription(other.getManifestDescription());
      previewOnly(other.getPreviewOnly());
      return this;
    }

    /**
     * <p>The type of root asset to export. All dependencies will be included.</p>
     * <p>The type of root asset to export. All dependencies will be included.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("root_type")
    public _FinalStage rootType(@NotNull ExportManifestRequestRootType rootType) {
      this.rootType = Objects.requireNonNull(rootType, "rootType must not be null");
      return this;
    }

    /**
     * <p>If true, returns a preview of what would be exported without the full data.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage previewOnly(Boolean previewOnly) {
      this.previewOnly = Optional.ofNullable(previewOnly);
      return this;
    }

    /**
     * <p>If true, returns a preview of what would be exported without the full data.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "preview_only",
        nulls = Nulls.SKIP
    )
    public _FinalStage previewOnly(Optional<Boolean> previewOnly) {
      this.previewOnly = previewOnly;
      return this;
    }

    /**
     * <p>Optional description for the exported manifest.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage manifestDescription(String manifestDescription) {
      this.manifestDescription = Optional.ofNullable(manifestDescription);
      return this;
    }

    /**
     * <p>Optional description for the exported manifest.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "manifest_description",
        nulls = Nulls.SKIP
    )
    public _FinalStage manifestDescription(Optional<String> manifestDescription) {
      this.manifestDescription = manifestDescription;
      return this;
    }

    /**
     * <p>Optional name for the exported manifest.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage manifestName(String manifestName) {
      this.manifestName = Optional.ofNullable(manifestName);
      return this;
    }

    /**
     * <p>Optional name for the exported manifest.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "manifest_name",
        nulls = Nulls.SKIP
    )
    public _FinalStage manifestName(Optional<String> manifestName) {
      this.manifestName = manifestName;
      return this;
    }

    /**
     * <p>For context exports, whether to include rules and flows bound to the context.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage includeDownstream(Boolean includeDownstream) {
      this.includeDownstream = Optional.ofNullable(includeDownstream);
      return this;
    }

    /**
     * <p>For context exports, whether to include rules and flows bound to the context.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "include_downstream",
        nulls = Nulls.SKIP
    )
    public _FinalStage includeDownstream(Optional<Boolean> includeDownstream) {
      this.includeDownstream = includeDownstream;
      return this;
    }

    /**
     * <p>Array of IDs for the root assets to export. Dependencies are automatically resolved.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage addAllRootIds(List<String> rootIds) {
      if (rootIds != null) {
        this.rootIds.addAll(rootIds);
      }
      return this;
    }

    /**
     * <p>Array of IDs for the root assets to export. Dependencies are automatically resolved.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage addRootIds(String rootIds) {
      this.rootIds.add(rootIds);
      return this;
    }

    /**
     * <p>Array of IDs for the root assets to export. Dependencies are automatically resolved.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "root_ids",
        nulls = Nulls.SKIP
    )
    public _FinalStage rootIds(List<String> rootIds) {
      this.rootIds.clear();
      if (rootIds != null) {
        this.rootIds.addAll(rootIds);
      }
      return this;
    }

    @java.lang.Override
    public ExportManifestRequest build() {
      return new ExportManifestRequest(rootType, rootIds, includeDownstream, manifestName, manifestDescription, previewOnly, additionalProperties);
    }
  }
}
