/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.resources.assets.types.ImportManifestRequestConflictStrategy;
import com.rulebricks.resources.assets.types.ImportManifestRequestLegacyRuleMappingValue;
import com.rulebricks.resources.assets.types.ImportManifestRequestManifest;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ImportManifestRequest.Builder.class
)
public final class ImportManifestRequest {
  private final ImportManifestRequestManifest manifest;

  private final Optional<ImportManifestRequestConflictStrategy> conflictStrategy;

  private final Optional<String> targetFolderName;

  private final Optional<Map<String, ImportManifestRequestLegacyRuleMappingValue>> legacyRuleMapping;

  private final Map<String, Object> additionalProperties;

  private ImportManifestRequest(ImportManifestRequestManifest manifest,
      Optional<ImportManifestRequestConflictStrategy> conflictStrategy,
      Optional<String> targetFolderName,
      Optional<Map<String, ImportManifestRequestLegacyRuleMappingValue>> legacyRuleMapping,
      Map<String, Object> additionalProperties) {
    this.manifest = manifest;
    this.conflictStrategy = conflictStrategy;
    this.targetFolderName = targetFolderName;
    this.legacyRuleMapping = legacyRuleMapping;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The RBM manifest object containing assets to import.
   */
  @JsonProperty("manifest")
  public ImportManifestRequestManifest getManifest() {
    return manifest;
  }

  /**
   * @return How to handle conflicts with existing assets. 'update' overwrites, 'skip' ignores, 'error' fails.
   */
  @JsonProperty("conflict_strategy")
  public Optional<ImportManifestRequestConflictStrategy> getConflictStrategy() {
    return conflictStrategy;
  }

  /**
   * @return Optional folder name to place imported assets into. Created if it doesn't exist.
   */
  @JsonProperty("target_folder_name")
  public Optional<String> getTargetFolderName() {
    return targetFolderName;
  }

  /**
   * @return Optional mapping for legacy flow imports to reuse existing rules.
   */
  @JsonProperty("legacy_rule_mapping")
  public Optional<Map<String, ImportManifestRequestLegacyRuleMappingValue>> getLegacyRuleMapping() {
    return legacyRuleMapping;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ImportManifestRequest && equalTo((ImportManifestRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ImportManifestRequest other) {
    return manifest.equals(other.manifest) && conflictStrategy.equals(other.conflictStrategy) && targetFolderName.equals(other.targetFolderName) && legacyRuleMapping.equals(other.legacyRuleMapping);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.manifest, this.conflictStrategy, this.targetFolderName, this.legacyRuleMapping);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static ManifestStage builder() {
    return new Builder();
  }

  public interface ManifestStage {
    /**
     * <p>The RBM manifest object containing assets to import.</p>
     */
    _FinalStage manifest(@NotNull ImportManifestRequestManifest manifest);

    Builder from(ImportManifestRequest other);
  }

  public interface _FinalStage {
    ImportManifestRequest build();

    /**
     * <p>How to handle conflicts with existing assets. 'update' overwrites, 'skip' ignores, 'error' fails.</p>
     */
    _FinalStage conflictStrategy(Optional<ImportManifestRequestConflictStrategy> conflictStrategy);

    _FinalStage conflictStrategy(ImportManifestRequestConflictStrategy conflictStrategy);

    /**
     * <p>Optional folder name to place imported assets into. Created if it doesn't exist.</p>
     */
    _FinalStage targetFolderName(Optional<String> targetFolderName);

    _FinalStage targetFolderName(String targetFolderName);

    /**
     * <p>Optional mapping for legacy flow imports to reuse existing rules.</p>
     */
    _FinalStage legacyRuleMapping(
        Optional<Map<String, ImportManifestRequestLegacyRuleMappingValue>> legacyRuleMapping);

    _FinalStage legacyRuleMapping(
        Map<String, ImportManifestRequestLegacyRuleMappingValue> legacyRuleMapping);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements ManifestStage, _FinalStage {
    private ImportManifestRequestManifest manifest;

    private Optional<Map<String, ImportManifestRequestLegacyRuleMappingValue>> legacyRuleMapping = Optional.empty();

    private Optional<String> targetFolderName = Optional.empty();

    private Optional<ImportManifestRequestConflictStrategy> conflictStrategy = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(ImportManifestRequest other) {
      manifest(other.getManifest());
      conflictStrategy(other.getConflictStrategy());
      targetFolderName(other.getTargetFolderName());
      legacyRuleMapping(other.getLegacyRuleMapping());
      return this;
    }

    /**
     * <p>The RBM manifest object containing assets to import.</p>
     * <p>The RBM manifest object containing assets to import.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("manifest")
    public _FinalStage manifest(@NotNull ImportManifestRequestManifest manifest) {
      this.manifest = Objects.requireNonNull(manifest, "manifest must not be null");
      return this;
    }

    /**
     * <p>Optional mapping for legacy flow imports to reuse existing rules.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage legacyRuleMapping(
        Map<String, ImportManifestRequestLegacyRuleMappingValue> legacyRuleMapping) {
      this.legacyRuleMapping = Optional.ofNullable(legacyRuleMapping);
      return this;
    }

    /**
     * <p>Optional mapping for legacy flow imports to reuse existing rules.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "legacy_rule_mapping",
        nulls = Nulls.SKIP
    )
    public _FinalStage legacyRuleMapping(
        Optional<Map<String, ImportManifestRequestLegacyRuleMappingValue>> legacyRuleMapping) {
      this.legacyRuleMapping = legacyRuleMapping;
      return this;
    }

    /**
     * <p>Optional folder name to place imported assets into. Created if it doesn't exist.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage targetFolderName(String targetFolderName) {
      this.targetFolderName = Optional.ofNullable(targetFolderName);
      return this;
    }

    /**
     * <p>Optional folder name to place imported assets into. Created if it doesn't exist.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "target_folder_name",
        nulls = Nulls.SKIP
    )
    public _FinalStage targetFolderName(Optional<String> targetFolderName) {
      this.targetFolderName = targetFolderName;
      return this;
    }

    /**
     * <p>How to handle conflicts with existing assets. 'update' overwrites, 'skip' ignores, 'error' fails.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage conflictStrategy(ImportManifestRequestConflictStrategy conflictStrategy) {
      this.conflictStrategy = Optional.ofNullable(conflictStrategy);
      return this;
    }

    /**
     * <p>How to handle conflicts with existing assets. 'update' overwrites, 'skip' ignores, 'error' fails.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "conflict_strategy",
        nulls = Nulls.SKIP
    )
    public _FinalStage conflictStrategy(
        Optional<ImportManifestRequestConflictStrategy> conflictStrategy) {
      this.conflictStrategy = conflictStrategy;
      return this;
    }

    @java.lang.Override
    public ImportManifestRequest build() {
      return new ImportManifestRequest(manifest, conflictStrategy, targetFolderName, legacyRuleMapping, additionalProperties);
    }
  }
}
