/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets.rules;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.assets.rules.requests.DeleteRuleRequest;
import com.rulebricks.resources.assets.rules.requests.ImportRuleRequest;
import com.rulebricks.resources.assets.rules.requests.ListRulesRequest;
import com.rulebricks.resources.assets.rules.requests.PullRulesRequest;
import com.rulebricks.types.RuleDetail;
import com.rulebricks.types.SuccessMessage;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncRulesClient {
  protected final ClientOptions clientOptions;

  private final AsyncRawRulesClient rawClient;

  public AsyncRulesClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new AsyncRawRulesClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public AsyncRawRulesClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Delete a specific rule by its ID.
   */
  public CompletableFuture<SuccessMessage> delete(DeleteRuleRequest request) {
    return this.rawClient.delete(request).thenApply(response -> response.body());
  }

  /**
   * Delete a specific rule by its ID.
   */
  public CompletableFuture<SuccessMessage> delete(DeleteRuleRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.delete(request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Export a specific rule by its ID.
   */
  public CompletableFuture<Map<String, Object>> pull(PullRulesRequest request) {
    return this.rawClient.pull(request).thenApply(response -> response.body());
  }

  /**
   * Export a specific rule by its ID.
   */
  public CompletableFuture<Map<String, Object>> pull(PullRulesRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.pull(request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Import a rule into the user's account.
   */
  public CompletableFuture<Map<String, Object>> push(ImportRuleRequest request) {
    return this.rawClient.push(request).thenApply(response -> response.body());
  }

  /**
   * Import a rule into the user's account.
   */
  public CompletableFuture<Map<String, Object>> push(ImportRuleRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.push(request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * List all rules in the organization. Optionally filter by folder name or ID.
   */
  public CompletableFuture<List<RuleDetail>> list() {
    return this.rawClient.list().thenApply(response -> response.body());
  }

  /**
   * List all rules in the organization. Optionally filter by folder name or ID.
   */
  public CompletableFuture<List<RuleDetail>> list(ListRulesRequest request) {
    return this.rawClient.list(request).thenApply(response -> response.body());
  }

  /**
   * List all rules in the organization. Optionally filter by folder name or ID.
   */
  public CompletableFuture<List<RuleDetail>> list(ListRulesRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.list(request, requestOptions).thenApply(response -> response.body());
  }
}
