/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ImportManifestRequestManifest.Builder.class
)
public final class ImportManifestRequestManifest {
  private final Optional<String> version;

  private final Optional<List<Map<String, Object>>> rules;

  private final Optional<List<Map<String, Object>>> flows;

  private final Optional<List<Map<String, Object>>> entities;

  private final Optional<List<Map<String, Object>>> values;

  private final Map<String, Object> additionalProperties;

  private ImportManifestRequestManifest(Optional<String> version,
      Optional<List<Map<String, Object>>> rules, Optional<List<Map<String, Object>>> flows,
      Optional<List<Map<String, Object>>> entities, Optional<List<Map<String, Object>>> values,
      Map<String, Object> additionalProperties) {
    this.version = version;
    this.rules = rules;
    this.flows = flows;
    this.entities = entities;
    this.values = values;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Manifest format version.
   */
  @JsonProperty("version")
  public Optional<String> getVersion() {
    return version;
  }

  /**
   * @return Rules to import.
   */
  @JsonProperty("rules")
  public Optional<List<Map<String, Object>>> getRules() {
    return rules;
  }

  /**
   * @return Flows to import.
   */
  @JsonProperty("flows")
  public Optional<List<Map<String, Object>>> getFlows() {
    return flows;
  }

  /**
   * @return Contexts to import.
   */
  @JsonProperty("entities")
  public Optional<List<Map<String, Object>>> getEntities() {
    return entities;
  }

  /**
   * @return Dynamic values to import.
   */
  @JsonProperty("values")
  public Optional<List<Map<String, Object>>> getValues() {
    return values;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ImportManifestRequestManifest && equalTo((ImportManifestRequestManifest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ImportManifestRequestManifest other) {
    return version.equals(other.version) && rules.equals(other.rules) && flows.equals(other.flows) && entities.equals(other.entities) && values.equals(other.values);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.version, this.rules, this.flows, this.entities, this.values);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> version = Optional.empty();

    private Optional<List<Map<String, Object>>> rules = Optional.empty();

    private Optional<List<Map<String, Object>>> flows = Optional.empty();

    private Optional<List<Map<String, Object>>> entities = Optional.empty();

    private Optional<List<Map<String, Object>>> values = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ImportManifestRequestManifest other) {
      version(other.getVersion());
      rules(other.getRules());
      flows(other.getFlows());
      entities(other.getEntities());
      values(other.getValues());
      return this;
    }

    /**
     * <p>Manifest format version.</p>
     */
    @JsonSetter(
        value = "version",
        nulls = Nulls.SKIP
    )
    public Builder version(Optional<String> version) {
      this.version = version;
      return this;
    }

    public Builder version(String version) {
      this.version = Optional.ofNullable(version);
      return this;
    }

    /**
     * <p>Rules to import.</p>
     */
    @JsonSetter(
        value = "rules",
        nulls = Nulls.SKIP
    )
    public Builder rules(Optional<List<Map<String, Object>>> rules) {
      this.rules = rules;
      return this;
    }

    public Builder rules(List<Map<String, Object>> rules) {
      this.rules = Optional.ofNullable(rules);
      return this;
    }

    /**
     * <p>Flows to import.</p>
     */
    @JsonSetter(
        value = "flows",
        nulls = Nulls.SKIP
    )
    public Builder flows(Optional<List<Map<String, Object>>> flows) {
      this.flows = flows;
      return this;
    }

    public Builder flows(List<Map<String, Object>> flows) {
      this.flows = Optional.ofNullable(flows);
      return this;
    }

    /**
     * <p>Contexts to import.</p>
     */
    @JsonSetter(
        value = "entities",
        nulls = Nulls.SKIP
    )
    public Builder entities(Optional<List<Map<String, Object>>> entities) {
      this.entities = entities;
      return this;
    }

    public Builder entities(List<Map<String, Object>> entities) {
      this.entities = Optional.ofNullable(entities);
      return this;
    }

    /**
     * <p>Dynamic values to import.</p>
     */
    @JsonSetter(
        value = "values",
        nulls = Nulls.SKIP
    )
    public Builder values(Optional<List<Map<String, Object>>> values) {
      this.values = values;
      return this;
    }

    public Builder values(List<Map<String, Object>> values) {
      this.values = Optional.ofNullable(values);
      return this;
    }

    public ImportManifestRequestManifest build() {
      return new ImportManifestRequestManifest(version, rules, flows, entities, values, additionalProperties);
    }
  }
}
