/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.contexts;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.Suppliers;
import com.rulebricks.resources.contexts.objects.AsyncObjectsClient;
import com.rulebricks.resources.contexts.relationships.AsyncRelationshipsClient;
import com.rulebricks.resources.contexts.requests.CascadeContextsRequest;
import com.rulebricks.resources.contexts.requests.DeleteContextsRequest;
import com.rulebricks.resources.contexts.requests.ExecuteContextsRequest;
import com.rulebricks.resources.contexts.requests.GetContextsRequest;
import com.rulebricks.resources.contexts.requests.GetHistoryContextsRequest;
import com.rulebricks.resources.contexts.requests.GetPendingContextsRequest;
import com.rulebricks.resources.contexts.requests.SolveContextsRequest;
import com.rulebricks.resources.contexts.requests.SubmitContextsRequest;
import com.rulebricks.types.CascadeContextResponse;
import com.rulebricks.types.ContextInstanceHistory;
import com.rulebricks.types.ContextInstancePendingResponse;
import com.rulebricks.types.ContextInstanceState;
import com.rulebricks.types.DeleteContextInstanceResponse;
import com.rulebricks.types.SolveContextFlowResponse;
import com.rulebricks.types.SolveContextRuleResponse;
import com.rulebricks.types.SubmitContextDataResponse;
import java.lang.String;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncContextsClient {
  protected final ClientOptions clientOptions;

  private final AsyncRawContextsClient rawClient;

  protected final Supplier<AsyncObjectsClient> objectsClient;

  protected final Supplier<AsyncRelationshipsClient> relationshipsClient;

  public AsyncContextsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new AsyncRawContextsClient(clientOptions);
    this.objectsClient = Suppliers.memoize(() -> new AsyncObjectsClient(clientOptions));
    this.relationshipsClient = Suppliers.memoize(() -> new AsyncRelationshipsClient(clientOptions));
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public AsyncRawContextsClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Retrieve the current state of a context instance.
   */
  public CompletableFuture<ContextInstanceState> get(String slug, String instance) {
    return this.rawClient.get(slug, instance).thenApply(response -> response.body());
  }

  /**
   * Retrieve the current state of a context instance.
   */
  public CompletableFuture<ContextInstanceState> get(String slug, String instance,
      GetContextsRequest request) {
    return this.rawClient.get(slug, instance, request).thenApply(response -> response.body());
  }

  /**
   * Retrieve the current state of a context instance.
   */
  public CompletableFuture<ContextInstanceState> get(String slug, String instance,
      GetContextsRequest request, RequestOptions requestOptions) {
    return this.rawClient.get(slug, instance, request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Submit data to a context instance, creating it if it doesn't exist. May trigger bound rule/flow evaluations.
   */
  public CompletableFuture<SubmitContextDataResponse> submit(String slug, String instance,
      SubmitContextsRequest request) {
    return this.rawClient.submit(slug, instance, request).thenApply(response -> response.body());
  }

  /**
   * Submit data to a context instance, creating it if it doesn't exist. May trigger bound rule/flow evaluations.
   */
  public CompletableFuture<SubmitContextDataResponse> submit(String slug, String instance,
      SubmitContextsRequest request, RequestOptions requestOptions) {
    return this.rawClient.submit(slug, instance, request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Delete a specific context instance and its history.
   */
  public CompletableFuture<DeleteContextInstanceResponse> delete(String slug, String instance) {
    return this.rawClient.delete(slug, instance).thenApply(response -> response.body());
  }

  /**
   * Delete a specific context instance and its history.
   */
  public CompletableFuture<DeleteContextInstanceResponse> delete(String slug, String instance,
      DeleteContextsRequest request) {
    return this.rawClient.delete(slug, instance, request).thenApply(response -> response.body());
  }

  /**
   * Delete a specific context instance and its history.
   */
  public CompletableFuture<DeleteContextInstanceResponse> delete(String slug, String instance,
      DeleteContextsRequest request, RequestOptions requestOptions) {
    return this.rawClient.delete(slug, instance, request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Retrieve the change history for a context instance.
   */
  public CompletableFuture<ContextInstanceHistory> getHistory(String slug, String instance) {
    return this.rawClient.getHistory(slug, instance).thenApply(response -> response.body());
  }

  /**
   * Retrieve the change history for a context instance.
   */
  public CompletableFuture<ContextInstanceHistory> getHistory(String slug, String instance,
      GetHistoryContextsRequest request) {
    return this.rawClient.getHistory(slug, instance, request).thenApply(response -> response.body());
  }

  /**
   * Retrieve the change history for a context instance.
   */
  public CompletableFuture<ContextInstanceHistory> getHistory(String slug, String instance,
      GetHistoryContextsRequest request, RequestOptions requestOptions) {
    return this.rawClient.getHistory(slug, instance, request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Get list of rules/flows that need to be evaluated for this instance.
   */
  public CompletableFuture<ContextInstancePendingResponse> getPending(String slug,
      String instance) {
    return this.rawClient.getPending(slug, instance).thenApply(response -> response.body());
  }

  /**
   * Get list of rules/flows that need to be evaluated for this instance.
   */
  public CompletableFuture<ContextInstancePendingResponse> getPending(String slug, String instance,
      GetPendingContextsRequest request) {
    return this.rawClient.getPending(slug, instance, request).thenApply(response -> response.body());
  }

  /**
   * Get list of rules/flows that need to be evaluated for this instance.
   */
  public CompletableFuture<ContextInstancePendingResponse> getPending(String slug, String instance,
      GetPendingContextsRequest request, RequestOptions requestOptions) {
    return this.rawClient.getPending(slug, instance, request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Execute a specific rule using the context instance's state as input.
   */
  public CompletableFuture<SolveContextRuleResponse> solve(String slug, String instance,
      String ruleSlug, SolveContextsRequest request) {
    return this.rawClient.solve(slug, instance, ruleSlug, request).thenApply(response -> response.body());
  }

  /**
   * Execute a specific rule using the context instance's state as input.
   */
  public CompletableFuture<SolveContextRuleResponse> solve(String slug, String instance,
      String ruleSlug, SolveContextsRequest request, RequestOptions requestOptions) {
    return this.rawClient.solve(slug, instance, ruleSlug, request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Trigger re-evaluation of all bound rules and flows for the instance.
   */
  public CompletableFuture<CascadeContextResponse> cascade(String slug, String instance,
      CascadeContextsRequest request) {
    return this.rawClient.cascade(slug, instance, request).thenApply(response -> response.body());
  }

  /**
   * Trigger re-evaluation of all bound rules and flows for the instance.
   */
  public CompletableFuture<CascadeContextResponse> cascade(String slug, String instance,
      CascadeContextsRequest request, RequestOptions requestOptions) {
    return this.rawClient.cascade(slug, instance, request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Execute a specific flow using the context instance's state as input.
   */
  public CompletableFuture<SolveContextFlowResponse> execute(String slug, String instance,
      String flowSlug, ExecuteContextsRequest request) {
    return this.rawClient.execute(slug, instance, flowSlug, request).thenApply(response -> response.body());
  }

  /**
   * Execute a specific flow using the context instance's state as input.
   */
  public CompletableFuture<SolveContextFlowResponse> execute(String slug, String instance,
      String flowSlug, ExecuteContextsRequest request, RequestOptions requestOptions) {
    return this.rawClient.execute(slug, instance, flowSlug, request, requestOptions).thenApply(response -> response.body());
  }

  public AsyncObjectsClient objects() {
    return this.objectsClient.get();
  }

  public AsyncRelationshipsClient relationships() {
    return this.relationshipsClient.get();
  }
}
