/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.contexts.objects;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.contexts.objects.requests.CreateContextRequest;
import com.rulebricks.resources.contexts.objects.requests.DeleteObjectsRequest;
import com.rulebricks.resources.contexts.objects.requests.GetObjectsRequest;
import com.rulebricks.resources.contexts.objects.requests.UpdateContextRequest;
import com.rulebricks.types.ContextDetail;
import com.rulebricks.types.ContextListItem;
import com.rulebricks.types.DeleteContextResponse;
import com.rulebricks.types.UpdateContextResponse;
import java.lang.String;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncObjectsClient {
  protected final ClientOptions clientOptions;

  private final AsyncRawObjectsClient rawClient;

  public AsyncObjectsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new AsyncRawObjectsClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public AsyncRawObjectsClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Retrieve all contexts for the authenticated user.
   */
  public CompletableFuture<List<ContextListItem>> list() {
    return this.rawClient.list().thenApply(response -> response.body());
  }

  /**
   * Retrieve all contexts for the authenticated user.
   */
  public CompletableFuture<List<ContextListItem>> list(RequestOptions requestOptions) {
    return this.rawClient.list(requestOptions).thenApply(response -> response.body());
  }

  /**
   * Create a new context for the authenticated user.
   */
  public CompletableFuture<ContextDetail> create(CreateContextRequest request) {
    return this.rawClient.create(request).thenApply(response -> response.body());
  }

  /**
   * Create a new context for the authenticated user.
   */
  public CompletableFuture<ContextDetail> create(CreateContextRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.create(request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Retrieve a specific context by its ID.
   */
  public CompletableFuture<ContextDetail> get(String id) {
    return this.rawClient.get(id).thenApply(response -> response.body());
  }

  /**
   * Retrieve a specific context by its ID.
   */
  public CompletableFuture<ContextDetail> get(String id, GetObjectsRequest request) {
    return this.rawClient.get(id, request).thenApply(response -> response.body());
  }

  /**
   * Retrieve a specific context by its ID.
   */
  public CompletableFuture<ContextDetail> get(String id, GetObjectsRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.get(id, request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Update an existing context's properties and schema.
   */
  public CompletableFuture<UpdateContextResponse> update(String id) {
    return this.rawClient.update(id).thenApply(response -> response.body());
  }

  /**
   * Update an existing context's properties and schema.
   */
  public CompletableFuture<UpdateContextResponse> update(String id, UpdateContextRequest request) {
    return this.rawClient.update(id, request).thenApply(response -> response.body());
  }

  /**
   * Update an existing context's properties and schema.
   */
  public CompletableFuture<UpdateContextResponse> update(String id, UpdateContextRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.update(id, request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Delete a specific context and all its instances.
   */
  public CompletableFuture<DeleteContextResponse> delete(String id) {
    return this.rawClient.delete(id).thenApply(response -> response.body());
  }

  /**
   * Delete a specific context and all its instances.
   */
  public CompletableFuture<DeleteContextResponse> delete(String id, DeleteObjectsRequest request) {
    return this.rawClient.delete(id, request).thenApply(response -> response.body());
  }

  /**
   * Delete a specific context and all its instances.
   */
  public CompletableFuture<DeleteContextResponse> delete(String id, DeleteObjectsRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.delete(id, request, requestOptions).thenApply(response -> response.body());
  }
}
