/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.contexts.objects;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.contexts.objects.requests.CreateContextRequest;
import com.rulebricks.resources.contexts.objects.requests.DeleteObjectsRequest;
import com.rulebricks.resources.contexts.objects.requests.GetObjectsRequest;
import com.rulebricks.resources.contexts.objects.requests.UpdateContextRequest;
import com.rulebricks.types.ContextDetail;
import com.rulebricks.types.ContextListItem;
import com.rulebricks.types.DeleteContextResponse;
import com.rulebricks.types.UpdateContextResponse;
import java.lang.String;
import java.util.List;

public class ObjectsClient {
  protected final ClientOptions clientOptions;

  private final RawObjectsClient rawClient;

  public ObjectsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new RawObjectsClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public RawObjectsClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Retrieve all contexts for the authenticated user.
   */
  public List<ContextListItem> list() {
    return this.rawClient.list().body();
  }

  /**
   * Retrieve all contexts for the authenticated user.
   */
  public List<ContextListItem> list(RequestOptions requestOptions) {
    return this.rawClient.list(requestOptions).body();
  }

  /**
   * Create a new context for the authenticated user.
   */
  public ContextDetail create(CreateContextRequest request) {
    return this.rawClient.create(request).body();
  }

  /**
   * Create a new context for the authenticated user.
   */
  public ContextDetail create(CreateContextRequest request, RequestOptions requestOptions) {
    return this.rawClient.create(request, requestOptions).body();
  }

  /**
   * Retrieve a specific context by its ID.
   */
  public ContextDetail get(String id) {
    return this.rawClient.get(id).body();
  }

  /**
   * Retrieve a specific context by its ID.
   */
  public ContextDetail get(String id, GetObjectsRequest request) {
    return this.rawClient.get(id, request).body();
  }

  /**
   * Retrieve a specific context by its ID.
   */
  public ContextDetail get(String id, GetObjectsRequest request, RequestOptions requestOptions) {
    return this.rawClient.get(id, request, requestOptions).body();
  }

  /**
   * Update an existing context's properties and schema.
   */
  public UpdateContextResponse update(String id) {
    return this.rawClient.update(id).body();
  }

  /**
   * Update an existing context's properties and schema.
   */
  public UpdateContextResponse update(String id, UpdateContextRequest request) {
    return this.rawClient.update(id, request).body();
  }

  /**
   * Update an existing context's properties and schema.
   */
  public UpdateContextResponse update(String id, UpdateContextRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.update(id, request, requestOptions).body();
  }

  /**
   * Delete a specific context and all its instances.
   */
  public DeleteContextResponse delete(String id) {
    return this.rawClient.delete(id).body();
  }

  /**
   * Delete a specific context and all its instances.
   */
  public DeleteContextResponse delete(String id, DeleteObjectsRequest request) {
    return this.rawClient.delete(id, request).body();
  }

  /**
   * Delete a specific context and all its instances.
   */
  public DeleteContextResponse delete(String id, DeleteObjectsRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.delete(id, request, requestOptions).body();
  }
}
