/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.contexts.relationships.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.resources.contexts.relationships.types.CreateRelationshipRequestRelationType;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = CreateRelationshipRequest.Builder.class
)
public final class CreateRelationshipRequest {
  private final String toContextId;

  private final CreateRelationshipRequestRelationType relationType;

  private final String foreignKeyFact;

  private final Optional<String> name;

  private final Optional<String> description;

  private final Map<String, Object> additionalProperties;

  private CreateRelationshipRequest(String toContextId,
      CreateRelationshipRequestRelationType relationType, String foreignKeyFact,
      Optional<String> name, Optional<String> description,
      Map<String, Object> additionalProperties) {
    this.toContextId = toContextId;
    this.relationType = relationType;
    this.foreignKeyFact = foreignKeyFact;
    this.name = name;
    this.description = description;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The ID of the target context.
   */
  @JsonProperty("to_context_id")
  public String getToContextId() {
    return toContextId;
  }

  /**
   * @return The type of relationship.
   */
  @JsonProperty("relation_type")
  public CreateRelationshipRequestRelationType getRelationType() {
    return relationType;
  }

  /**
   * @return The field key to use as the foreign key.
   */
  @JsonProperty("foreign_key_fact")
  public String getForeignKeyFact() {
    return foreignKeyFact;
  }

  /**
   * @return Display name for the relationship.
   */
  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return Description of the relationship.
   */
  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CreateRelationshipRequest && equalTo((CreateRelationshipRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CreateRelationshipRequest other) {
    return toContextId.equals(other.toContextId) && relationType.equals(other.relationType) && foreignKeyFact.equals(other.foreignKeyFact) && name.equals(other.name) && description.equals(other.description);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.toContextId, this.relationType, this.foreignKeyFact, this.name, this.description);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static ToContextIdStage builder() {
    return new Builder();
  }

  public interface ToContextIdStage {
    /**
     * <p>The ID of the target context.</p>
     */
    RelationTypeStage toContextId(@NotNull String toContextId);

    Builder from(CreateRelationshipRequest other);
  }

  public interface RelationTypeStage {
    /**
     * <p>The type of relationship.</p>
     */
    ForeignKeyFactStage relationType(@NotNull CreateRelationshipRequestRelationType relationType);
  }

  public interface ForeignKeyFactStage {
    /**
     * <p>The field key to use as the foreign key.</p>
     */
    _FinalStage foreignKeyFact(@NotNull String foreignKeyFact);
  }

  public interface _FinalStage {
    CreateRelationshipRequest build();

    /**
     * <p>Display name for the relationship.</p>
     */
    _FinalStage name(Optional<String> name);

    _FinalStage name(String name);

    /**
     * <p>Description of the relationship.</p>
     */
    _FinalStage description(Optional<String> description);

    _FinalStage description(String description);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements ToContextIdStage, RelationTypeStage, ForeignKeyFactStage, _FinalStage {
    private String toContextId;

    private CreateRelationshipRequestRelationType relationType;

    private String foreignKeyFact;

    private Optional<String> description = Optional.empty();

    private Optional<String> name = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(CreateRelationshipRequest other) {
      toContextId(other.getToContextId());
      relationType(other.getRelationType());
      foreignKeyFact(other.getForeignKeyFact());
      name(other.getName());
      description(other.getDescription());
      return this;
    }

    /**
     * <p>The ID of the target context.</p>
     * <p>The ID of the target context.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("to_context_id")
    public RelationTypeStage toContextId(@NotNull String toContextId) {
      this.toContextId = Objects.requireNonNull(toContextId, "toContextId must not be null");
      return this;
    }

    /**
     * <p>The type of relationship.</p>
     * <p>The type of relationship.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("relation_type")
    public ForeignKeyFactStage relationType(
        @NotNull CreateRelationshipRequestRelationType relationType) {
      this.relationType = Objects.requireNonNull(relationType, "relationType must not be null");
      return this;
    }

    /**
     * <p>The field key to use as the foreign key.</p>
     * <p>The field key to use as the foreign key.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("foreign_key_fact")
    public _FinalStage foreignKeyFact(@NotNull String foreignKeyFact) {
      this.foreignKeyFact = Objects.requireNonNull(foreignKeyFact, "foreignKeyFact must not be null");
      return this;
    }

    /**
     * <p>Description of the relationship.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    /**
     * <p>Description of the relationship.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public _FinalStage description(Optional<String> description) {
      this.description = description;
      return this;
    }

    /**
     * <p>Display name for the relationship.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    /**
     * <p>Display name for the relationship.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public _FinalStage name(Optional<String> name) {
      this.name = name;
      return this;
    }

    @java.lang.Override
    public CreateRelationshipRequest build() {
      return new CreateRelationshipRequest(toContextId, relationType, foreignKeyFact, name, description, additionalProperties);
    }
  }
}
