/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.decisions.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.resources.decisions.types.QueryDecisionsRequestCount;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = QueryDecisionsRequest.Builder.class
)
public final class QueryDecisionsRequest {
  private final Optional<String> search;

  private final Optional<String> rules;

  private final Optional<String> statuses;

  private final Optional<OffsetDateTime> start;

  private final Optional<OffsetDateTime> end;

  private final Optional<String> cursor;

  private final Optional<Integer> limit;

  private final Optional<QueryDecisionsRequestCount> count;

  private final Optional<String> slug;

  private final Map<String, Object> additionalProperties;

  private QueryDecisionsRequest(Optional<String> search, Optional<String> rules,
      Optional<String> statuses, Optional<OffsetDateTime> start, Optional<OffsetDateTime> end,
      Optional<String> cursor, Optional<Integer> limit, Optional<QueryDecisionsRequestCount> count,
      Optional<String> slug, Map<String, Object> additionalProperties) {
    this.search = search;
    this.rules = rules;
    this.statuses = statuses;
    this.start = start;
    this.end = end;
    this.cursor = cursor;
    this.limit = limit;
    this.count = count;
    this.slug = slug;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Decision data query language expression to filter logs by request/response data. Supports field comparisons (<code>field=value</code>, <code>field&gt;10</code>), contains (<code>field:text</code>), not-contains (<code>field!:text</code>), boolean operators (<code>AND</code>, <code>OR</code>), and parentheses.
   */
  @JsonProperty("search")
  public Optional<String> getSearch() {
    return search;
  }

  /**
   * @return Comma-separated list of rule names to filter logs by.
   */
  @JsonProperty("rules")
  public Optional<String> getRules() {
    return rules;
  }

  /**
   * @return Comma-separated list of HTTP status codes to filter logs by.
   */
  @JsonProperty("statuses")
  public Optional<String> getStatuses() {
    return statuses;
  }

  /**
   * @return Start date for the query range (ISO8601 format).
   */
  @JsonProperty("start")
  public Optional<OffsetDateTime> getStart() {
    return start;
  }

  /**
   * @return End date for the query range (ISO8601 format).
   */
  @JsonProperty("end")
  public Optional<OffsetDateTime> getEnd() {
    return end;
  }

  /**
   * @return Cursor for pagination (returned from previous query).
   */
  @JsonProperty("cursor")
  public Optional<String> getCursor() {
    return cursor;
  }

  /**
   * @return Number of results to return per page (default: 100).
   */
  @JsonProperty("limit")
  public Optional<Integer> getLimit() {
    return limit;
  }

  /**
   * @return If set to 'true', returns only the count of matching logs instead of the log data.
   */
  @JsonProperty("count")
  public Optional<QueryDecisionsRequestCount> getCount() {
    return count;
  }

  /**
   * @return (Deprecated) Legacy parameter for filtering by rule slug. Use 'rules' parameter instead.
   */
  @JsonProperty("slug")
  public Optional<String> getSlug() {
    return slug;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof QueryDecisionsRequest && equalTo((QueryDecisionsRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(QueryDecisionsRequest other) {
    return search.equals(other.search) && rules.equals(other.rules) && statuses.equals(other.statuses) && start.equals(other.start) && end.equals(other.end) && cursor.equals(other.cursor) && limit.equals(other.limit) && count.equals(other.count) && slug.equals(other.slug);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.search, this.rules, this.statuses, this.start, this.end, this.cursor, this.limit, this.count, this.slug);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> search = Optional.empty();

    private Optional<String> rules = Optional.empty();

    private Optional<String> statuses = Optional.empty();

    private Optional<OffsetDateTime> start = Optional.empty();

    private Optional<OffsetDateTime> end = Optional.empty();

    private Optional<String> cursor = Optional.empty();

    private Optional<Integer> limit = Optional.empty();

    private Optional<QueryDecisionsRequestCount> count = Optional.empty();

    private Optional<String> slug = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(QueryDecisionsRequest other) {
      search(other.getSearch());
      rules(other.getRules());
      statuses(other.getStatuses());
      start(other.getStart());
      end(other.getEnd());
      cursor(other.getCursor());
      limit(other.getLimit());
      count(other.getCount());
      slug(other.getSlug());
      return this;
    }

    /**
     * <p>Decision data query language expression to filter logs by request/response data. Supports field comparisons (<code>field=value</code>, <code>field&gt;10</code>), contains (<code>field:text</code>), not-contains (<code>field!:text</code>), boolean operators (<code>AND</code>, <code>OR</code>), and parentheses.</p>
     */
    @JsonSetter(
        value = "search",
        nulls = Nulls.SKIP
    )
    public Builder search(Optional<String> search) {
      this.search = search;
      return this;
    }

    public Builder search(String search) {
      this.search = Optional.ofNullable(search);
      return this;
    }

    /**
     * <p>Comma-separated list of rule names to filter logs by.</p>
     */
    @JsonSetter(
        value = "rules",
        nulls = Nulls.SKIP
    )
    public Builder rules(Optional<String> rules) {
      this.rules = rules;
      return this;
    }

    public Builder rules(String rules) {
      this.rules = Optional.ofNullable(rules);
      return this;
    }

    /**
     * <p>Comma-separated list of HTTP status codes to filter logs by.</p>
     */
    @JsonSetter(
        value = "statuses",
        nulls = Nulls.SKIP
    )
    public Builder statuses(Optional<String> statuses) {
      this.statuses = statuses;
      return this;
    }

    public Builder statuses(String statuses) {
      this.statuses = Optional.ofNullable(statuses);
      return this;
    }

    /**
     * <p>Start date for the query range (ISO8601 format).</p>
     */
    @JsonSetter(
        value = "start",
        nulls = Nulls.SKIP
    )
    public Builder start(Optional<OffsetDateTime> start) {
      this.start = start;
      return this;
    }

    public Builder start(OffsetDateTime start) {
      this.start = Optional.ofNullable(start);
      return this;
    }

    /**
     * <p>End date for the query range (ISO8601 format).</p>
     */
    @JsonSetter(
        value = "end",
        nulls = Nulls.SKIP
    )
    public Builder end(Optional<OffsetDateTime> end) {
      this.end = end;
      return this;
    }

    public Builder end(OffsetDateTime end) {
      this.end = Optional.ofNullable(end);
      return this;
    }

    /**
     * <p>Cursor for pagination (returned from previous query).</p>
     */
    @JsonSetter(
        value = "cursor",
        nulls = Nulls.SKIP
    )
    public Builder cursor(Optional<String> cursor) {
      this.cursor = cursor;
      return this;
    }

    public Builder cursor(String cursor) {
      this.cursor = Optional.ofNullable(cursor);
      return this;
    }

    /**
     * <p>Number of results to return per page (default: 100).</p>
     */
    @JsonSetter(
        value = "limit",
        nulls = Nulls.SKIP
    )
    public Builder limit(Optional<Integer> limit) {
      this.limit = limit;
      return this;
    }

    public Builder limit(Integer limit) {
      this.limit = Optional.ofNullable(limit);
      return this;
    }

    /**
     * <p>If set to 'true', returns only the count of matching logs instead of the log data.</p>
     */
    @JsonSetter(
        value = "count",
        nulls = Nulls.SKIP
    )
    public Builder count(Optional<QueryDecisionsRequestCount> count) {
      this.count = count;
      return this;
    }

    public Builder count(QueryDecisionsRequestCount count) {
      this.count = Optional.ofNullable(count);
      return this;
    }

    /**
     * <p>(Deprecated) Legacy parameter for filtering by rule slug. Use 'rules' parameter instead.</p>
     */
    @JsonSetter(
        value = "slug",
        nulls = Nulls.SKIP
    )
    public Builder slug(Optional<String> slug) {
      this.slug = slug;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = Optional.ofNullable(slug);
      return this;
    }

    public QueryDecisionsRequest build() {
      return new QueryDecisionsRequest(search, rules, statuses, start, end, cursor, limit, count, slug, additionalProperties);
    }
  }
}
