/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.users;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.Suppliers;
import com.rulebricks.resources.users.groups.AsyncGroupsClient;
import com.rulebricks.resources.users.requests.CreateUserRequest;
import com.rulebricks.resources.users.requests.UserInviteRequest;
import com.rulebricks.types.CreateUserResponse;
import com.rulebricks.types.UserDetail;
import com.rulebricks.types.UserInviteResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncUsersClient {
  protected final ClientOptions clientOptions;

  private final AsyncRawUsersClient rawClient;

  protected final Supplier<AsyncGroupsClient> groupsClient;

  public AsyncUsersClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new AsyncRawUsersClient(clientOptions);
    this.groupsClient = Suppliers.memoize(() -> new AsyncGroupsClient(clientOptions));
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public AsyncRawUsersClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Invite a new user to the organization or update role or user group data for an existing user.
   */
  public CompletableFuture<UserInviteResponse> invite(UserInviteRequest request) {
    return this.rawClient.invite(request).thenApply(response -> response.body());
  }

  /**
   * Invite a new user to the organization or update role or user group data for an existing user.
   */
  public CompletableFuture<UserInviteResponse> invite(UserInviteRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.invite(request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * List all users (including the admin and all team members) in the organization with their details including email, name, API key, role, user groups, and join date.
   */
  public CompletableFuture<List<UserDetail>> list() {
    return this.rawClient.list().thenApply(response -> response.body());
  }

  /**
   * List all users (including the admin and all team members) in the organization with their details including email, name, API key, role, user groups, and join date.
   */
  public CompletableFuture<List<UserDetail>> list(RequestOptions requestOptions) {
    return this.rawClient.list(requestOptions).thenApply(response -> response.body());
  }

  /**
   * Create a new user directly with a password, bypassing the email invitation flow. The user can immediately log in with the provided credentials.
   */
  public CompletableFuture<CreateUserResponse> create(CreateUserRequest request) {
    return this.rawClient.create(request).thenApply(response -> response.body());
  }

  /**
   * Create a new user directly with a password, bypassing the email invitation flow. The user can immediately log in with the provided credentials.
   */
  public CompletableFuture<CreateUserResponse> create(CreateUserRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.create(request, requestOptions).thenApply(response -> response.body());
  }

  public AsyncGroupsClient groups() {
    return this.groupsClient.get();
  }
}
