/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.users.groups;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.users.groups.requests.CreateUserGroupRequest;
import com.rulebricks.types.UserGroup;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncGroupsClient {
  protected final ClientOptions clientOptions;

  private final AsyncRawGroupsClient rawClient;

  public AsyncGroupsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new AsyncRawGroupsClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public AsyncRawGroupsClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * List all user groups available in your Rulebricks organization.
   */
  public CompletableFuture<List<UserGroup>> list() {
    return this.rawClient.list().thenApply(response -> response.body());
  }

  /**
   * List all user groups available in your Rulebricks organization.
   */
  public CompletableFuture<List<UserGroup>> list(RequestOptions requestOptions) {
    return this.rawClient.list(requestOptions).thenApply(response -> response.body());
  }

  /**
   * Create a new user group in your Rulebricks organization.
   */
  public CompletableFuture<UserGroup> create(CreateUserGroupRequest request) {
    return this.rawClient.create(request).thenApply(response -> response.body());
  }

  /**
   * Create a new user group in your Rulebricks organization.
   */
  public CompletableFuture<UserGroup> create(CreateUserGroupRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.create(request, requestOptions).thenApply(response -> response.body());
  }
}
