/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = CascadeContextResponse.Builder.class
)
public final class CascadeContextResponse {
  private final Optional<String> context;

  private final Optional<List<CascadeResult>> cascaded;

  private final Map<String, Object> additionalProperties;

  private CascadeContextResponse(Optional<String> context, Optional<List<CascadeResult>> cascaded,
      Map<String, Object> additionalProperties) {
    this.context = context;
    this.cascaded = cascaded;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Combined identifier in format 'contextSlug:instanceId'.
   */
  @JsonProperty("context")
  public Optional<String> getContext() {
    return context;
  }

  /**
   * @return Results from all cascaded evaluations.
   */
  @JsonProperty("cascaded")
  public Optional<List<CascadeResult>> getCascaded() {
    return cascaded;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CascadeContextResponse && equalTo((CascadeContextResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CascadeContextResponse other) {
    return context.equals(other.context) && cascaded.equals(other.cascaded);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.context, this.cascaded);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> context = Optional.empty();

    private Optional<List<CascadeResult>> cascaded = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(CascadeContextResponse other) {
      context(other.getContext());
      cascaded(other.getCascaded());
      return this;
    }

    /**
     * <p>Combined identifier in format 'contextSlug:instanceId'.</p>
     */
    @JsonSetter(
        value = "context",
        nulls = Nulls.SKIP
    )
    public Builder context(Optional<String> context) {
      this.context = context;
      return this;
    }

    public Builder context(String context) {
      this.context = Optional.ofNullable(context);
      return this;
    }

    /**
     * <p>Results from all cascaded evaluations.</p>
     */
    @JsonSetter(
        value = "cascaded",
        nulls = Nulls.SKIP
    )
    public Builder cascaded(Optional<List<CascadeResult>> cascaded) {
      this.cascaded = cascaded;
      return this;
    }

    public Builder cascaded(List<CascadeResult> cascaded) {
      this.cascaded = Optional.ofNullable(cascaded);
      return this;
    }

    public CascadeContextResponse build() {
      return new CascadeContextResponse(context, cascaded, additionalProperties);
    }
  }
}
