/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = CascadeResult.Builder.class
)
public final class CascadeResult {
  private final Optional<String> context;

  private final Optional<String> rule;

  private final Optional<String> flow;

  private final Optional<CascadeResultStatus> status;

  private final Optional<Map<String, Object>> result;

  private final Optional<Boolean> autoExecuted;

  private final Optional<List<String>> writtenToContext;

  private final Optional<String> error;

  private final Map<String, Object> additionalProperties;

  private CascadeResult(Optional<String> context, Optional<String> rule, Optional<String> flow,
      Optional<CascadeResultStatus> status, Optional<Map<String, Object>> result,
      Optional<Boolean> autoExecuted, Optional<List<String>> writtenToContext,
      Optional<String> error, Map<String, Object> additionalProperties) {
    this.context = context;
    this.rule = rule;
    this.flow = flow;
    this.status = status;
    this.result = result;
    this.autoExecuted = autoExecuted;
    this.writtenToContext = writtenToContext;
    this.error = error;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Combined identifier in format 'contextSlug:instanceId'.
   */
  @JsonProperty("context")
  public Optional<String> getContext() {
    return context;
  }

  /**
   * @return The rule slug (if this was a rule evaluation).
   */
  @JsonIgnore
  public Optional<String> getRule() {
    if (rule == null) {
      return Optional.empty();
    }
    return rule;
  }

  /**
   * @return The flow slug (if this was a flow evaluation).
   */
  @JsonIgnore
  public Optional<String> getFlow() {
    if (flow == null) {
      return Optional.empty();
    }
    return flow;
  }

  /**
   * @return Whether the evaluation succeeded.
   */
  @JsonProperty("status")
  public Optional<CascadeResultStatus> getStatus() {
    return status;
  }

  /**
   * @return The evaluation output.
   */
  @JsonProperty("result")
  public Optional<Map<String, Object>> getResult() {
    return result;
  }

  /**
   * @return Whether this was auto-executed (true) or from a registered pending evaluation (false).
   */
  @JsonProperty("auto_executed")
  public Optional<Boolean> getAutoExecuted() {
    return autoExecuted;
  }

  /**
   * @return List of field keys written back to the context (for rule evaluations).
   */
  @JsonProperty("written_to_context")
  public Optional<List<String>> getWrittenToContext() {
    return writtenToContext;
  }

  /**
   * @return Error message if the evaluation failed.
   */
  @JsonIgnore
  public Optional<String> getError() {
    if (error == null) {
      return Optional.empty();
    }
    return error;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("rule")
  private Optional<String> _getRule() {
    return rule;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("flow")
  private Optional<String> _getFlow() {
    return flow;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("error")
  private Optional<String> _getError() {
    return error;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CascadeResult && equalTo((CascadeResult) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CascadeResult other) {
    return context.equals(other.context) && rule.equals(other.rule) && flow.equals(other.flow) && status.equals(other.status) && result.equals(other.result) && autoExecuted.equals(other.autoExecuted) && writtenToContext.equals(other.writtenToContext) && error.equals(other.error);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.context, this.rule, this.flow, this.status, this.result, this.autoExecuted, this.writtenToContext, this.error);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> context = Optional.empty();

    private Optional<String> rule = Optional.empty();

    private Optional<String> flow = Optional.empty();

    private Optional<CascadeResultStatus> status = Optional.empty();

    private Optional<Map<String, Object>> result = Optional.empty();

    private Optional<Boolean> autoExecuted = Optional.empty();

    private Optional<List<String>> writtenToContext = Optional.empty();

    private Optional<String> error = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(CascadeResult other) {
      context(other.getContext());
      rule(other.getRule());
      flow(other.getFlow());
      status(other.getStatus());
      result(other.getResult());
      autoExecuted(other.getAutoExecuted());
      writtenToContext(other.getWrittenToContext());
      error(other.getError());
      return this;
    }

    /**
     * <p>Combined identifier in format 'contextSlug:instanceId'.</p>
     */
    @JsonSetter(
        value = "context",
        nulls = Nulls.SKIP
    )
    public Builder context(Optional<String> context) {
      this.context = context;
      return this;
    }

    public Builder context(String context) {
      this.context = Optional.ofNullable(context);
      return this;
    }

    /**
     * <p>The rule slug (if this was a rule evaluation).</p>
     */
    @JsonSetter(
        value = "rule",
        nulls = Nulls.SKIP
    )
    public Builder rule(Optional<String> rule) {
      this.rule = rule;
      return this;
    }

    public Builder rule(String rule) {
      this.rule = Optional.ofNullable(rule);
      return this;
    }

    public Builder rule(Nullable<String> rule) {
      if (rule.isNull()) {
        this.rule = null;
      }
      else if (rule.isEmpty()) {
        this.rule = Optional.empty();
      }
      else {
        this.rule = Optional.of(rule.get());
      }
      return this;
    }

    /**
     * <p>The flow slug (if this was a flow evaluation).</p>
     */
    @JsonSetter(
        value = "flow",
        nulls = Nulls.SKIP
    )
    public Builder flow(Optional<String> flow) {
      this.flow = flow;
      return this;
    }

    public Builder flow(String flow) {
      this.flow = Optional.ofNullable(flow);
      return this;
    }

    public Builder flow(Nullable<String> flow) {
      if (flow.isNull()) {
        this.flow = null;
      }
      else if (flow.isEmpty()) {
        this.flow = Optional.empty();
      }
      else {
        this.flow = Optional.of(flow.get());
      }
      return this;
    }

    /**
     * <p>Whether the evaluation succeeded.</p>
     */
    @JsonSetter(
        value = "status",
        nulls = Nulls.SKIP
    )
    public Builder status(Optional<CascadeResultStatus> status) {
      this.status = status;
      return this;
    }

    public Builder status(CascadeResultStatus status) {
      this.status = Optional.ofNullable(status);
      return this;
    }

    /**
     * <p>The evaluation output.</p>
     */
    @JsonSetter(
        value = "result",
        nulls = Nulls.SKIP
    )
    public Builder result(Optional<Map<String, Object>> result) {
      this.result = result;
      return this;
    }

    public Builder result(Map<String, Object> result) {
      this.result = Optional.ofNullable(result);
      return this;
    }

    /**
     * <p>Whether this was auto-executed (true) or from a registered pending evaluation (false).</p>
     */
    @JsonSetter(
        value = "auto_executed",
        nulls = Nulls.SKIP
    )
    public Builder autoExecuted(Optional<Boolean> autoExecuted) {
      this.autoExecuted = autoExecuted;
      return this;
    }

    public Builder autoExecuted(Boolean autoExecuted) {
      this.autoExecuted = Optional.ofNullable(autoExecuted);
      return this;
    }

    /**
     * <p>List of field keys written back to the context (for rule evaluations).</p>
     */
    @JsonSetter(
        value = "written_to_context",
        nulls = Nulls.SKIP
    )
    public Builder writtenToContext(Optional<List<String>> writtenToContext) {
      this.writtenToContext = writtenToContext;
      return this;
    }

    public Builder writtenToContext(List<String> writtenToContext) {
      this.writtenToContext = Optional.ofNullable(writtenToContext);
      return this;
    }

    /**
     * <p>Error message if the evaluation failed.</p>
     */
    @JsonSetter(
        value = "error",
        nulls = Nulls.SKIP
    )
    public Builder error(Optional<String> error) {
      this.error = error;
      return this;
    }

    public Builder error(String error) {
      this.error = Optional.ofNullable(error);
      return this;
    }

    public Builder error(Nullable<String> error) {
      if (error.isNull()) {
        this.error = null;
      }
      else if (error.isEmpty()) {
        this.error = Optional.empty();
      }
      else {
        this.error = Optional.of(error.get());
      }
      return this;
    }

    public CascadeResult build() {
      return new CascadeResult(context, rule, flow, status, result, autoExecuted, writtenToContext, error, additionalProperties);
    }
  }
}
