/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ContextDetail.Builder.class
)
public final class ContextDetail implements IContextBase {
  private final Optional<String> id;

  private final Optional<String> name;

  private final Optional<String> slug;

  private final Optional<String> description;

  private final Optional<Boolean> autoExecuteDecisions;

  private final Optional<Integer> ttlSeconds;

  private final Optional<Integer> historyLimit;

  private final Optional<ContextBaseOnSchemaMismatch> onSchemaMismatch;

  private final Optional<String> webhookOnSolve;

  private final Optional<String> webhookOnExpire;

  private final Optional<ContextSchema> schema;

  private final Optional<String> identityFact;

  private final Optional<List<String>> userGroups;

  private final Optional<ContextDetailFolder> folder;

  private final Optional<List<ContextDetailBoundRulesItem>> boundRules;

  private final Optional<List<ContextDetailBoundFlowsItem>> boundFlows;

  private final Optional<ContextDetailRelationships> relationships;

  private final Optional<OffsetDateTime> createdAt;

  private final Optional<OffsetDateTime> updatedAt;

  private final Map<String, Object> additionalProperties;

  private ContextDetail(Optional<String> id, Optional<String> name, Optional<String> slug,
      Optional<String> description, Optional<Boolean> autoExecuteDecisions,
      Optional<Integer> ttlSeconds, Optional<Integer> historyLimit,
      Optional<ContextBaseOnSchemaMismatch> onSchemaMismatch, Optional<String> webhookOnSolve,
      Optional<String> webhookOnExpire, Optional<ContextSchema> schema,
      Optional<String> identityFact, Optional<List<String>> userGroups,
      Optional<ContextDetailFolder> folder, Optional<List<ContextDetailBoundRulesItem>> boundRules,
      Optional<List<ContextDetailBoundFlowsItem>> boundFlows,
      Optional<ContextDetailRelationships> relationships, Optional<OffsetDateTime> createdAt,
      Optional<OffsetDateTime> updatedAt, Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.slug = slug;
    this.description = description;
    this.autoExecuteDecisions = autoExecuteDecisions;
    this.ttlSeconds = ttlSeconds;
    this.historyLimit = historyLimit;
    this.onSchemaMismatch = onSchemaMismatch;
    this.webhookOnSolve = webhookOnSolve;
    this.webhookOnExpire = webhookOnExpire;
    this.schema = schema;
    this.identityFact = identityFact;
    this.userGroups = userGroups;
    this.folder = folder;
    this.boundRules = boundRules;
    this.boundFlows = boundFlows;
    this.relationships = relationships;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The unique identifier for the context.
   */
  @JsonProperty("id")
  @java.lang.Override
  public Optional<String> getId() {
    return id;
  }

  /**
   * @return The name of the context.
   */
  @JsonProperty("name")
  @java.lang.Override
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return The unique slug for the context used in API requests.
   */
  @JsonProperty("slug")
  @java.lang.Override
  public Optional<String> getSlug() {
    return slug;
  }

  /**
   * @return The description of the context.
   */
  @JsonProperty("description")
  @java.lang.Override
  public Optional<String> getDescription() {
    return description;
  }

  /**
   * @return When true, bound rules and flows automatically execute when their inputs are satisfied. When false, users must manually call /solve or /flows endpoints.
   */
  @JsonProperty("auto_execute_decisions")
  @java.lang.Override
  public Optional<Boolean> getAutoExecuteDecisions() {
    return autoExecuteDecisions;
  }

  /**
   * @return Time-to-live in seconds for live context instances. Instances expire after this duration.
   */
  @JsonIgnore
  @java.lang.Override
  public Optional<Integer> getTtlSeconds() {
    if (ttlSeconds == null) {
      return Optional.empty();
    }
    return ttlSeconds;
  }

  /**
   * @return Maximum number of history entries to retain per field.
   */
  @JsonProperty("history_limit")
  @java.lang.Override
  public Optional<Integer> getHistoryLimit() {
    return historyLimit;
  }

  /**
   * @return How to handle fields that don't match the schema: 'ignore' filters them out, 'reject' returns an error.
   */
  @JsonProperty("on_schema_mismatch")
  public Optional<ContextBaseOnSchemaMismatch> getOnSchemaMismatch() {
    return onSchemaMismatch;
  }

  /**
   * @return Webhook URL called when a rule or flow successfully solves for a live context.
   */
  @JsonIgnore
  @java.lang.Override
  public Optional<String> getWebhookOnSolve() {
    if (webhookOnSolve == null) {
      return Optional.empty();
    }
    return webhookOnSolve;
  }

  /**
   * @return Webhook URL called when a live context expires due to TTL.
   */
  @JsonIgnore
  @java.lang.Override
  public Optional<String> getWebhookOnExpire() {
    if (webhookOnExpire == null) {
      return Optional.empty();
    }
    return webhookOnExpire;
  }

  @JsonProperty("schema")
  public Optional<ContextSchema> getSchema() {
    return schema;
  }

  /**
   * @return The field key used as the unique identifier for instances.
   */
  @JsonIgnore
  public Optional<String> getIdentityFact() {
    if (identityFact == null) {
      return Optional.empty();
    }
    return identityFact;
  }

  /**
   * @return User groups that can interact with this context.
   */
  @JsonIgnore
  public Optional<List<String>> getUserGroups() {
    if (userGroups == null) {
      return Optional.empty();
    }
    return userGroups;
  }

  /**
   * @return Folder/tag this context belongs to.
   */
  @JsonIgnore
  public Optional<ContextDetailFolder> getFolder() {
    if (folder == null) {
      return Optional.empty();
    }
    return folder;
  }

  /**
   * @return Rules bound to this context.
   */
  @JsonProperty("bound_rules")
  public Optional<List<ContextDetailBoundRulesItem>> getBoundRules() {
    return boundRules;
  }

  /**
   * @return Flows bound to this context (via their origin rule).
   */
  @JsonProperty("bound_flows")
  public Optional<List<ContextDetailBoundFlowsItem>> getBoundFlows() {
    return boundFlows;
  }

  @JsonProperty("relationships")
  public Optional<ContextDetailRelationships> getRelationships() {
    return relationships;
  }

  /**
   * @return When the context was created.
   */
  @JsonProperty("created_at")
  public Optional<OffsetDateTime> getCreatedAt() {
    return createdAt;
  }

  /**
   * @return When the context was last updated.
   */
  @JsonProperty("updated_at")
  public Optional<OffsetDateTime> getUpdatedAt() {
    return updatedAt;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("ttl_seconds")
  private Optional<Integer> _getTtlSeconds() {
    return ttlSeconds;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("webhook_on_solve")
  private Optional<String> _getWebhookOnSolve() {
    return webhookOnSolve;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("webhook_on_expire")
  private Optional<String> _getWebhookOnExpire() {
    return webhookOnExpire;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("identity_fact")
  private Optional<String> _getIdentityFact() {
    return identityFact;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("user_groups")
  private Optional<List<String>> _getUserGroups() {
    return userGroups;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("folder")
  private Optional<ContextDetailFolder> _getFolder() {
    return folder;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ContextDetail && equalTo((ContextDetail) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ContextDetail other) {
    return id.equals(other.id) && name.equals(other.name) && slug.equals(other.slug) && description.equals(other.description) && autoExecuteDecisions.equals(other.autoExecuteDecisions) && ttlSeconds.equals(other.ttlSeconds) && historyLimit.equals(other.historyLimit) && onSchemaMismatch.equals(other.onSchemaMismatch) && webhookOnSolve.equals(other.webhookOnSolve) && webhookOnExpire.equals(other.webhookOnExpire) && schema.equals(other.schema) && identityFact.equals(other.identityFact) && userGroups.equals(other.userGroups) && folder.equals(other.folder) && boundRules.equals(other.boundRules) && boundFlows.equals(other.boundFlows) && relationships.equals(other.relationships) && createdAt.equals(other.createdAt) && updatedAt.equals(other.updatedAt);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.slug, this.description, this.autoExecuteDecisions, this.ttlSeconds, this.historyLimit, this.onSchemaMismatch, this.webhookOnSolve, this.webhookOnExpire, this.schema, this.identityFact, this.userGroups, this.folder, this.boundRules, this.boundFlows, this.relationships, this.createdAt, this.updatedAt);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> id = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> slug = Optional.empty();

    private Optional<String> description = Optional.empty();

    private Optional<Boolean> autoExecuteDecisions = Optional.empty();

    private Optional<Integer> ttlSeconds = Optional.empty();

    private Optional<Integer> historyLimit = Optional.empty();

    private Optional<ContextBaseOnSchemaMismatch> onSchemaMismatch = Optional.empty();

    private Optional<String> webhookOnSolve = Optional.empty();

    private Optional<String> webhookOnExpire = Optional.empty();

    private Optional<ContextSchema> schema = Optional.empty();

    private Optional<String> identityFact = Optional.empty();

    private Optional<List<String>> userGroups = Optional.empty();

    private Optional<ContextDetailFolder> folder = Optional.empty();

    private Optional<List<ContextDetailBoundRulesItem>> boundRules = Optional.empty();

    private Optional<List<ContextDetailBoundFlowsItem>> boundFlows = Optional.empty();

    private Optional<ContextDetailRelationships> relationships = Optional.empty();

    private Optional<OffsetDateTime> createdAt = Optional.empty();

    private Optional<OffsetDateTime> updatedAt = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ContextDetail other) {
      id(other.getId());
      name(other.getName());
      slug(other.getSlug());
      description(other.getDescription());
      autoExecuteDecisions(other.getAutoExecuteDecisions());
      ttlSeconds(other.getTtlSeconds());
      historyLimit(other.getHistoryLimit());
      onSchemaMismatch(other.getOnSchemaMismatch());
      webhookOnSolve(other.getWebhookOnSolve());
      webhookOnExpire(other.getWebhookOnExpire());
      schema(other.getSchema());
      identityFact(other.getIdentityFact());
      userGroups(other.getUserGroups());
      folder(other.getFolder());
      boundRules(other.getBoundRules());
      boundFlows(other.getBoundFlows());
      relationships(other.getRelationships());
      createdAt(other.getCreatedAt());
      updatedAt(other.getUpdatedAt());
      return this;
    }

    /**
     * <p>The unique identifier for the context.</p>
     */
    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public Builder id(Optional<String> id) {
      this.id = id;
      return this;
    }

    public Builder id(String id) {
      this.id = Optional.ofNullable(id);
      return this;
    }

    /**
     * <p>The name of the context.</p>
     */
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    /**
     * <p>The unique slug for the context used in API requests.</p>
     */
    @JsonSetter(
        value = "slug",
        nulls = Nulls.SKIP
    )
    public Builder slug(Optional<String> slug) {
      this.slug = slug;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = Optional.ofNullable(slug);
      return this;
    }

    /**
     * <p>The description of the context.</p>
     */
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public Builder description(Optional<String> description) {
      this.description = description;
      return this;
    }

    public Builder description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    /**
     * <p>When true, bound rules and flows automatically execute when their inputs are satisfied. When false, users must manually call /solve or /flows endpoints.</p>
     */
    @JsonSetter(
        value = "auto_execute_decisions",
        nulls = Nulls.SKIP
    )
    public Builder autoExecuteDecisions(Optional<Boolean> autoExecuteDecisions) {
      this.autoExecuteDecisions = autoExecuteDecisions;
      return this;
    }

    public Builder autoExecuteDecisions(Boolean autoExecuteDecisions) {
      this.autoExecuteDecisions = Optional.ofNullable(autoExecuteDecisions);
      return this;
    }

    /**
     * <p>Time-to-live in seconds for live context instances. Instances expire after this duration.</p>
     */
    @JsonSetter(
        value = "ttl_seconds",
        nulls = Nulls.SKIP
    )
    public Builder ttlSeconds(Optional<Integer> ttlSeconds) {
      this.ttlSeconds = ttlSeconds;
      return this;
    }

    public Builder ttlSeconds(Integer ttlSeconds) {
      this.ttlSeconds = Optional.ofNullable(ttlSeconds);
      return this;
    }

    public Builder ttlSeconds(Nullable<Integer> ttlSeconds) {
      if (ttlSeconds.isNull()) {
        this.ttlSeconds = null;
      }
      else if (ttlSeconds.isEmpty()) {
        this.ttlSeconds = Optional.empty();
      }
      else {
        this.ttlSeconds = Optional.of(ttlSeconds.get());
      }
      return this;
    }

    /**
     * <p>Maximum number of history entries to retain per field.</p>
     */
    @JsonSetter(
        value = "history_limit",
        nulls = Nulls.SKIP
    )
    public Builder historyLimit(Optional<Integer> historyLimit) {
      this.historyLimit = historyLimit;
      return this;
    }

    public Builder historyLimit(Integer historyLimit) {
      this.historyLimit = Optional.ofNullable(historyLimit);
      return this;
    }

    /**
     * <p>How to handle fields that don't match the schema: 'ignore' filters them out, 'reject' returns an error.</p>
     */
    @JsonSetter(
        value = "on_schema_mismatch",
        nulls = Nulls.SKIP
    )
    public Builder onSchemaMismatch(Optional<ContextBaseOnSchemaMismatch> onSchemaMismatch) {
      this.onSchemaMismatch = onSchemaMismatch;
      return this;
    }

    public Builder onSchemaMismatch(ContextBaseOnSchemaMismatch onSchemaMismatch) {
      this.onSchemaMismatch = Optional.ofNullable(onSchemaMismatch);
      return this;
    }

    /**
     * <p>Webhook URL called when a rule or flow successfully solves for a live context.</p>
     */
    @JsonSetter(
        value = "webhook_on_solve",
        nulls = Nulls.SKIP
    )
    public Builder webhookOnSolve(Optional<String> webhookOnSolve) {
      this.webhookOnSolve = webhookOnSolve;
      return this;
    }

    public Builder webhookOnSolve(String webhookOnSolve) {
      this.webhookOnSolve = Optional.ofNullable(webhookOnSolve);
      return this;
    }

    public Builder webhookOnSolve(Nullable<String> webhookOnSolve) {
      if (webhookOnSolve.isNull()) {
        this.webhookOnSolve = null;
      }
      else if (webhookOnSolve.isEmpty()) {
        this.webhookOnSolve = Optional.empty();
      }
      else {
        this.webhookOnSolve = Optional.of(webhookOnSolve.get());
      }
      return this;
    }

    /**
     * <p>Webhook URL called when a live context expires due to TTL.</p>
     */
    @JsonSetter(
        value = "webhook_on_expire",
        nulls = Nulls.SKIP
    )
    public Builder webhookOnExpire(Optional<String> webhookOnExpire) {
      this.webhookOnExpire = webhookOnExpire;
      return this;
    }

    public Builder webhookOnExpire(String webhookOnExpire) {
      this.webhookOnExpire = Optional.ofNullable(webhookOnExpire);
      return this;
    }

    public Builder webhookOnExpire(Nullable<String> webhookOnExpire) {
      if (webhookOnExpire.isNull()) {
        this.webhookOnExpire = null;
      }
      else if (webhookOnExpire.isEmpty()) {
        this.webhookOnExpire = Optional.empty();
      }
      else {
        this.webhookOnExpire = Optional.of(webhookOnExpire.get());
      }
      return this;
    }

    @JsonSetter(
        value = "schema",
        nulls = Nulls.SKIP
    )
    public Builder schema(Optional<ContextSchema> schema) {
      this.schema = schema;
      return this;
    }

    public Builder schema(ContextSchema schema) {
      this.schema = Optional.ofNullable(schema);
      return this;
    }

    /**
     * <p>The field key used as the unique identifier for instances.</p>
     */
    @JsonSetter(
        value = "identity_fact",
        nulls = Nulls.SKIP
    )
    public Builder identityFact(Optional<String> identityFact) {
      this.identityFact = identityFact;
      return this;
    }

    public Builder identityFact(String identityFact) {
      this.identityFact = Optional.ofNullable(identityFact);
      return this;
    }

    public Builder identityFact(Nullable<String> identityFact) {
      if (identityFact.isNull()) {
        this.identityFact = null;
      }
      else if (identityFact.isEmpty()) {
        this.identityFact = Optional.empty();
      }
      else {
        this.identityFact = Optional.of(identityFact.get());
      }
      return this;
    }

    /**
     * <p>User groups that can interact with this context.</p>
     */
    @JsonSetter(
        value = "user_groups",
        nulls = Nulls.SKIP
    )
    public Builder userGroups(Optional<List<String>> userGroups) {
      this.userGroups = userGroups;
      return this;
    }

    public Builder userGroups(List<String> userGroups) {
      this.userGroups = Optional.ofNullable(userGroups);
      return this;
    }

    public Builder userGroups(Nullable<List<String>> userGroups) {
      if (userGroups.isNull()) {
        this.userGroups = null;
      }
      else if (userGroups.isEmpty()) {
        this.userGroups = Optional.empty();
      }
      else {
        this.userGroups = Optional.of(userGroups.get());
      }
      return this;
    }

    /**
     * <p>Folder/tag this context belongs to.</p>
     */
    @JsonSetter(
        value = "folder",
        nulls = Nulls.SKIP
    )
    public Builder folder(Optional<ContextDetailFolder> folder) {
      this.folder = folder;
      return this;
    }

    public Builder folder(ContextDetailFolder folder) {
      this.folder = Optional.ofNullable(folder);
      return this;
    }

    public Builder folder(Nullable<ContextDetailFolder> folder) {
      if (folder.isNull()) {
        this.folder = null;
      }
      else if (folder.isEmpty()) {
        this.folder = Optional.empty();
      }
      else {
        this.folder = Optional.of(folder.get());
      }
      return this;
    }

    /**
     * <p>Rules bound to this context.</p>
     */
    @JsonSetter(
        value = "bound_rules",
        nulls = Nulls.SKIP
    )
    public Builder boundRules(Optional<List<ContextDetailBoundRulesItem>> boundRules) {
      this.boundRules = boundRules;
      return this;
    }

    public Builder boundRules(List<ContextDetailBoundRulesItem> boundRules) {
      this.boundRules = Optional.ofNullable(boundRules);
      return this;
    }

    /**
     * <p>Flows bound to this context (via their origin rule).</p>
     */
    @JsonSetter(
        value = "bound_flows",
        nulls = Nulls.SKIP
    )
    public Builder boundFlows(Optional<List<ContextDetailBoundFlowsItem>> boundFlows) {
      this.boundFlows = boundFlows;
      return this;
    }

    public Builder boundFlows(List<ContextDetailBoundFlowsItem> boundFlows) {
      this.boundFlows = Optional.ofNullable(boundFlows);
      return this;
    }

    @JsonSetter(
        value = "relationships",
        nulls = Nulls.SKIP
    )
    public Builder relationships(Optional<ContextDetailRelationships> relationships) {
      this.relationships = relationships;
      return this;
    }

    public Builder relationships(ContextDetailRelationships relationships) {
      this.relationships = Optional.ofNullable(relationships);
      return this;
    }

    /**
     * <p>When the context was created.</p>
     */
    @JsonSetter(
        value = "created_at",
        nulls = Nulls.SKIP
    )
    public Builder createdAt(Optional<OffsetDateTime> createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = Optional.ofNullable(createdAt);
      return this;
    }

    /**
     * <p>When the context was last updated.</p>
     */
    @JsonSetter(
        value = "updated_at",
        nulls = Nulls.SKIP
    )
    public Builder updatedAt(Optional<OffsetDateTime> updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    public Builder updatedAt(OffsetDateTime updatedAt) {
      this.updatedAt = Optional.ofNullable(updatedAt);
      return this;
    }

    public ContextDetail build() {
      return new ContextDetail(id, name, slug, description, autoExecuteDecisions, ttlSeconds, historyLimit, onSchemaMismatch, webhookOnSolve, webhookOnExpire, schema, identityFact, userGroups, folder, boundRules, boundFlows, relationships, createdAt, updatedAt, additionalProperties);
    }
  }
}
