/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ContextInstanceHistoryEntry.Builder.class
)
public final class ContextInstanceHistoryEntry {
  private final Optional<OffsetDateTime> timestamp;

  private final Optional<Object> value;

  private final Map<String, Object> additionalProperties;

  private ContextInstanceHistoryEntry(Optional<OffsetDateTime> timestamp, Optional<Object> value,
      Map<String, Object> additionalProperties) {
    this.timestamp = timestamp;
    this.value = value;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return When this value was recorded.
   */
  @JsonProperty("timestamp")
  public Optional<OffsetDateTime> getTimestamp() {
    return timestamp;
  }

  /**
   * @return The field value at this point in time.
   */
  @JsonProperty("value")
  public Optional<Object> getValue() {
    return value;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ContextInstanceHistoryEntry && equalTo((ContextInstanceHistoryEntry) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ContextInstanceHistoryEntry other) {
    return timestamp.equals(other.timestamp) && value.equals(other.value);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.timestamp, this.value);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<OffsetDateTime> timestamp = Optional.empty();

    private Optional<Object> value = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ContextInstanceHistoryEntry other) {
      timestamp(other.getTimestamp());
      value(other.getValue());
      return this;
    }

    /**
     * <p>When this value was recorded.</p>
     */
    @JsonSetter(
        value = "timestamp",
        nulls = Nulls.SKIP
    )
    public Builder timestamp(Optional<OffsetDateTime> timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    public Builder timestamp(OffsetDateTime timestamp) {
      this.timestamp = Optional.ofNullable(timestamp);
      return this;
    }

    /**
     * <p>The field value at this point in time.</p>
     */
    @JsonSetter(
        value = "value",
        nulls = Nulls.SKIP
    )
    public Builder value(Optional<Object> value) {
      this.value = value;
      return this;
    }

    public Builder value(Object value) {
      this.value = Optional.ofNullable(value);
      return this;
    }

    public ContextInstanceHistoryEntry build() {
      return new ContextInstanceHistoryEntry(timestamp, value, additionalProperties);
    }
  }
}
