/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ContextInstancePendingEvaluation.Builder.class
)
public final class ContextInstancePendingEvaluation {
  private final Optional<ContextInstancePendingEvaluationType> type;

  private final Optional<String> rule;

  private final Optional<String> ruleId;

  private final Optional<String> flow;

  private final Optional<String> flowId;

  private final Optional<List<ContextInstancePendingEvaluationWaitingOnItem>> waitingOn;

  private final Optional<OffsetDateTime> createdAt;

  private final Optional<OffsetDateTime> expiresAt;

  private final Map<String, Object> additionalProperties;

  private ContextInstancePendingEvaluation(Optional<ContextInstancePendingEvaluationType> type,
      Optional<String> rule, Optional<String> ruleId, Optional<String> flow,
      Optional<String> flowId,
      Optional<List<ContextInstancePendingEvaluationWaitingOnItem>> waitingOn,
      Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> expiresAt,
      Map<String, Object> additionalProperties) {
    this.type = type;
    this.rule = rule;
    this.ruleId = ruleId;
    this.flow = flow;
    this.flowId = flowId;
    this.waitingOn = waitingOn;
    this.createdAt = createdAt;
    this.expiresAt = expiresAt;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Whether this is a rule or flow evaluation.
   */
  @JsonProperty("type")
  public Optional<ContextInstancePendingEvaluationType> getType() {
    return type;
  }

  /**
   * @return The rule slug (if type is 'rule').
   */
  @JsonIgnore
  public Optional<String> getRule() {
    if (rule == null) {
      return Optional.empty();
    }
    return rule;
  }

  /**
   * @return The rule ID (if type is 'rule').
   */
  @JsonIgnore
  public Optional<String> getRuleId() {
    if (ruleId == null) {
      return Optional.empty();
    }
    return ruleId;
  }

  /**
   * @return The flow slug (if type is 'flow').
   */
  @JsonIgnore
  public Optional<String> getFlow() {
    if (flow == null) {
      return Optional.empty();
    }
    return flow;
  }

  /**
   * @return The flow ID (if type is 'flow').
   */
  @JsonIgnore
  public Optional<String> getFlowId() {
    if (flowId == null) {
      return Optional.empty();
    }
    return flowId;
  }

  /**
   * @return List of field keys or dependency objects this evaluation is waiting for. Can contain simple strings for direct fields or objects for relationship dependencies.
   */
  @JsonProperty("waiting_on")
  public Optional<List<ContextInstancePendingEvaluationWaitingOnItem>> getWaitingOn() {
    return waitingOn;
  }

  /**
   * @return When this pending evaluation was registered.
   */
  @JsonProperty("created_at")
  public Optional<OffsetDateTime> getCreatedAt() {
    return createdAt;
  }

  /**
   * @return When this pending evaluation will expire.
   */
  @JsonProperty("expires_at")
  public Optional<OffsetDateTime> getExpiresAt() {
    return expiresAt;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("rule")
  private Optional<String> _getRule() {
    return rule;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("rule_id")
  private Optional<String> _getRuleId() {
    return ruleId;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("flow")
  private Optional<String> _getFlow() {
    return flow;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("flow_id")
  private Optional<String> _getFlowId() {
    return flowId;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ContextInstancePendingEvaluation && equalTo((ContextInstancePendingEvaluation) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ContextInstancePendingEvaluation other) {
    return type.equals(other.type) && rule.equals(other.rule) && ruleId.equals(other.ruleId) && flow.equals(other.flow) && flowId.equals(other.flowId) && waitingOn.equals(other.waitingOn) && createdAt.equals(other.createdAt) && expiresAt.equals(other.expiresAt);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.type, this.rule, this.ruleId, this.flow, this.flowId, this.waitingOn, this.createdAt, this.expiresAt);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<ContextInstancePendingEvaluationType> type = Optional.empty();

    private Optional<String> rule = Optional.empty();

    private Optional<String> ruleId = Optional.empty();

    private Optional<String> flow = Optional.empty();

    private Optional<String> flowId = Optional.empty();

    private Optional<List<ContextInstancePendingEvaluationWaitingOnItem>> waitingOn = Optional.empty();

    private Optional<OffsetDateTime> createdAt = Optional.empty();

    private Optional<OffsetDateTime> expiresAt = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ContextInstancePendingEvaluation other) {
      type(other.getType());
      rule(other.getRule());
      ruleId(other.getRuleId());
      flow(other.getFlow());
      flowId(other.getFlowId());
      waitingOn(other.getWaitingOn());
      createdAt(other.getCreatedAt());
      expiresAt(other.getExpiresAt());
      return this;
    }

    /**
     * <p>Whether this is a rule or flow evaluation.</p>
     */
    @JsonSetter(
        value = "type",
        nulls = Nulls.SKIP
    )
    public Builder type(Optional<ContextInstancePendingEvaluationType> type) {
      this.type = type;
      return this;
    }

    public Builder type(ContextInstancePendingEvaluationType type) {
      this.type = Optional.ofNullable(type);
      return this;
    }

    /**
     * <p>The rule slug (if type is 'rule').</p>
     */
    @JsonSetter(
        value = "rule",
        nulls = Nulls.SKIP
    )
    public Builder rule(Optional<String> rule) {
      this.rule = rule;
      return this;
    }

    public Builder rule(String rule) {
      this.rule = Optional.ofNullable(rule);
      return this;
    }

    public Builder rule(Nullable<String> rule) {
      if (rule.isNull()) {
        this.rule = null;
      }
      else if (rule.isEmpty()) {
        this.rule = Optional.empty();
      }
      else {
        this.rule = Optional.of(rule.get());
      }
      return this;
    }

    /**
     * <p>The rule ID (if type is 'rule').</p>
     */
    @JsonSetter(
        value = "rule_id",
        nulls = Nulls.SKIP
    )
    public Builder ruleId(Optional<String> ruleId) {
      this.ruleId = ruleId;
      return this;
    }

    public Builder ruleId(String ruleId) {
      this.ruleId = Optional.ofNullable(ruleId);
      return this;
    }

    public Builder ruleId(Nullable<String> ruleId) {
      if (ruleId.isNull()) {
        this.ruleId = null;
      }
      else if (ruleId.isEmpty()) {
        this.ruleId = Optional.empty();
      }
      else {
        this.ruleId = Optional.of(ruleId.get());
      }
      return this;
    }

    /**
     * <p>The flow slug (if type is 'flow').</p>
     */
    @JsonSetter(
        value = "flow",
        nulls = Nulls.SKIP
    )
    public Builder flow(Optional<String> flow) {
      this.flow = flow;
      return this;
    }

    public Builder flow(String flow) {
      this.flow = Optional.ofNullable(flow);
      return this;
    }

    public Builder flow(Nullable<String> flow) {
      if (flow.isNull()) {
        this.flow = null;
      }
      else if (flow.isEmpty()) {
        this.flow = Optional.empty();
      }
      else {
        this.flow = Optional.of(flow.get());
      }
      return this;
    }

    /**
     * <p>The flow ID (if type is 'flow').</p>
     */
    @JsonSetter(
        value = "flow_id",
        nulls = Nulls.SKIP
    )
    public Builder flowId(Optional<String> flowId) {
      this.flowId = flowId;
      return this;
    }

    public Builder flowId(String flowId) {
      this.flowId = Optional.ofNullable(flowId);
      return this;
    }

    public Builder flowId(Nullable<String> flowId) {
      if (flowId.isNull()) {
        this.flowId = null;
      }
      else if (flowId.isEmpty()) {
        this.flowId = Optional.empty();
      }
      else {
        this.flowId = Optional.of(flowId.get());
      }
      return this;
    }

    /**
     * <p>List of field keys or dependency objects this evaluation is waiting for. Can contain simple strings for direct fields or objects for relationship dependencies.</p>
     */
    @JsonSetter(
        value = "waiting_on",
        nulls = Nulls.SKIP
    )
    public Builder waitingOn(
        Optional<List<ContextInstancePendingEvaluationWaitingOnItem>> waitingOn) {
      this.waitingOn = waitingOn;
      return this;
    }

    public Builder waitingOn(List<ContextInstancePendingEvaluationWaitingOnItem> waitingOn) {
      this.waitingOn = Optional.ofNullable(waitingOn);
      return this;
    }

    /**
     * <p>When this pending evaluation was registered.</p>
     */
    @JsonSetter(
        value = "created_at",
        nulls = Nulls.SKIP
    )
    public Builder createdAt(Optional<OffsetDateTime> createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = Optional.ofNullable(createdAt);
      return this;
    }

    /**
     * <p>When this pending evaluation will expire.</p>
     */
    @JsonSetter(
        value = "expires_at",
        nulls = Nulls.SKIP
    )
    public Builder expiresAt(Optional<OffsetDateTime> expiresAt) {
      this.expiresAt = expiresAt;
      return this;
    }

    public Builder expiresAt(OffsetDateTime expiresAt) {
      this.expiresAt = Optional.ofNullable(expiresAt);
      return this;
    }

    public ContextInstancePendingEvaluation build() {
      return new ContextInstancePendingEvaluation(type, rule, ruleId, flow, flowId, waitingOn, createdAt, expiresAt, additionalProperties);
    }
  }
}
