/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ContextInstancePendingEvaluationWaitingOnItemField.Builder.class
)
public final class ContextInstancePendingEvaluationWaitingOnItemField {
  private final Optional<String> field;

  private final Optional<String> relation;

  private final Optional<String> instance;

  private final Map<String, Object> additionalProperties;

  private ContextInstancePendingEvaluationWaitingOnItemField(Optional<String> field,
      Optional<String> relation, Optional<String> instance,
      Map<String, Object> additionalProperties) {
    this.field = field;
    this.relation = relation;
    this.instance = instance;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Field key this evaluation is waiting for.
   */
  @JsonProperty("field")
  public Optional<String> getField() {
    return field;
  }

  /**
   * @return Related context name if waiting on a relationship.
   */
  @JsonProperty("relation")
  public Optional<String> getRelation() {
    return relation;
  }

  /**
   * @return Instance ID of the related context (if applicable).
   */
  @JsonProperty("instance")
  public Optional<String> getInstance() {
    return instance;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ContextInstancePendingEvaluationWaitingOnItemField && equalTo((ContextInstancePendingEvaluationWaitingOnItemField) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ContextInstancePendingEvaluationWaitingOnItemField other) {
    return field.equals(other.field) && relation.equals(other.relation) && instance.equals(other.instance);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.field, this.relation, this.instance);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> field = Optional.empty();

    private Optional<String> relation = Optional.empty();

    private Optional<String> instance = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ContextInstancePendingEvaluationWaitingOnItemField other) {
      field(other.getField());
      relation(other.getRelation());
      instance(other.getInstance());
      return this;
    }

    /**
     * <p>Field key this evaluation is waiting for.</p>
     */
    @JsonSetter(
        value = "field",
        nulls = Nulls.SKIP
    )
    public Builder field(Optional<String> field) {
      this.field = field;
      return this;
    }

    public Builder field(String field) {
      this.field = Optional.ofNullable(field);
      return this;
    }

    /**
     * <p>Related context name if waiting on a relationship.</p>
     */
    @JsonSetter(
        value = "relation",
        nulls = Nulls.SKIP
    )
    public Builder relation(Optional<String> relation) {
      this.relation = relation;
      return this;
    }

    public Builder relation(String relation) {
      this.relation = Optional.ofNullable(relation);
      return this;
    }

    /**
     * <p>Instance ID of the related context (if applicable).</p>
     */
    @JsonSetter(
        value = "instance",
        nulls = Nulls.SKIP
    )
    public Builder instance(Optional<String> instance) {
      this.instance = instance;
      return this;
    }

    public Builder instance(String instance) {
      this.instance = Optional.ofNullable(instance);
      return this;
    }

    public ContextInstancePendingEvaluationWaitingOnItemField build() {
      return new ContextInstancePendingEvaluationWaitingOnItemField(field, relation, instance, additionalProperties);
    }
  }
}
