/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ContextInstanceState.Builder.class
)
public final class ContextInstanceState {
  private final Optional<String> context;

  private final Optional<Map<String, Object>> state;

  private final Optional<Map<String, Object>> derived;

  private final Optional<ContextInstanceStateStatus> status;

  private final Optional<List<String>> have;

  private final Optional<List<String>> need;

  private final Optional<OffsetDateTime> createdAt;

  private final Optional<OffsetDateTime> updatedAt;

  private final Optional<OffsetDateTime> expiresAt;

  private final Map<String, Object> additionalProperties;

  private ContextInstanceState(Optional<String> context, Optional<Map<String, Object>> state,
      Optional<Map<String, Object>> derived, Optional<ContextInstanceStateStatus> status,
      Optional<List<String>> have, Optional<List<String>> need, Optional<OffsetDateTime> createdAt,
      Optional<OffsetDateTime> updatedAt, Optional<OffsetDateTime> expiresAt,
      Map<String, Object> additionalProperties) {
    this.context = context;
    this.state = state;
    this.derived = derived;
    this.status = status;
    this.have = have;
    this.need = need;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.expiresAt = expiresAt;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Combined identifier in format 'contextSlug:instanceId'.
   */
  @JsonProperty("context")
  public Optional<String> getContext() {
    return context;
  }

  /**
   * @return The current base field values for this instance.
   */
  @JsonProperty("state")
  public Optional<Map<String, Object>> getState() {
    return state;
  }

  /**
   * @return Computed/derived field values from bound rules.
   */
  @JsonProperty("derived")
  public Optional<Map<String, Object>> getDerived() {
    return derived;
  }

  /**
   * @return Whether all required fields are present ('complete') or some are missing ('pending').
   */
  @JsonProperty("status")
  public Optional<ContextInstanceStateStatus> getStatus() {
    return status;
  }

  /**
   * @return List of field keys that are currently populated.
   */
  @JsonProperty("have")
  public Optional<List<String>> getHave() {
    return have;
  }

  /**
   * @return List of required field keys that are missing (empty when status is 'complete').
   */
  @JsonProperty("need")
  public Optional<List<String>> getNeed() {
    return need;
  }

  /**
   * @return When the instance was first created.
   */
  @JsonProperty("created_at")
  public Optional<OffsetDateTime> getCreatedAt() {
    return createdAt;
  }

  /**
   * @return When the instance was last updated.
   */
  @JsonProperty("updated_at")
  public Optional<OffsetDateTime> getUpdatedAt() {
    return updatedAt;
  }

  /**
   * @return When the instance will expire based on context TTL.
   */
  @JsonIgnore
  public Optional<OffsetDateTime> getExpiresAt() {
    if (expiresAt == null) {
      return Optional.empty();
    }
    return expiresAt;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("expires_at")
  private Optional<OffsetDateTime> _getExpiresAt() {
    return expiresAt;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ContextInstanceState && equalTo((ContextInstanceState) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ContextInstanceState other) {
    return context.equals(other.context) && state.equals(other.state) && derived.equals(other.derived) && status.equals(other.status) && have.equals(other.have) && need.equals(other.need) && createdAt.equals(other.createdAt) && updatedAt.equals(other.updatedAt) && expiresAt.equals(other.expiresAt);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.context, this.state, this.derived, this.status, this.have, this.need, this.createdAt, this.updatedAt, this.expiresAt);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> context = Optional.empty();

    private Optional<Map<String, Object>> state = Optional.empty();

    private Optional<Map<String, Object>> derived = Optional.empty();

    private Optional<ContextInstanceStateStatus> status = Optional.empty();

    private Optional<List<String>> have = Optional.empty();

    private Optional<List<String>> need = Optional.empty();

    private Optional<OffsetDateTime> createdAt = Optional.empty();

    private Optional<OffsetDateTime> updatedAt = Optional.empty();

    private Optional<OffsetDateTime> expiresAt = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ContextInstanceState other) {
      context(other.getContext());
      state(other.getState());
      derived(other.getDerived());
      status(other.getStatus());
      have(other.getHave());
      need(other.getNeed());
      createdAt(other.getCreatedAt());
      updatedAt(other.getUpdatedAt());
      expiresAt(other.getExpiresAt());
      return this;
    }

    /**
     * <p>Combined identifier in format 'contextSlug:instanceId'.</p>
     */
    @JsonSetter(
        value = "context",
        nulls = Nulls.SKIP
    )
    public Builder context(Optional<String> context) {
      this.context = context;
      return this;
    }

    public Builder context(String context) {
      this.context = Optional.ofNullable(context);
      return this;
    }

    /**
     * <p>The current base field values for this instance.</p>
     */
    @JsonSetter(
        value = "state",
        nulls = Nulls.SKIP
    )
    public Builder state(Optional<Map<String, Object>> state) {
      this.state = state;
      return this;
    }

    public Builder state(Map<String, Object> state) {
      this.state = Optional.ofNullable(state);
      return this;
    }

    /**
     * <p>Computed/derived field values from bound rules.</p>
     */
    @JsonSetter(
        value = "derived",
        nulls = Nulls.SKIP
    )
    public Builder derived(Optional<Map<String, Object>> derived) {
      this.derived = derived;
      return this;
    }

    public Builder derived(Map<String, Object> derived) {
      this.derived = Optional.ofNullable(derived);
      return this;
    }

    /**
     * <p>Whether all required fields are present ('complete') or some are missing ('pending').</p>
     */
    @JsonSetter(
        value = "status",
        nulls = Nulls.SKIP
    )
    public Builder status(Optional<ContextInstanceStateStatus> status) {
      this.status = status;
      return this;
    }

    public Builder status(ContextInstanceStateStatus status) {
      this.status = Optional.ofNullable(status);
      return this;
    }

    /**
     * <p>List of field keys that are currently populated.</p>
     */
    @JsonSetter(
        value = "have",
        nulls = Nulls.SKIP
    )
    public Builder have(Optional<List<String>> have) {
      this.have = have;
      return this;
    }

    public Builder have(List<String> have) {
      this.have = Optional.ofNullable(have);
      return this;
    }

    /**
     * <p>List of required field keys that are missing (empty when status is 'complete').</p>
     */
    @JsonSetter(
        value = "need",
        nulls = Nulls.SKIP
    )
    public Builder need(Optional<List<String>> need) {
      this.need = need;
      return this;
    }

    public Builder need(List<String> need) {
      this.need = Optional.ofNullable(need);
      return this;
    }

    /**
     * <p>When the instance was first created.</p>
     */
    @JsonSetter(
        value = "created_at",
        nulls = Nulls.SKIP
    )
    public Builder createdAt(Optional<OffsetDateTime> createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = Optional.ofNullable(createdAt);
      return this;
    }

    /**
     * <p>When the instance was last updated.</p>
     */
    @JsonSetter(
        value = "updated_at",
        nulls = Nulls.SKIP
    )
    public Builder updatedAt(Optional<OffsetDateTime> updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    public Builder updatedAt(OffsetDateTime updatedAt) {
      this.updatedAt = Optional.ofNullable(updatedAt);
      return this;
    }

    /**
     * <p>When the instance will expire based on context TTL.</p>
     */
    @JsonSetter(
        value = "expires_at",
        nulls = Nulls.SKIP
    )
    public Builder expiresAt(Optional<OffsetDateTime> expiresAt) {
      this.expiresAt = expiresAt;
      return this;
    }

    public Builder expiresAt(OffsetDateTime expiresAt) {
      this.expiresAt = Optional.ofNullable(expiresAt);
      return this;
    }

    public Builder expiresAt(Nullable<OffsetDateTime> expiresAt) {
      if (expiresAt.isNull()) {
        this.expiresAt = null;
      }
      else if (expiresAt.isEmpty()) {
        this.expiresAt = Optional.empty();
      }
      else {
        this.expiresAt = Optional.of(expiresAt.get());
      }
      return this;
    }

    public ContextInstanceState build() {
      return new ContextInstanceState(context, state, derived, status, have, need, createdAt, updatedAt, expiresAt, additionalProperties);
    }
  }
}
