/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ContextListItem.Builder.class
)
public final class ContextListItem implements IContextBase {
  private final Optional<String> id;

  private final Optional<String> name;

  private final Optional<String> slug;

  private final Optional<String> description;

  private final Optional<Boolean> autoExecuteDecisions;

  private final Optional<Integer> ttlSeconds;

  private final Optional<Integer> historyLimit;

  private final Optional<ContextBaseOnSchemaMismatch> onSchemaMismatch;

  private final Optional<String> webhookOnSolve;

  private final Optional<String> webhookOnExpire;

  private final Optional<String> identityFact;

  private final Optional<ContextSchema> schema;

  private final Optional<ContextListItemFolder> folder;

  private final Optional<Integer> boundRulesCount;

  private final Optional<Integer> boundFlowsCount;

  private final Optional<Integer> relationshipsCount;

  private final Optional<OffsetDateTime> createdAt;

  private final Optional<OffsetDateTime> updatedAt;

  private final Map<String, Object> additionalProperties;

  private ContextListItem(Optional<String> id, Optional<String> name, Optional<String> slug,
      Optional<String> description, Optional<Boolean> autoExecuteDecisions,
      Optional<Integer> ttlSeconds, Optional<Integer> historyLimit,
      Optional<ContextBaseOnSchemaMismatch> onSchemaMismatch, Optional<String> webhookOnSolve,
      Optional<String> webhookOnExpire, Optional<String> identityFact,
      Optional<ContextSchema> schema, Optional<ContextListItemFolder> folder,
      Optional<Integer> boundRulesCount, Optional<Integer> boundFlowsCount,
      Optional<Integer> relationshipsCount, Optional<OffsetDateTime> createdAt,
      Optional<OffsetDateTime> updatedAt, Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.slug = slug;
    this.description = description;
    this.autoExecuteDecisions = autoExecuteDecisions;
    this.ttlSeconds = ttlSeconds;
    this.historyLimit = historyLimit;
    this.onSchemaMismatch = onSchemaMismatch;
    this.webhookOnSolve = webhookOnSolve;
    this.webhookOnExpire = webhookOnExpire;
    this.identityFact = identityFact;
    this.schema = schema;
    this.folder = folder;
    this.boundRulesCount = boundRulesCount;
    this.boundFlowsCount = boundFlowsCount;
    this.relationshipsCount = relationshipsCount;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The unique identifier for the context.
   */
  @JsonProperty("id")
  @java.lang.Override
  public Optional<String> getId() {
    return id;
  }

  /**
   * @return The name of the context.
   */
  @JsonProperty("name")
  @java.lang.Override
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return The unique slug for the context used in API requests.
   */
  @JsonProperty("slug")
  @java.lang.Override
  public Optional<String> getSlug() {
    return slug;
  }

  /**
   * @return The description of the context.
   */
  @JsonProperty("description")
  @java.lang.Override
  public Optional<String> getDescription() {
    return description;
  }

  /**
   * @return When true, bound rules and flows automatically execute when their inputs are satisfied. When false, users must manually call /solve or /flows endpoints.
   */
  @JsonProperty("auto_execute_decisions")
  @java.lang.Override
  public Optional<Boolean> getAutoExecuteDecisions() {
    return autoExecuteDecisions;
  }

  /**
   * @return Time-to-live in seconds for live context instances. Instances expire after this duration.
   */
  @JsonIgnore
  @java.lang.Override
  public Optional<Integer> getTtlSeconds() {
    if (ttlSeconds == null) {
      return Optional.empty();
    }
    return ttlSeconds;
  }

  /**
   * @return Maximum number of history entries to retain per field.
   */
  @JsonProperty("history_limit")
  @java.lang.Override
  public Optional<Integer> getHistoryLimit() {
    return historyLimit;
  }

  /**
   * @return How to handle fields that don't match the schema: 'ignore' filters them out, 'reject' returns an error.
   */
  @JsonProperty("on_schema_mismatch")
  public Optional<ContextBaseOnSchemaMismatch> getOnSchemaMismatch() {
    return onSchemaMismatch;
  }

  /**
   * @return Webhook URL called when a rule or flow successfully solves for a live context.
   */
  @JsonIgnore
  @java.lang.Override
  public Optional<String> getWebhookOnSolve() {
    if (webhookOnSolve == null) {
      return Optional.empty();
    }
    return webhookOnSolve;
  }

  /**
   * @return Webhook URL called when a live context expires due to TTL.
   */
  @JsonIgnore
  @java.lang.Override
  public Optional<String> getWebhookOnExpire() {
    if (webhookOnExpire == null) {
      return Optional.empty();
    }
    return webhookOnExpire;
  }

  /**
   * @return The field key used as the unique identifier for instances.
   */
  @JsonIgnore
  public Optional<String> getIdentityFact() {
    if (identityFact == null) {
      return Optional.empty();
    }
    return identityFact;
  }

  @JsonProperty("schema")
  public Optional<ContextSchema> getSchema() {
    return schema;
  }

  @JsonIgnore
  public Optional<ContextListItemFolder> getFolder() {
    if (folder == null) {
      return Optional.empty();
    }
    return folder;
  }

  /**
   * @return Number of rules bound to this context.
   */
  @JsonProperty("bound_rules_count")
  public Optional<Integer> getBoundRulesCount() {
    return boundRulesCount;
  }

  /**
   * @return Number of flows bound to this context.
   */
  @JsonProperty("bound_flows_count")
  public Optional<Integer> getBoundFlowsCount() {
    return boundFlowsCount;
  }

  /**
   * @return Total number of relationships for this context.
   */
  @JsonProperty("relationships_count")
  public Optional<Integer> getRelationshipsCount() {
    return relationshipsCount;
  }

  @JsonProperty("created_at")
  public Optional<OffsetDateTime> getCreatedAt() {
    return createdAt;
  }

  @JsonProperty("updated_at")
  public Optional<OffsetDateTime> getUpdatedAt() {
    return updatedAt;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("ttl_seconds")
  private Optional<Integer> _getTtlSeconds() {
    return ttlSeconds;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("webhook_on_solve")
  private Optional<String> _getWebhookOnSolve() {
    return webhookOnSolve;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("webhook_on_expire")
  private Optional<String> _getWebhookOnExpire() {
    return webhookOnExpire;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("identity_fact")
  private Optional<String> _getIdentityFact() {
    return identityFact;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("folder")
  private Optional<ContextListItemFolder> _getFolder() {
    return folder;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ContextListItem && equalTo((ContextListItem) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ContextListItem other) {
    return id.equals(other.id) && name.equals(other.name) && slug.equals(other.slug) && description.equals(other.description) && autoExecuteDecisions.equals(other.autoExecuteDecisions) && ttlSeconds.equals(other.ttlSeconds) && historyLimit.equals(other.historyLimit) && onSchemaMismatch.equals(other.onSchemaMismatch) && webhookOnSolve.equals(other.webhookOnSolve) && webhookOnExpire.equals(other.webhookOnExpire) && identityFact.equals(other.identityFact) && schema.equals(other.schema) && folder.equals(other.folder) && boundRulesCount.equals(other.boundRulesCount) && boundFlowsCount.equals(other.boundFlowsCount) && relationshipsCount.equals(other.relationshipsCount) && createdAt.equals(other.createdAt) && updatedAt.equals(other.updatedAt);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.slug, this.description, this.autoExecuteDecisions, this.ttlSeconds, this.historyLimit, this.onSchemaMismatch, this.webhookOnSolve, this.webhookOnExpire, this.identityFact, this.schema, this.folder, this.boundRulesCount, this.boundFlowsCount, this.relationshipsCount, this.createdAt, this.updatedAt);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> id = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> slug = Optional.empty();

    private Optional<String> description = Optional.empty();

    private Optional<Boolean> autoExecuteDecisions = Optional.empty();

    private Optional<Integer> ttlSeconds = Optional.empty();

    private Optional<Integer> historyLimit = Optional.empty();

    private Optional<ContextBaseOnSchemaMismatch> onSchemaMismatch = Optional.empty();

    private Optional<String> webhookOnSolve = Optional.empty();

    private Optional<String> webhookOnExpire = Optional.empty();

    private Optional<String> identityFact = Optional.empty();

    private Optional<ContextSchema> schema = Optional.empty();

    private Optional<ContextListItemFolder> folder = Optional.empty();

    private Optional<Integer> boundRulesCount = Optional.empty();

    private Optional<Integer> boundFlowsCount = Optional.empty();

    private Optional<Integer> relationshipsCount = Optional.empty();

    private Optional<OffsetDateTime> createdAt = Optional.empty();

    private Optional<OffsetDateTime> updatedAt = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ContextListItem other) {
      id(other.getId());
      name(other.getName());
      slug(other.getSlug());
      description(other.getDescription());
      autoExecuteDecisions(other.getAutoExecuteDecisions());
      ttlSeconds(other.getTtlSeconds());
      historyLimit(other.getHistoryLimit());
      onSchemaMismatch(other.getOnSchemaMismatch());
      webhookOnSolve(other.getWebhookOnSolve());
      webhookOnExpire(other.getWebhookOnExpire());
      identityFact(other.getIdentityFact());
      schema(other.getSchema());
      folder(other.getFolder());
      boundRulesCount(other.getBoundRulesCount());
      boundFlowsCount(other.getBoundFlowsCount());
      relationshipsCount(other.getRelationshipsCount());
      createdAt(other.getCreatedAt());
      updatedAt(other.getUpdatedAt());
      return this;
    }

    /**
     * <p>The unique identifier for the context.</p>
     */
    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public Builder id(Optional<String> id) {
      this.id = id;
      return this;
    }

    public Builder id(String id) {
      this.id = Optional.ofNullable(id);
      return this;
    }

    /**
     * <p>The name of the context.</p>
     */
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    /**
     * <p>The unique slug for the context used in API requests.</p>
     */
    @JsonSetter(
        value = "slug",
        nulls = Nulls.SKIP
    )
    public Builder slug(Optional<String> slug) {
      this.slug = slug;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = Optional.ofNullable(slug);
      return this;
    }

    /**
     * <p>The description of the context.</p>
     */
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public Builder description(Optional<String> description) {
      this.description = description;
      return this;
    }

    public Builder description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    /**
     * <p>When true, bound rules and flows automatically execute when their inputs are satisfied. When false, users must manually call /solve or /flows endpoints.</p>
     */
    @JsonSetter(
        value = "auto_execute_decisions",
        nulls = Nulls.SKIP
    )
    public Builder autoExecuteDecisions(Optional<Boolean> autoExecuteDecisions) {
      this.autoExecuteDecisions = autoExecuteDecisions;
      return this;
    }

    public Builder autoExecuteDecisions(Boolean autoExecuteDecisions) {
      this.autoExecuteDecisions = Optional.ofNullable(autoExecuteDecisions);
      return this;
    }

    /**
     * <p>Time-to-live in seconds for live context instances. Instances expire after this duration.</p>
     */
    @JsonSetter(
        value = "ttl_seconds",
        nulls = Nulls.SKIP
    )
    public Builder ttlSeconds(Optional<Integer> ttlSeconds) {
      this.ttlSeconds = ttlSeconds;
      return this;
    }

    public Builder ttlSeconds(Integer ttlSeconds) {
      this.ttlSeconds = Optional.ofNullable(ttlSeconds);
      return this;
    }

    public Builder ttlSeconds(Nullable<Integer> ttlSeconds) {
      if (ttlSeconds.isNull()) {
        this.ttlSeconds = null;
      }
      else if (ttlSeconds.isEmpty()) {
        this.ttlSeconds = Optional.empty();
      }
      else {
        this.ttlSeconds = Optional.of(ttlSeconds.get());
      }
      return this;
    }

    /**
     * <p>Maximum number of history entries to retain per field.</p>
     */
    @JsonSetter(
        value = "history_limit",
        nulls = Nulls.SKIP
    )
    public Builder historyLimit(Optional<Integer> historyLimit) {
      this.historyLimit = historyLimit;
      return this;
    }

    public Builder historyLimit(Integer historyLimit) {
      this.historyLimit = Optional.ofNullable(historyLimit);
      return this;
    }

    /**
     * <p>How to handle fields that don't match the schema: 'ignore' filters them out, 'reject' returns an error.</p>
     */
    @JsonSetter(
        value = "on_schema_mismatch",
        nulls = Nulls.SKIP
    )
    public Builder onSchemaMismatch(Optional<ContextBaseOnSchemaMismatch> onSchemaMismatch) {
      this.onSchemaMismatch = onSchemaMismatch;
      return this;
    }

    public Builder onSchemaMismatch(ContextBaseOnSchemaMismatch onSchemaMismatch) {
      this.onSchemaMismatch = Optional.ofNullable(onSchemaMismatch);
      return this;
    }

    /**
     * <p>Webhook URL called when a rule or flow successfully solves for a live context.</p>
     */
    @JsonSetter(
        value = "webhook_on_solve",
        nulls = Nulls.SKIP
    )
    public Builder webhookOnSolve(Optional<String> webhookOnSolve) {
      this.webhookOnSolve = webhookOnSolve;
      return this;
    }

    public Builder webhookOnSolve(String webhookOnSolve) {
      this.webhookOnSolve = Optional.ofNullable(webhookOnSolve);
      return this;
    }

    public Builder webhookOnSolve(Nullable<String> webhookOnSolve) {
      if (webhookOnSolve.isNull()) {
        this.webhookOnSolve = null;
      }
      else if (webhookOnSolve.isEmpty()) {
        this.webhookOnSolve = Optional.empty();
      }
      else {
        this.webhookOnSolve = Optional.of(webhookOnSolve.get());
      }
      return this;
    }

    /**
     * <p>Webhook URL called when a live context expires due to TTL.</p>
     */
    @JsonSetter(
        value = "webhook_on_expire",
        nulls = Nulls.SKIP
    )
    public Builder webhookOnExpire(Optional<String> webhookOnExpire) {
      this.webhookOnExpire = webhookOnExpire;
      return this;
    }

    public Builder webhookOnExpire(String webhookOnExpire) {
      this.webhookOnExpire = Optional.ofNullable(webhookOnExpire);
      return this;
    }

    public Builder webhookOnExpire(Nullable<String> webhookOnExpire) {
      if (webhookOnExpire.isNull()) {
        this.webhookOnExpire = null;
      }
      else if (webhookOnExpire.isEmpty()) {
        this.webhookOnExpire = Optional.empty();
      }
      else {
        this.webhookOnExpire = Optional.of(webhookOnExpire.get());
      }
      return this;
    }

    /**
     * <p>The field key used as the unique identifier for instances.</p>
     */
    @JsonSetter(
        value = "identity_fact",
        nulls = Nulls.SKIP
    )
    public Builder identityFact(Optional<String> identityFact) {
      this.identityFact = identityFact;
      return this;
    }

    public Builder identityFact(String identityFact) {
      this.identityFact = Optional.ofNullable(identityFact);
      return this;
    }

    public Builder identityFact(Nullable<String> identityFact) {
      if (identityFact.isNull()) {
        this.identityFact = null;
      }
      else if (identityFact.isEmpty()) {
        this.identityFact = Optional.empty();
      }
      else {
        this.identityFact = Optional.of(identityFact.get());
      }
      return this;
    }

    @JsonSetter(
        value = "schema",
        nulls = Nulls.SKIP
    )
    public Builder schema(Optional<ContextSchema> schema) {
      this.schema = schema;
      return this;
    }

    public Builder schema(ContextSchema schema) {
      this.schema = Optional.ofNullable(schema);
      return this;
    }

    @JsonSetter(
        value = "folder",
        nulls = Nulls.SKIP
    )
    public Builder folder(Optional<ContextListItemFolder> folder) {
      this.folder = folder;
      return this;
    }

    public Builder folder(ContextListItemFolder folder) {
      this.folder = Optional.ofNullable(folder);
      return this;
    }

    public Builder folder(Nullable<ContextListItemFolder> folder) {
      if (folder.isNull()) {
        this.folder = null;
      }
      else if (folder.isEmpty()) {
        this.folder = Optional.empty();
      }
      else {
        this.folder = Optional.of(folder.get());
      }
      return this;
    }

    /**
     * <p>Number of rules bound to this context.</p>
     */
    @JsonSetter(
        value = "bound_rules_count",
        nulls = Nulls.SKIP
    )
    public Builder boundRulesCount(Optional<Integer> boundRulesCount) {
      this.boundRulesCount = boundRulesCount;
      return this;
    }

    public Builder boundRulesCount(Integer boundRulesCount) {
      this.boundRulesCount = Optional.ofNullable(boundRulesCount);
      return this;
    }

    /**
     * <p>Number of flows bound to this context.</p>
     */
    @JsonSetter(
        value = "bound_flows_count",
        nulls = Nulls.SKIP
    )
    public Builder boundFlowsCount(Optional<Integer> boundFlowsCount) {
      this.boundFlowsCount = boundFlowsCount;
      return this;
    }

    public Builder boundFlowsCount(Integer boundFlowsCount) {
      this.boundFlowsCount = Optional.ofNullable(boundFlowsCount);
      return this;
    }

    /**
     * <p>Total number of relationships for this context.</p>
     */
    @JsonSetter(
        value = "relationships_count",
        nulls = Nulls.SKIP
    )
    public Builder relationshipsCount(Optional<Integer> relationshipsCount) {
      this.relationshipsCount = relationshipsCount;
      return this;
    }

    public Builder relationshipsCount(Integer relationshipsCount) {
      this.relationshipsCount = Optional.ofNullable(relationshipsCount);
      return this;
    }

    @JsonSetter(
        value = "created_at",
        nulls = Nulls.SKIP
    )
    public Builder createdAt(Optional<OffsetDateTime> createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = Optional.ofNullable(createdAt);
      return this;
    }

    @JsonSetter(
        value = "updated_at",
        nulls = Nulls.SKIP
    )
    public Builder updatedAt(Optional<OffsetDateTime> updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    public Builder updatedAt(OffsetDateTime updatedAt) {
      this.updatedAt = Optional.ofNullable(updatedAt);
      return this;
    }

    public ContextListItem build() {
      return new ContextListItem(id, name, slug, description, autoExecuteDecisions, ttlSeconds, historyLimit, onSchemaMismatch, webhookOnSolve, webhookOnExpire, identityFact, schema, folder, boundRulesCount, boundFlowsCount, relationshipsCount, createdAt, updatedAt, additionalProperties);
    }
  }
}
