/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ContextRelationshipBase.Builder.class
)
public final class ContextRelationshipBase implements IContextRelationshipBase {
  private final Optional<String> id;

  private final Optional<ContextRelationshipBaseType> type;

  private final Optional<String> foreignKey;

  private final Optional<String> name;

  private final Optional<String> description;

  private final Optional<OffsetDateTime> createdAt;

  private final Map<String, Object> additionalProperties;

  private ContextRelationshipBase(Optional<String> id, Optional<ContextRelationshipBaseType> type,
      Optional<String> foreignKey, Optional<String> name, Optional<String> description,
      Optional<OffsetDateTime> createdAt, Map<String, Object> additionalProperties) {
    this.id = id;
    this.type = type;
    this.foreignKey = foreignKey;
    this.name = name;
    this.description = description;
    this.createdAt = createdAt;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The unique identifier for the relationship.
   */
  @JsonProperty("id")
  @java.lang.Override
  public Optional<String> getId() {
    return id;
  }

  /**
   * @return The type of relationship.
   */
  @JsonProperty("type")
  public Optional<ContextRelationshipBaseType> getType() {
    return type;
  }

  /**
   * @return The field key used as the foreign key.
   */
  @JsonProperty("foreign_key")
  @java.lang.Override
  public Optional<String> getForeignKey() {
    return foreignKey;
  }

  /**
   * @return Display name for the relationship.
   */
  @JsonProperty("name")
  @java.lang.Override
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return Description of the relationship.
   */
  @JsonProperty("description")
  @java.lang.Override
  public Optional<String> getDescription() {
    return description;
  }

  /**
   * @return When the relationship was created.
   */
  @JsonProperty("created_at")
  @java.lang.Override
  public Optional<OffsetDateTime> getCreatedAt() {
    return createdAt;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ContextRelationshipBase && equalTo((ContextRelationshipBase) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ContextRelationshipBase other) {
    return id.equals(other.id) && type.equals(other.type) && foreignKey.equals(other.foreignKey) && name.equals(other.name) && description.equals(other.description) && createdAt.equals(other.createdAt);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.type, this.foreignKey, this.name, this.description, this.createdAt);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> id = Optional.empty();

    private Optional<ContextRelationshipBaseType> type = Optional.empty();

    private Optional<String> foreignKey = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> description = Optional.empty();

    private Optional<OffsetDateTime> createdAt = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ContextRelationshipBase other) {
      id(other.getId());
      type(other.getType());
      foreignKey(other.getForeignKey());
      name(other.getName());
      description(other.getDescription());
      createdAt(other.getCreatedAt());
      return this;
    }

    /**
     * <p>The unique identifier for the relationship.</p>
     */
    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public Builder id(Optional<String> id) {
      this.id = id;
      return this;
    }

    public Builder id(String id) {
      this.id = Optional.ofNullable(id);
      return this;
    }

    /**
     * <p>The type of relationship.</p>
     */
    @JsonSetter(
        value = "type",
        nulls = Nulls.SKIP
    )
    public Builder type(Optional<ContextRelationshipBaseType> type) {
      this.type = type;
      return this;
    }

    public Builder type(ContextRelationshipBaseType type) {
      this.type = Optional.ofNullable(type);
      return this;
    }

    /**
     * <p>The field key used as the foreign key.</p>
     */
    @JsonSetter(
        value = "foreign_key",
        nulls = Nulls.SKIP
    )
    public Builder foreignKey(Optional<String> foreignKey) {
      this.foreignKey = foreignKey;
      return this;
    }

    public Builder foreignKey(String foreignKey) {
      this.foreignKey = Optional.ofNullable(foreignKey);
      return this;
    }

    /**
     * <p>Display name for the relationship.</p>
     */
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    /**
     * <p>Description of the relationship.</p>
     */
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public Builder description(Optional<String> description) {
      this.description = description;
      return this;
    }

    public Builder description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    /**
     * <p>When the relationship was created.</p>
     */
    @JsonSetter(
        value = "created_at",
        nulls = Nulls.SKIP
    )
    public Builder createdAt(Optional<OffsetDateTime> createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = Optional.ofNullable(createdAt);
      return this;
    }

    public ContextRelationshipBase build() {
      return new ContextRelationshipBase(id, type, foreignKey, name, description, createdAt, additionalProperties);
    }
  }
}
