/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ContextSchema.Builder.class
)
public final class ContextSchema {
  private final Optional<List<ContextSchemaField>> base;

  private final Optional<List<ContextSchemaField>> derived;

  private final Map<String, Object> additionalProperties;

  private ContextSchema(Optional<List<ContextSchemaField>> base,
      Optional<List<ContextSchemaField>> derived, Map<String, Object> additionalProperties) {
    this.base = base;
    this.derived = derived;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return User-defined base fields for the context.
   */
  @JsonProperty("base")
  public Optional<List<ContextSchemaField>> getBase() {
    return base;
  }

  /**
   * @return Fields derived from bound rule/flow outputs.
   */
  @JsonProperty("derived")
  public Optional<List<ContextSchemaField>> getDerived() {
    return derived;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ContextSchema && equalTo((ContextSchema) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ContextSchema other) {
    return base.equals(other.base) && derived.equals(other.derived);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.base, this.derived);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<List<ContextSchemaField>> base = Optional.empty();

    private Optional<List<ContextSchemaField>> derived = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ContextSchema other) {
      base(other.getBase());
      derived(other.getDerived());
      return this;
    }

    /**
     * <p>User-defined base fields for the context.</p>
     */
    @JsonSetter(
        value = "base",
        nulls = Nulls.SKIP
    )
    public Builder base(Optional<List<ContextSchemaField>> base) {
      this.base = base;
      return this;
    }

    public Builder base(List<ContextSchemaField> base) {
      this.base = Optional.ofNullable(base);
      return this;
    }

    /**
     * <p>Fields derived from bound rule/flow outputs.</p>
     */
    @JsonSetter(
        value = "derived",
        nulls = Nulls.SKIP
    )
    public Builder derived(Optional<List<ContextSchemaField>> derived) {
      this.derived = derived;
      return this;
    }

    public Builder derived(List<ContextSchemaField> derived) {
      this.derived = Optional.ofNullable(derived);
      return this;
    }

    public ContextSchema build() {
      return new ContextSchema(base, derived, additionalProperties);
    }
  }
}
